#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <sys/types.h>
#include <dirent.h>
#include <errno.h>
#include <unistd.h>

pthread_barrier_t bar;


void* tester(void *arg)
{
	struct dirent *en;
	DIR *d = opendir("/");

	pthread_barrier_wait(&bar);

	while ( (en = readdir(d)) != NULL )
	{
		if (errno != 0)
		{
			perror("thread tester error: ");
			exit(1);
		}
	}

	if (!en)
	{
		perror("thread tester error: ");
		exit(1);
	}
	
}

void* checker(void *arg)
{
	pthread_barrier_wait(&bar);
	printf("Passed barrier!\n");
}


int main(int argc, char *argv[])
{
	int i, ret, nthreads;
	pthread_t th;

	if (argc <= 1)
	{
		printf("Need one argument\n");
		exit(1);
	}

	nthreads = atoi(argv[1]);
	
	printf("Trying with %d threads\n", nthreads);	

	if ( (ret = pthread_barrier_init(&bar, NULL, nthreads)) != 0)
	{
		printf("error occured during pthread_barrier_init, ret = %d\n", ret);
		perror("Or: ");
		exit(1);
	}

	printf("Creating checker thread\n");
	pthread_create(&th, NULL, checker, NULL);

	printf("Creating tester threads\n");


	for (i = 0; i < nthreads; i++)
		pthread_create(&th, NULL, tester, NULL);

	for (;;)
	{
		sleep(1000);
	}

	return 0;
}
