--- mount_hammer.c_orig	2009-10-21 11:27:24 +0200
+++ mount_hammer.c	2009-10-21 13:18:15 +0200
@@ -39,7 +39,9 @@
 #include <sys/diskmbr.h>
 #include <sys/stat.h>
 #include <sys/time.h>
+#include <sys/syslimits.h>
 #include <vfs/hammer/hammer_mount.h>
+#include <vfs/hammer/hammer_disk.h>
 
 #include <stdio.h>
 #include <stdlib.h>
@@ -81,8 +83,10 @@
 	int error;
 	int ch;
 	int init_flags = 0;
+	int ax;
 	char *mountpt;
 	char *ptr;
+	char fdevs[PATH_MAX*HAMMER_MAX_VOLUMES+PATH_MAX-1]; /* this is ugly, memory should be allocated dynamically */
 
 	bzero(&info, sizeof(info));
 	info.asof = 0;
@@ -138,7 +142,7 @@
 		}
 		mountpt = av[0];
 		if (mount(vfc.vfc_name, mountpt, mount_flags, &info))
-			err(1, NULL);
+			err(1, "mountpoint %s", mountpt);
 		exit(0);
 	}
 
@@ -167,8 +171,16 @@
 	if (error)
 		errx(1, "hammer filesystem is not available");
 
-	if (mount(vfc.vfc_name, mountpt, mount_flags, &info))
-		err(1, NULL);
+
+	if (mount(vfc.vfc_name, mountpt, mount_flags, &info)) {
+		/* Build fdevs in case of error to report failed devices */
+		for (ax = 0; ax < ac - 1; ax++) {
+			strlcat(fdevs, info.volumes[ax], sizeof(fdevs));
+			if (ax < ac - 2)
+			strlcat(fdevs, " ", sizeof(fdevs));
+		}
+		err(1,"mount %s on %s", fdevs, mountpt) ;
+	}
 	exit(0);
 }
 
