/*
 * Intel ACPI Component Architecture
 * AML/ASL+ Disassembler version 20141107-64 [Nov 20 2014]
 * Copyright (c) 2000 - 2014 Intel Corporation
 * 
 * Disassembling to symbolic ASL+ operators
 *
 * Disassembly of dsdt.dat, Thu Nov 20 18:27:21 2014
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x0000A89E (43166)
 *     Revision         0x01 **** 32-bit table (V1), no 64-bit math support
 *     Checksum         0xFE
 *     OEM ID           "ITRXGD"
 *     OEM Table ID     "ITXGDTBL"
 *     OEM Revision     0x00000001 (1)
 *     Compiler ID      "MSFT"
 *     Compiler Version 0x01000013 (16777235)
 */
DefinitionBlock ("dsdt.aml", "DSDT", 1, "ITRXGD", "ITXGDTBL", 0x00000001)
{
    OperationRegion (PORT, SystemIO, 0x80, One)
    Field (PORT, ByteAcc, NoLock, Preserve)
    {
        P80H,   8
    }

    OperationRegion (GPIO, SystemIO, 0x0500, 0x40)
    Field (GPIO, ByteAcc, NoLock, Preserve)
    {
        GU00,   8, 
        GU01,   8, 
        GU02,   8, 
        GU03,   8, 
        GIO0,   8, 
        GIO1,   8, 
        GIO2,   8, 
        GIO3,   8, 
        Offset (0x0C), 
        GL00,   8, 
        GL01,   8, 
        GL02,   8, 
        GL03,   8, 
        Offset (0x18), 
        GB00,   8, 
        GB01,   8, 
        GB02,   8, 
        GB03,   8, 
        Offset (0x2C), 
        GIV0,   8, 
        GIV1,   8, 
        GIV2,   8, 
        GIV3,   8, 
        GU04,   8, 
        GU05,   8, 
        GU06,   8, 
        GU07,   8, 
        GIO4,   8, 
        GIO5,   8, 
        GIO6,   8, 
        GIO7,   8, 
        GL04,   8, 
        GL05,   8, 
        GL06,   8, 
        GL07,   8
    }

    OperationRegion (PMBA, SystemIO, 0x0400, 0x80)
    Field (PMBA, ByteAcc, NoLock, Preserve)
    {
        Offset (0x28), 
            ,   2, 
        SPST,   1, 
        Offset (0x42), 
            ,   1, 
        GPEC,   1, 
        Offset (0x64), 
            ,   9, 
        SCIS,   1, 
        Offset (0x66)
    }

    OperationRegion (RCRB, SystemMemory, 0xFED1C000, 0x4000)
    Field (RCRB, DWordAcc, Lock, Preserve)
    {
        Offset (0x1000), 
        Offset (0x3000), 
        Offset (0x3404), 
        HPAS,   2, 
            ,   5, 
        HPAE,   1, 
        Offset (0x3418), 
            ,   1, 
        PATD,   1, 
        SATD,   1, 
        SMBD,   1, 
        HDAD,   1, 
        Offset (0x341A), 
        RP1D,   1, 
        RP2D,   1, 
        RP3D,   1, 
        RP4D,   1, 
        RP5D,   1, 
        RP6D,   1, 
        Offset (0x3518), 
        PDO0,   1, 
        PDO1,   1, 
        PDO2,   1, 
        PDO3,   1, 
        PDO4,   1, 
        PDO5,   1, 
        PDO6,   1, 
        PDO7,   1, 
        PDO8,   1, 
        PDO9,   1, 
        Offset (0x351A), 
        Offset (0x3524), 
        PPO0,   1, 
        PPO1,   1, 
        PPO2,   1, 
        PPO3,   1, 
        PPO4,   1, 
        PPO5,   1, 
        PPO6,   1, 
        PPO7,   1, 
        PPO8,   1, 
        PPO9,   1
    }

    OperationRegion (MBOX, SystemMemory, 0xBF6BCE10, 0x00000142)
    Field (MBOX, AnyAcc, NoLock, Preserve)
    {
        PCI1,   8, 
        PCI2,   8, 
        PCI3,   8, 
        PCI4,   8, 
        PCI5,   8, 
        PCI6,   8, 
        PCI7,   8, 
        PCI8,   8, 
        NLCK,   8, 
        ZIPE,   8, 
        COMA,   8, 
        CAIO,   8, 
        CAIP,   8, 
        CAMD,   8, 
        CADA,   8, 
        COMB,   8, 
        CBIO,   8, 
        CBIP,   8, 
        CBMD,   8, 
        CBDA,   8, 
        LPT1,   8, 
        L1IO,   8, 
        L1IP,   8, 
        L1MD,   8, 
        L1DA,   8, 
        FDDC,   8, 
        FDWP,   8, 
        AZLA,   8, 
        LANE,   8, 
        IDEC,   8, 
        PACT,   8, 
        SCFG,   8, 
        AIBT,   8, 
        AMOD,   8, 
        P0HP,   8, 
        P1HP,   8, 
        P2HP,   8, 
        P0IL,   8, 
        P1IL,   8, 
        P2IL,   8, 
        IDLY,   8, 
        PMTP,   8, 
        PMIO,   8, 
        PMBM,   8, 
        PMTM,   8, 
        PSTP,   8, 
        PSIO,   8, 
        PSBM,   8, 
        PSTM,   8, 
        IDE0,   8, 
        IDE1,   8, 
        IDE2,   8, 
        IDE3,   8, 
        IDE4,   8, 
        IDE5,   8, 
        IDE6,   8, 
        IDE7,   8, 
        PEGS,   8, 
        D2F1,   8, 
        IGMT,   8, 
        DTSZ,   8, 
        CLKC,   8, 
        CKSC,   8, 
        BOTT,   8, 
        PANT,   8, 
        TVTP,   8, 
        NDID,   8, 
        DID1,   32, 
        DID2,   32, 
        DID3,   32, 
        DID4,   32, 
        DID5,   32, 
        LUBS,   8, 
        U201,   8, 
        U202,   8, 
        U111,   8, 
        U112,   8, 
        U113,   8, 
        U114,   8, 
        U115,   8, 
        UPPC,   8, 
        UP00,   8, 
        UP01,   8, 
        UP02,   8, 
        UP03,   8, 
        UP04,   8, 
        UP05,   8, 
        UP06,   8, 
        UP07,   8, 
        UP08,   8, 
        UP09,   8, 
        P80R,   8, 
        IBTT,   8, 
        IPAT,   8, 
        ITVF,   8, 
        ITVM,   8, 
        IPSC,   8, 
        IBLC,   8, 
        IBIA,   8, 
        ISSC,   8, 
        I409,   8, 
        I509,   8, 
        I609,   8, 
        I709,   8, 
        IDMM,   8, 
        IDMS,   8, 
        IF1E,   8, 
        GSMI,   8, 
        HVCO,   8, 
        PLYT,   8, 
        EDCG,   8, 
        SDFY,   8, 
        SDTC,   8, 
        SDRP,   8, 
        SDCL,   8, 
        SDRC,   8, 
        SDRE,   8, 
        FC2L,   8, 
        FC3L,   8, 
        FCS4,   8, 
        APIM,   8, 
        HPTS,   8, 
        HPTA,   8, 
        EMAS,   8, 
        MASF,   8, 
        WDOG,   8, 
        WDTO,   16, 
        WDTB,   16, 
        MAMT,   8, 
        ABXP,   8, 
        SPIL,   8, 
        PWDW,   8, 
        HETO,   8, 
        AWTR,   16, 
        EOPT,   8, 
        ASFB,   8, 
        MBTX,   8, 
        IDER,   8, 
        SOLE,   8, 
        EYLS,   8, 
        EYLH,   8, 
        TPMD,   8, 
        TPMO,   8, 
        TPMC,   8, 
        TPMM,   8, 
        TPCC,   8, 
        TPLC,   8, 
        TPLR,   32, 
        ISTC,   8, 
        TRML,   8, 
        FNON,   8, 
        TRON,   8, 
        NXMD,   8, 
        PCRR,   8, 
        C4EN,   8, 
        C43D,   8, 
        DAS1,   8, 
        DAS3,   8, 
        WKPM,   8, 
        WKMD,   8, 
        WKS5,   8, 
        HOUR,   8, 
        MINS,   8, 
        SECS,   8, 
        DOFM,   8, 
        QKS4,   8, 
        POPU,   8, 
        POPD,   8, 
        NXFE,   8, 
        VTST,   8, 
        VTFE,   8, 
        S5FG,   8, 
        CSTS,   8, 
        ENCS,   8, 
        DEC4,   8, 
        HC4E,   8, 
        CSTR,   8, 
        CMPE,   8, 
        DTSE,   8, 
        DTSC,   8, 
        QBOT,   8, 
        BOTQ,   8, 
        PBOT,   8, 
        RAID,   8, 
        OSYS,   16, 
        DVGM,   16, 
        SBTE,   8, 
        SWWE,   8, 
        SWLE,   8, 
        SMDE,   8, 
        SUBE,   8, 
        SLNE,   8, 
        SXPE,   8, 
        SSPE,   8, 
        SPPE,   8, 
        SMBE,   8, 
        SCBE,   8, 
        SSCE,   8, 
        SOHE,   8, 
        OBTE,   8, 
        OWWE,   8, 
        OWLE,   8, 
        OMDE,   8, 
        OUBE,   8, 
        OLNE,   8, 
        OXPE,   8, 
        OSPE,   8, 
        OPPE,   8, 
        OMBE,   8, 
        OCBE,   8, 
        OSCE,   8, 
        OOHE,   8, 
        SENA,   8, 
        SDIA,   8, 
        SPON,   8, 
        DBRD,   8, 
        SMON,   8, 
        SLED,   8, 
        SFAN,   8, 
        SADO,   8, 
        SBBR,   8, 
        SWRO,   8
    }

    OperationRegion (CMS1, SystemIO, 0x72, 0x02)
    Field (CMS1, ByteAcc, NoLock, Preserve)
    {
        CMSI,   8, 
        CMSD,   8
    }

    Method (CMSW, 2, NotSerialized)
    {
        CMSI = Arg0
        CMSD = Arg1
    }

    Method (CMSR, 1, NotSerialized)
    {
        CMSI = Arg0
        Return (CMSD) /* \CMSD */
    }

    OperationRegion (IO_T, SystemIO, 0x0800, 0x10)
    Field (IO_T, ByteAcc, NoLock, Preserve)
    {
        Offset (0x02), 
        Offset (0x04), 
        Offset (0x06), 
        Offset (0x08), 
        TRP0,   8, 
        Offset (0x0A), 
        Offset (0x0B), 
        Offset (0x0C), 
        Offset (0x0D), 
        Offset (0x0E), 
        Offset (0x0F), 
        Offset (0x10)
    }

    OperationRegion (IO_D, SystemIO, 0x0810, 0x08)
    Field (IO_D, ByteAcc, NoLock, Preserve)
    {
        TRPD,   8
    }

    OperationRegion (NVST, SystemMemory, 0xBF6BCF52, 0x00000030)
    Field (NVST, AnyAcc, Lock, Preserve)
    {
        SMIF,   8, 
        PRM0,   8, 
        PRM1,   8, 
        BRTL,   8, 
        TLST,   8, 
        IGDS,   8, 
        LCDA,   16, 
        CSTE,   16, 
        NSTE,   16, 
        CADL,   16, 
        PADL,   16, 
        LIDS,   8, 
        PWRS,   8, 
        BVAL,   32, 
        CMPF,   8, 
        CSTF,   8, 
        GTF0,   56, 
        GTF2,   56, 
        IDEM,   8, 
        DTS1,   8, 
        DTS2,   8, 
        DTSF,   8, 
        PPMF,   32, 
        OSY1,   16
    }

    Mutex (MSMI, 0x07)
    Method (PHSR, 2, NotSerialized)
    {
        Acquire (MSMI, 0xFFFF)
        PRM0 = Arg1
        SMIF = Arg0
        TRP0 = Zero
        Local0 = PRM0 /* \PRM0 */
        Release (MSMI)
        Return (Local0)
    }

    Method (HKEY, 1, NotSerialized)
    {
        PHSR (0x1E, Arg0)
    }

    Method (LAMN, 1, NotSerialized)
    {
        If (\_SB.AMW0.WLMP)
        {
            \_SB.AMW0.WLID = Arg0
            Notify (\_SB.AMW0, 0xB0) // Device-Specific
        }
        Else
        {
            PHSR (0x1F, Arg0)
        }
    }

    Method (RBEC, 1, NotSerialized)
    {
        Return (PHSR (0x20, Arg0))
    }

    Method (WBEC, 2, NotSerialized)
    {
        Acquire (MSMI, 0xFFFF)
        PRM1 = Arg1
        PRM0 = Arg0
        SMIF = 0x21
        TRP0 = Zero
        Release (MSMI)
    }

    Method (MBEC, 3, NotSerialized)
    {
        Local1 = (RBEC (Arg0) & Arg1)
        Local2 = (Local1 | Arg2)
        WBEC (Arg0, Local2)
    }

    Name (BCLP, Package (0x12)
    {
        0x64, 
        0x3C, 
        Zero, 
        0x1E, 
        0x23, 
        0x28, 
        0x2D, 
        0x32, 
        0x37, 
        0x3C, 
        0x41, 
        0x46, 
        0x4B, 
        0x50, 
        0x55, 
        0x5A, 
        0x5F, 
        0x64
    })
    Name (MAXL, 0x11)
    Method (BIAN, 1, NotSerialized)
    {
        If (((DID1 & 0x0F00) == 0x0400))
        {
            Notify (\_SB.PCI0.OVGA.DD01, Arg0)
        }

        If (((DID2 & 0x0F00) == 0x0400))
        {
            Notify (\_SB.PCI0.OVGA.DD02, Arg0)
        }

        If (((DID3 & 0x0F00) == 0x0400))
        {
            Notify (\_SB.PCI0.OVGA.DD03, Arg0)
        }

        If (((DID4 & 0x0F00) == 0x0400))
        {
            Notify (\_SB.PCI0.OVGA.DD04, Arg0)
        }

        If (((DID5 & 0x0F00) == 0x0400))
        {
            Notify (\_SB.PCI0.OVGA.DD05, Arg0)
        }
    }

    Scope (_PR)
    {
        Processor (CPU0, 0x01, 0x00000410, 0x06) {}
        Processor (CPU1, 0x02, 0x00000410, 0x06) {}
    }

    Name (ECON, Zero)
    Name (CTYP, Zero)
    Name (DSEN, One)
    Name (BREB, Zero)
    Method (_PTS, 1, NotSerialized)  // _PTS: Prepare To Sleep
    {
        If ((Arg0 == One))
        {
            P80H = 0x51
        }

        If ((Arg0 == 0x03))
        {
            BREB = \_SB.PCI0.LPC.EC0.BNEN
            P80H = 0x53
        }

        If ((Arg0 == 0x04))
        {
            BREB = \_SB.PCI0.LPC.EC0.BNEN
            CMSW (0x3F, 0x3F)
        }

        \_SB.DOCK.DPTS (Arg0)
        \_SB.PCI0.LPC.EC0.KMUT = One
        Return (Zero)
    }

    Method (_WAK, 1, NotSerialized)  // _WAK: Wake
    {
        If ((Arg0 == One))
        {
            P80H = 0xE1
        }

        OperationRegion (TPMR, SystemMemory, 0xFED40000, 0x5000)
        Field (TPMR, AnyAcc, NoLock, Preserve)
        {
            ACC0,   8
        }

        If (((OSYS > 0x07D1) || (OSYS < 0x07D6)))
        {
            ACC0 |= 0x20
        }

        If ((Arg0 == 0x03))
        {
            \_SB.PCI0.LPC.EC0.BNEN = BREB /* \BREB */
            If ((DTSE && CMPE))
            {
                DTSF = 0x14
                TRPD = Zero
            }

            P80H = 0xE3
        }

        If ((Arg0 == 0x04))
        {
            \_SB.PCI0.LPC.EC0.BNEN = BREB /* \BREB */
            If ((DTSE && CMPE))
            {
                DTSF = 0x14
                TRPD = Zero
            }

            Notify (\_SB.SLPB, 0x02) // Device Wake
        }

        \_SB.DOCK.DWAK (Arg0)
        \_SB.PCI0.LPC.EC0.KTAF = Zero
        Notify (\_SB.PCI0.LPC.EC0.BAT0, 0x81) // Information Change
        If ((RP1D == Zero))
        {
            Notify (\_SB.PCI0.EXP1, Zero) // Bus Check
        }

        If ((RP2D == Zero))
        {
            Notify (\_SB.PCI0.EXP2, Zero) // Bus Check
        }

        If ((RP3D == Zero))
        {
            Notify (\_SB.PCI0.EXP3, Zero) // Bus Check
        }

        If ((RP4D == Zero))
        {
            Notify (\_SB.PCI0.EXP4, Zero) // Bus Check
        }

        If ((RP5D == Zero))
        {
            Notify (\_SB.PCI0.EXP5, Zero) // Bus Check
        }

        If ((RP6D == Zero))
        {
            Notify (\_SB.PCI0.EXP6, Zero) // Bus Check
        }

        Notify (\_SB.PCI0.UHC4, Zero) // Bus Check
        Return (Zero)
    }

    Name (_S0, Package (0x04)  // _S0_: S0 System State
    {
        Zero, 
        Zero, 
        Zero, 
        Zero
    })
    If ((DAS1 == One))
    {
        Name (_S1, Package (0x04)  // _S1_: S1 System State
        {
            One, 
            One, 
            Zero, 
            Zero
        })
    }

    If ((DAS3 == One))
    {
        Name (_S3, Package (0x04)  // _S3_: S3 System State
        {
            0x05, 
            0x05, 
            Zero, 
            Zero
        })
    }

    Name (_S4, Package (0x04)  // _S4_: S4 System State
    {
        0x06, 
        0x06, 
        Zero, 
        Zero
    })
    Name (_S5, Package (0x04)  // _S5_: S5 System State
    {
        0x07, 
        0x07, 
        Zero, 
        Zero
    })
    Scope (_GPE)
    {
        Method (_L01, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            If (((RP1D == Zero) && \_SB.PCI0.EXP1.HPCS))
            {
                Sleep (0x64)
                If (\_SB.PCI0.EXP1.PDC1)
                {
                    \_SB.PCI0.EXP1.PDC1 = One
                    \_SB.PCI0.EXP1.HPCS = One
                    Notify (\_SB.PCI0.EXP1, Zero) // Bus Check
                }
                Else
                {
                    \_SB.PCI0.EXP1.HPCS = One
                }
            }

            If (((RP2D == Zero) && \_SB.PCI0.EXP2.HPCS))
            {
                Sleep (0x64)
                If (\_SB.PCI0.EXP2.PDC2)
                {
                    \_SB.PCI0.EXP2.PDC2 = One
                    \_SB.PCI0.EXP2.HPCS = One
                    Notify (\_SB.PCI0.EXP2, Zero) // Bus Check
                }
                Else
                {
                    \_SB.PCI0.EXP2.HPCS = One
                }
            }

            If (((RP3D == Zero) && \_SB.PCI0.EXP3.HPCS))
            {
                Sleep (0x64)
                If (\_SB.PCI0.EXP3.PDC3)
                {
                    \_SB.PCI0.EXP3.PDC3 = One
                    \_SB.PCI0.EXP3.HPCS = One
                    Notify (\_SB.PCI0.EXP3, Zero) // Bus Check
                }
                Else
                {
                    \_SB.PCI0.EXP3.HPCS = One
                }
            }

            If (((RP4D == Zero) && \_SB.PCI0.EXP4.HPCS))
            {
                Sleep (0x64)
                If (\_SB.PCI0.EXP4.PDC4)
                {
                    \_SB.PCI0.EXP4.PDC4 = One
                    \_SB.PCI0.EXP4.HPCS = One
                    Notify (\_SB.PCI0.EXP4, Zero) // Bus Check
                }
                Else
                {
                    \_SB.PCI0.EXP4.HPCS = One
                }
            }

            If (((RP5D == Zero) && \_SB.PCI0.EXP5.HPCS))
            {
                Sleep (0x64)
                If (\_SB.PCI0.EXP5.PDC5)
                {
                    \_SB.PCI0.EXP5.PDC5 = One
                    \_SB.PCI0.EXP5.HPCS = One
                    Notify (\_SB.PCI0.EXP5, Zero) // Bus Check
                }
                Else
                {
                    \_SB.PCI0.EXP5.HPCS = One
                }
            }

            If (((RP6D == Zero) && \_SB.PCI0.EXP6.HPCS))
            {
                Sleep (0x64)
                If (\_SB.PCI0.EXP6.PDC6)
                {
                    \_SB.PCI0.EXP6.PDC6 = One
                    \_SB.PCI0.EXP6.HPCS = One
                    Notify (\_SB.PCI0.EXP6, Zero) // Bus Check
                }
                Else
                {
                    \_SB.PCI0.EXP6.HPCS = One
                }
            }
        }

        Method (_L02, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            GPEC = Zero
            Notify (\_TZ.TZS0, 0x80) // Thermal Status Change
        }

        Method (_L03, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.UHC1, 0x02) // Device Wake
        }

        Method (_L04, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.UHC2, 0x02) // Device Wake
        }

        Method (_L05, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.UHC5, 0x02) // Device Wake
        }

        Method (_L06, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            If (\_SB.PCI0.OVGA.GSSE)
            {
                \_SB.PCI0.OVGA.GSCI ()
            }
            Else
            {
                SCIS = One
            }
        }

        Method (_L09, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
        }

        Method (_L0B, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.P32, 0x02) // Device Wake
        }

        Method (_L0C, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.UHC3, 0x02) // Device Wake
        }

        Method (_L0D, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.AZAL, 0x02) // Device Wake
        }

        Method (_L0E, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
        {
            Notify (\_SB.PCI0.UHC4, 0x02) // Device Wake
        }
    }

    Name (GPIC, Zero)
    Method (_PIC, 1, NotSerialized)  // _PIC: Interrupt Model
    {
        GPIC = Arg0
    }

    Scope (_TZ)
    {
        Name (TBSE, 0x0AAC)
        Name (LTMP, 0x32)
        Name (PSV0, Zero)
        Name (PSV1, Zero)
        Name (PSV4, Zero)
        Name (CRT0, Zero)
        ThermalZone (TZS0)
        {
            Method (_TMP, 0, NotSerialized)  // _TMP: Temperature
            {
                Sleep (0x03)
                If (ECON)
                {
                    Local0 = \_SB.PCI0.LPC.EC0.KTS0
                }
                Else
                {
                    Local0 = RBEC (0xA8)
                }

                If ((Local0 <= PSV0))
                {
                    If (ECON)
                    {
                        Local1 = \_SB.PCI0.LPC.EC0.KCSS
                    }
                    Else
                    {
                        Local1 = RBEC (0x91)
                        Local1 &= 0x20
                    }

                    If ((Local1 != Zero))
                    {
                        Local0 = (PSV0 + 0x02)
                    }
                }

                If ((Local0 <= CRT0))
                {
                    If (ECON)
                    {
                        If ((\_SB.PCI0.LPC.EC0.KOSD != Zero))
                        {
                            Local0 = (CRT0 + 0x02)
                        }
                    }
                }

                Return (C2K (Local0))
            }

            Method (_CRT, 0, NotSerialized)  // _CRT: Critical Temperature
            {
                Sleep (0x03)
                If (ECON)
                {
                    Acquire (\_SB.PCI0.LPC.EC0.BATM, 0xFFFF)
                    \_SB.PCI0.LPC.EC0.ECID = 0x60
                    Local0 = \_SB.PCI0.LPC.EC0.SCRT
                    Release (\_SB.PCI0.LPC.EC0.BATM)
                }
                Else
                {
                    WBEC (0x57, 0x60)
                    Local0 = RBEC (0xBE)
                }

                CRT0 = Local0
                Return (C2K (Local0))
            }

            Name (_PSL, Package (0x01)  // _PSL: Passive List
            {
                \_PR.CPU0
            })
            Method (_PSV, 0, NotSerialized)  // _PSV: Passive Temperature
            {
                If (ECON)
                {
                    Acquire (\_SB.PCI0.LPC.EC0.BATM, 0xFFFF)
                    \_SB.PCI0.LPC.EC0.ECID = 0x60
                    Local0 = \_SB.PCI0.LPC.EC0.SPSV
                    Release (\_SB.PCI0.LPC.EC0.BATM)
                }
                Else
                {
                    WBEC (0x57, 0x60)
                    Local0 = RBEC (0xBC)
                }

                If (((Local0 >= 0x80) || (Local0 < 0x32)))
                {
                    Local0 = 0x5A
                }

                PSV0 = Local0
                Return (C2K (Local0))
            }

            Name (_TC1, 0x02)  // _TC1: Thermal Constant 1
            Name (_TC2, 0x05)  // _TC2: Thermal Constant 2
            Name (_TSP, 0x012C)  // _TSP: Thermal Sampling Period
        }

        ThermalZone (TZS1)
        {
            Method (_TMP, 0, NotSerialized)  // _TMP: Temperature
            {
                Sleep (0x03)
                If (ECON)
                {
                    Local0 = \_SB.PCI0.LPC.EC0.KTS1
                }
                Else
                {
                    Local0 = RBEC (0xA9)
                }

                If ((Local0 <= PSV1))
                {
                    If (ECON)
                    {
                        Local1 = \_SB.PCI0.LPC.EC0.KCSS
                    }
                    Else
                    {
                        Local1 = RBEC (0x91)
                        Local1 &= 0x20
                    }

                    If ((Local1 != Zero))
                    {
                        Local0 = (PSV1 + 0x02)
                    }
                }

                Return (C2K (Local0))
            }

            Method (_CRT, 0, NotSerialized)  // _CRT: Critical Temperature
            {
                Sleep (0x03)
                If (ECON)
                {
                    Acquire (\_SB.PCI0.LPC.EC0.BATM, 0xFFFF)
                    \_SB.PCI0.LPC.EC0.ECID = 0x61
                    Local0 = \_SB.PCI0.LPC.EC0.SCRT
                    Release (\_SB.PCI0.LPC.EC0.BATM)
                }
                Else
                {
                    WBEC (0x57, 0x61)
                    Local0 = RBEC (0xBE)
                }

                Return (C2K (Local0))
            }

            Name (_PSL, Package (0x01)  // _PSL: Passive List
            {
                \_PR.CPU0
            })
            Method (_PSV, 0, NotSerialized)  // _PSV: Passive Temperature
            {
                Sleep (0x03)
                If (ECON)
                {
                    Acquire (\_SB.PCI0.LPC.EC0.BATM, 0xFFFF)
                    \_SB.PCI0.LPC.EC0.ECID = 0x61
                    Local0 = \_SB.PCI0.LPC.EC0.SPSV
                    Release (\_SB.PCI0.LPC.EC0.BATM)
                }
                Else
                {
                    WBEC (0x57, 0x61)
                    Local0 = RBEC (0xBC)
                }

                If (((Local0 >= 0x80) || (Local0 < 0x32)))
                {
                    Local0 = 0x5A
                }

                PSV1 = Local0
                Return (C2K (Local0))
            }

            Name (_TC1, 0x02)  // _TC1: Thermal Constant 1
            Name (_TC2, 0x05)  // _TC2: Thermal Constant 2
            Name (_TSP, 0x012C)  // _TSP: Thermal Sampling Period
        }

        ThermalZone (TZS3)
        {
            Method (_TMP, 0, NotSerialized)  // _TMP: Temperature
            {
                Sleep (0x03)
                If (ECON)
                {
                    Local0 = \_SB.PCI0.LPC.EC0.KTS3
                }
                Else
                {
                    Local0 = RBEC (0xAB)
                }

                Return (C2K (Local0))
            }

            Method (_CRT, 0, NotSerialized)  // _CRT: Critical Temperature
            {
                Sleep (0x03)
                If (ECON)
                {
                    Acquire (\_SB.PCI0.LPC.EC0.BATM, 0xFFFF)
                    \_SB.PCI0.LPC.EC0.ECID = 0x63
                    Local0 = \_SB.PCI0.LPC.EC0.SCRT
                    Release (\_SB.PCI0.LPC.EC0.BATM)
                }
                Else
                {
                    WBEC (0x57, 0x63)
                    Local0 = RBEC (0xBE)
                }

                Return (C2K (Local0))
            }
        }

        ThermalZone (TZS4)
        {
            Method (_TMP, 0, NotSerialized)  // _TMP: Temperature
            {
                Sleep (0x03)
                If (ECON)
                {
                    Local0 = \_SB.PCI0.LPC.EC0.KTS4
                }
                Else
                {
                    Local0 = RBEC (0xAC)
                }

                If ((Local0 <= PSV4))
                {
                    If (ECON)
                    {
                        Local1 = \_SB.PCI0.LPC.EC0.KCSS
                    }
                    Else
                    {
                        Local1 = RBEC (0x91)
                        Local1 &= 0x20
                    }

                    If ((Local1 != Zero))
                    {
                        Local0 = (PSV4 + 0x02)
                    }
                }

                Return (C2K (Local0))
            }

            Method (_CRT, 0, NotSerialized)  // _CRT: Critical Temperature
            {
                Sleep (0x03)
                If (ECON)
                {
                    Acquire (\_SB.PCI0.LPC.EC0.BATM, 0xFFFF)
                    \_SB.PCI0.LPC.EC0.ECID = 0x64
                    Local0 = \_SB.PCI0.LPC.EC0.SCRT
                    Release (\_SB.PCI0.LPC.EC0.BATM)
                }
                Else
                {
                    WBEC (0x57, 0x64)
                    Local0 = RBEC (0xBE)
                }

                Return (C2K (Local0))
            }

            Name (_PSL, Package (0x01)  // _PSL: Passive List
            {
                \_PR.CPU0
            })
            Method (_PSV, 0, NotSerialized)  // _PSV: Passive Temperature
            {
                Sleep (0x03)
                If (ECON)
                {
                    Acquire (\_SB.PCI0.LPC.EC0.BATM, 0xFFFF)
                    \_SB.PCI0.LPC.EC0.ECID = 0x64
                    Local0 = \_SB.PCI0.LPC.EC0.SPSV
                    Release (\_SB.PCI0.LPC.EC0.BATM)
                }
                Else
                {
                    WBEC (0x57, 0x64)
                    Local0 = RBEC (0xBC)
                }

                If (((Local0 >= 0x80) || (Local0 < 0x32)))
                {
                    Local0 = 0x5A
                }

                PSV4 = Local0
                Return (C2K (Local0))
            }

            Name (_TC1, 0x02)  // _TC1: Thermal Constant 1
            Name (_TC2, 0x05)  // _TC2: Thermal Constant 2
            Name (_TSP, 0x012C)  // _TSP: Thermal Sampling Period
        }

        Method (C2K, 1, NotSerialized)
        {
            Local0 = Arg0
            If ((Local0 >= 0x78))
            {
                Local0 = LTMP /* \_TZ_.LTMP */
            }

            Local0 = ((Local0 * 0x0A) + TBSE) /* \_TZ_.TBSE */
            Return (Local0)
        }
    }

    Method (SCMP, 2, NotSerialized)
    {
        Name (STG1, Buffer (0x50) {})
        Name (STG2, Buffer (0x50) {})
        STG1 = Arg0
        STG2 = Arg1
        If ((SizeOf (Arg0) != SizeOf (Arg1)))
        {
            Return (Zero)
        }

        Local0 = Zero
        While ((Local0 < SizeOf (Arg0)))
        {
            If ((DerefOf (Index (STG1, Local0)) != DerefOf (Index (STG2, Local0
                ))))
            {
                Return (Zero)
            }

            Local0++
        }

        Return (One)
    }

    Method (GETP, 1, Serialized)
    {
        If (((Arg0 & 0x09) == Zero))
        {
            Return (Ones)
        }

        If (((Arg0 & 0x09) == 0x08))
        {
            Return (0x0384)
        }

        Local0 = ((Arg0 & 0x0300) >> 0x08)
        Local1 = ((Arg0 & 0x3000) >> 0x0C)
        Return ((0x1E * (0x09 - (Local0 + Local1))))
    }

    Method (GDMA, 5, Serialized)
    {
        If (Arg0)
        {
            If ((Arg1 && Arg4))
            {
                Return (0x14)
            }

            If ((Arg2 && Arg4))
            {
                Return (((0x04 - Arg3) * 0x0F))
            }

            Return (((0x04 - Arg3) * 0x1E))
        }

        Return (Ones)
    }

    Method (GETT, 1, Serialized)
    {
        Return ((0x1E * (0x09 - (((Arg0 >> 0x02) & 0x03
            ) + (Arg0 & 0x03)))))
    }

    Method (GETF, 3, Serialized)
    {
        Name (TMPF, Zero)
        If (Arg0)
        {
            TMPF |= One
        }

        If ((Arg2 & 0x02))
        {
            TMPF |= 0x02
        }

        If (Arg1)
        {
            TMPF |= 0x04
        }

        If ((Arg2 & 0x20))
        {
            TMPF |= 0x08
        }

        If ((Arg2 & 0x4000))
        {
            TMPF |= 0x10
        }

        Return (TMPF) /* \GETF.TMPF */
    }

    Method (SETP, 3, Serialized)
    {
        If ((Arg0 > 0xF0))
        {
            Return (0x08)
        }
        Else
        {
            If ((Arg1 & 0x02))
            {
                If (((Arg0 <= 0x78) && (Arg2 & 0x02)))
                {
                    Return (0x2301)
                }

                If (((Arg0 <= 0xB4) && (Arg2 & One)))
                {
                    Return (0x2101)
                }
            }

            Return (0x1001)
        }
    }

    Method (SDMA, 1, Serialized)
    {
        If ((Arg0 <= 0x14))
        {
            Return (One)
        }

        If ((Arg0 <= 0x1E))
        {
            Return (0x02)
        }

        If ((Arg0 <= 0x2D))
        {
            Return (One)
        }

        If ((Arg0 <= 0x3C))
        {
            Return (0x02)
        }

        If ((Arg0 <= 0x5A))
        {
            Return (One)
        }

        Return (Zero)
    }

    Method (SETT, 3, Serialized)
    {
        If ((Arg1 & 0x02))
        {
            If (((Arg0 <= 0x78) && (Arg2 & 0x02)))
            {
                Return (0x0B)
            }

            If (((Arg0 <= 0xB4) && (Arg2 & One)))
            {
                Return (0x09)
            }
        }

        Return (0x04)
    }

    Scope (_SB)
    {
        Device (AMW0)
        {
            Name (_HID, "PNP0C14" /* Windows Management Instrumentation Device */)  // _HID: Hardware ID
            Name (_UID, Zero)  // _UID: Unique ID
            Name (_WDG, Buffer (0x8C)
            {
                /* 0000 */  0x60, 0x0F, 0xBC, 0xAB, 0xA1, 0x8E, 0xD1, 0x11,  /* `....... */
                /* 0008 */  0x00, 0xA0, 0xC9, 0x06, 0x29, 0x10, 0x00, 0x00,  /* ....)... */
                /* 0010 */  0x41, 0x42, 0x01, 0x01, 0x6D, 0x0F, 0xBC, 0xAB,  /* AB..m... */
                /* 0018 */  0xA1, 0x8E, 0xD1, 0x11, 0x00, 0xA0, 0xC9, 0x06,  /* ........ */
                /* 0020 */  0x29, 0x10, 0x00, 0x00, 0x42, 0x41, 0x01, 0x02,  /* )...BA.. */
                /* 0028 */  0x6F, 0x0F, 0xBC, 0xAB, 0xA1, 0x8E, 0xD1, 0x11,  /* o....... */
                /* 0030 */  0x00, 0xA0, 0xC9, 0x06, 0x29, 0x10, 0x00, 0x00,  /* ....)... */
                /* 0038 */  0x42, 0x43, 0x0A, 0x02, 0x71, 0xBF, 0xD1, 0x40,  /* BC..q..@ */
                /* 0040 */  0x2D, 0xA8, 0x59, 0x4E, 0xA1, 0x68, 0x39, 0x85,  /* -.YN.h9. */
                /* 0048 */  0xE0, 0x3B, 0x2E, 0x87, 0xB0, 0x00, 0x01, 0x08,  /* .;...... */
                /* 0050 */  0x81, 0x17, 0xF4, 0xD9, 0x33, 0xF6, 0x00, 0x44,  /* ....3..D */
                /* 0058 */  0x93, 0x55, 0x60, 0x17, 0x70, 0xBE, 0xC5, 0x10,  /* .U`.p... */
                /* 0060 */  0x43, 0x41, 0x01, 0x00, 0x1D, 0x37, 0xC3, 0x67,  /* CA...7.g */
                /* 0068 */  0xA3, 0x95, 0x37, 0x4C, 0xBB, 0x61, 0xDD, 0x47,  /* ..7L.a.G */
                /* 0070 */  0xB4, 0x91, 0xDA, 0xAB, 0x43, 0x42, 0x01, 0x02,  /* ....CB.. */
                /* 0078 */  0x21, 0x12, 0x90, 0x05, 0x66, 0xD5, 0xD1, 0x11,  /* !...f... */
                /* 0080 */  0xB2, 0xF0, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0x10,  /* ......). */
                /* 0088 */  0x43, 0x43, 0x01, 0x00                           /* CC.. */
            })
            Name (SAA0, Buffer (0x28)
            {
                /* 0000 */  0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01,  /* ........ */
                /* 0008 */  0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03,  /* ........ */
                /* 0010 */  0x04, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05,  /* ........ */
                /* 0018 */  0x06, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x07,  /* ........ */
                /* 0020 */  0x08, 0x08, 0x08, 0x08, 0x09, 0x09, 0x09, 0x09   /* ........ */
            })
            CreateDWordField (SAA0, Zero, SAC0)
            CreateDWordField (SAA0, 0x04, SAC1)
            CreateDWordField (SAA0, 0x08, SAC2)
            CreateDWordField (SAA0, 0x0C, SAC3)
            CreateDWordField (SAA0, 0x10, SAC4)
            CreateDWordField (SAA0, 0x14, SAC5)
            CreateDWordField (SAA0, 0x18, SAC6)
            CreateDWordField (SAA0, 0x1C, SAC7)
            CreateDWordField (SAA0, 0x20, SAC8)
            CreateDWordField (SAA0, 0x24, SAC9)
            CreateByteField (SAA0, Zero, SPRT)
            CreateByteField (SAA0, One, SSTS)
            CreateByteField (SAA0, 0x02, SADR)
            CreateByteField (SAA0, 0x03, SCMD)
            CreateByteField (SAA0, 0x08, SDB0)
            CreateByteField (SAA0, 0x09, SDB1)
            OperationRegion (KNVS, SystemMemory, 0xFFF18000, 0x03)
            Field (KNVS, AnyAcc, Lock, Preserve)
            {
                Offset (0x01), 
                STMD,   8, 
                Offset (0x03)
            }

            Name (TTMD, Zero)
            Method (WQAB, 1, NotSerialized)
            {
                WMIG ()
                Return (SAA0) /* \_SB_.AMW0.SAA0 */
            }

            Method (WMBA, 3, NotSerialized)
            {
                If ((Arg1 == One))
                {
                    WMIG ()
                    Return (SAA0) /* \_SB_.AMW0.SAA0 */
                }

                If ((Arg1 == 0x02))
                {
                    SAA0 = Arg2
                    WMIS ()
                }
            }

            Method (WMBC, 3, NotSerialized)
            {
                If ((Arg1 == One))
                {
                    WMIG ()
                    If ((Arg0 == Zero))
                    {
                        Return (SAC0) /* \_SB_.AMW0.SAC0 */
                    }

                    If ((Arg0 == One))
                    {
                        Return (SAC1) /* \_SB_.AMW0.SAC1 */
                    }

                    If ((Arg0 == 0x02))
                    {
                        Return (SAC2) /* \_SB_.AMW0.SAC2 */
                    }

                    If ((Arg0 == 0x03))
                    {
                        Return (SAC3) /* \_SB_.AMW0.SAC3 */
                    }

                    If ((Arg0 == 0x04))
                    {
                        Return (SAC4) /* \_SB_.AMW0.SAC4 */
                    }

                    If ((Arg0 == 0x05))
                    {
                        Return (SAC5) /* \_SB_.AMW0.SAC5 */
                    }

                    If ((Arg0 == 0x06))
                    {
                        Return (SAC6) /* \_SB_.AMW0.SAC6 */
                    }

                    If ((Arg0 == 0x07))
                    {
                        Return (SAC7) /* \_SB_.AMW0.SAC7 */
                    }

                    If ((Arg0 == 0x08))
                    {
                        Return (SAC8) /* \_SB_.AMW0.SAC8 */
                    }

                    If ((Arg0 == 0x09))
                    {
                        Return (SAC9) /* \_SB_.AMW0.SAC9 */
                    }
                }

                If ((Arg1 == 0x02))
                {
                    If ((Arg0 == Zero))
                    {
                        SAC0 = Arg2
                    }

                    If ((Arg0 == One))
                    {
                        SAC1 = Arg2
                    }

                    If ((Arg0 == 0x02))
                    {
                        SAC2 = Arg2
                    }

                    If ((Arg0 == 0x03))
                    {
                        SAC3 = Arg2
                    }

                    If ((Arg0 == 0x04))
                    {
                        SAC4 = Arg2
                    }

                    If ((Arg0 == 0x05))
                    {
                        SAC5 = Arg2
                    }

                    If ((Arg0 == 0x06))
                    {
                        SAC6 = Arg2
                    }

                    If ((Arg0 == 0x07))
                    {
                        SAC7 = Arg2
                    }

                    If ((Arg0 == 0x08))
                    {
                        SAC8 = Arg2
                    }

                    If ((Arg0 == 0x09))
                    {
                        SAC9 = Arg2
                    }

                    WMIS ()
                }
            }

            Method (WMIG, 0, NotSerialized)
            {
                If ((SADR != 0x5B))
                {
                    SPRT = ^^PCI0.LPC.EC0.KSPR /* \_SB_.PCI0.LPC_.EC0_.KSPR */
                    SSTS = ^^PCI0.LPC.EC0.KSST /* \_SB_.PCI0.LPC_.EC0_.KSST */
                    SCMD = ^^PCI0.LPC.EC0.KSCM /* \_SB_.PCI0.LPC_.EC0_.KSCM */
                    SAC2 = ^^PCI0.LPC.EC0.KSD0 /* \_SB_.PCI0.LPC_.EC0_.KSD0 */
                    SAC3 = ^^PCI0.LPC.EC0.KSD1 /* \_SB_.PCI0.LPC_.EC0_.KSD1 */
                    SAC4 = ^^PCI0.LPC.EC0.KSD2 /* \_SB_.PCI0.LPC_.EC0_.KSD2 */
                    SAC5 = ^^PCI0.LPC.EC0.KSD3 /* \_SB_.PCI0.LPC_.EC0_.KSD3 */
                    SAC6 = ^^PCI0.LPC.EC0.KSD4 /* \_SB_.PCI0.LPC_.EC0_.KSD4 */
                    SAC7 = ^^PCI0.LPC.EC0.KSD5 /* \_SB_.PCI0.LPC_.EC0_.KSD5 */
                    SAC8 = ^^PCI0.LPC.EC0.KSD6 /* \_SB_.PCI0.LPC_.EC0_.KSD6 */
                    SAC9 = ^^PCI0.LPC.EC0.KSD7 /* \_SB_.PCI0.LPC_.EC0_.KSD7 */
                }
            }

            Field (PMBA, ByteAcc, NoLock, Preserve)
            {
                Offset (0x10), 
                THRT,   8
            }

            Method (WMIS, 0, NotSerialized)
            {
                If ((SADR != 0x5B))
                {
                    If (((SADR == 0x0B) || (SADR == 0x48)))
                    {
                        ^^PCI0.LPC.EC0.KSMC = Zero
                    }

                    If (((SADR == 0x39) || (SADR == 0x3D)))
                    {
                        ^^PCI0.LPC.EC0.KSMC = One
                    }

                    If (((SADR == 0x4F) || (SADR == 0x50)))
                    {
                        ^^PCI0.LPC.EC0.KSMC = One
                    }

                    ^^PCI0.LPC.EC0.KSD0 = SAC2 /* \_SB_.AMW0.SAC2 */
                    ^^PCI0.LPC.EC0.KSD1 = SAC3 /* \_SB_.AMW0.SAC3 */
                    ^^PCI0.LPC.EC0.KSD2 = SAC4 /* \_SB_.AMW0.SAC4 */
                    ^^PCI0.LPC.EC0.KSD3 = SAC5 /* \_SB_.AMW0.SAC5 */
                    ^^PCI0.LPC.EC0.KSD4 = SAC6 /* \_SB_.AMW0.SAC6 */
                    ^^PCI0.LPC.EC0.KSD5 = SAC7 /* \_SB_.AMW0.SAC7 */
                    ^^PCI0.LPC.EC0.KSD6 = SAC8 /* \_SB_.AMW0.SAC8 */
                    ^^PCI0.LPC.EC0.KSD7 = SAC9 /* \_SB_.AMW0.SAC9 */
                    ^^PCI0.LPC.EC0.KSCM = SCMD /* \_SB_.AMW0.SCMD */
                    ^^PCI0.LPC.EC0.KSAD = (SADR << One)
                    ^^PCI0.LPC.EC0.KSST = SSTS /* \_SB_.AMW0.SSTS */
                    ^^PCI0.LPC.EC0.KSPR = SPRT /* \_SB_.AMW0.SPRT */
                }
                Else
                {
                    If ((SCMD == 0x80))
                    {
                        If ((SPRT == 0x07))
                        {
                            SDB1 = RBEC (SDB0)
                            SSTS = 0x80
                        }
                    }

                    If ((SCMD == 0xB5))
                    {
                        If ((SDB1 == Zero))
                        {
                            If ((SDB0 == 0xFF))
                            {
                                If ((^^PCI0.LPC.EC0.BLRN != Zero))
                                {
                                    ^^PCI0.LPC.EC0.BLRN = 0xFF
                                }

                                ^^PCI0.LPC.EC0.KBDC = One
                                SSTS = 0x80
                            }

                            If ((SDB0 == Zero))
                            {
                                If ((^^PCI0.LPC.EC0.BLRN != Zero))
                                {
                                    ^^PCI0.LPC.EC0.BLRN = 0xFF
                                }

                                ^^PCI0.LPC.EC0.KBDC = Zero
                                SSTS = 0x80
                            }

                            If ((SDB0 == One))
                            {
                                ^^PCI0.LPC.EC0.BLRN = One
                                SSTS = 0x80
                            }
                        }
                    }

                    If ((SCMD == 0xB6))
                    {
                        If ((SDB0 == 0x64))
                        {
                            THRT = Zero
                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x4B))
                        {
                            THRT = 0x1C
                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x32))
                        {
                            THRT = 0x18
                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x19))
                        {
                            THRT = 0x14
                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x58))
                        {
                            THRT = 0x1E
                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x3E))
                        {
                            THRT = 0x1A
                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x26))
                        {
                            THRT = 0x16
                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x0C))
                        {
                            THRT = 0x12
                            SSTS = 0x80
                        }
                    }

                    If ((SCMD == 0xB7))
                    {
                        If ((SDB0 == 0x80))
                        {
                            ^^PCI0.LPC.EC0.RBTE = (SDB1 & One)
                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x81))
                        {
                            Local0 = (SDB1 & One)
                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x82))
                        {
                            ^^PCI0.LPC.EC0.KLWE = (SDB1 & One)
                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x85))
                        {
                            Local0 = (SDB1 & One)
                            SSTS = 0x80
                        }
                    }

                    If ((SCMD == 0xB8))
                    {
                        ^^PCI0.LPC.EC0.RWLE = (SDB0 & One)
                        SSTS = 0x80
                    }

                    If ((SCMD == 0xB9))
                    {
                        If (^^PCI0.LPC.EC0.KF1S)
                        {
                            If (SDB0)
                            {
                                Local0 = (SDB0 * 0xA2)
                                Divide (Local0, 0x64, Local1, Local0)
                                Local0 -= 0xFF
                            }
                            Else
                            {
                                Local0 = 0xFF
                            }

                            ^^PCI0.LPC.EC0.KF1C = One
                            ^^PCI0.LPC.EC0.KF1P = Local0
                            SSTS = 0x80
                        }
                    }

                    If ((SCMD == 0xBA))
                    {
                        If (^^PCI0.LPC.EC0.KF1S)
                        {
                            Local0 = ^^PCI0.LPC.EC0.KF1F /* \_SB_.PCI0.LPC_.EC0_.KF1F */
                            Local0 -= 0xFF
                            If (Local0)
                            {
                                Local0 *= 0x64
                                Divide (Local0, 0xA2, Local0, SDB0) /* \_SB_.AMW0.SDB0 */
                            }
                            Else
                            {
                                SDB0 = Zero
                            }

                            SSTS = 0x80
                        }
                        Else
                        {
                            SDB0 = Zero
                        }

                        SDB1 = Zero
                    }

                    If ((SCMD == 0xBB))
                    {
                        If ((SPRT == 0x07))
                        {
                            SDB0 = 0xC9
                            SDB1 = RBEC (SDB0)
                            SSTS = 0x80
                        }
                    }

                    If ((SCMD == 0xBC))
                    {
                        If (One)
                        {
                            If ((SDB0 == Zero))
                            {
                                SDB0 = 0xA8
                                SDB1 = RBEC (SDB0)
                                SSTS = 0x80
                            }

                            If ((SDB0 == One))
                            {
                                SDB0 = 0xA9
                                SDB1 = RBEC (SDB0)
                                SSTS = 0x80
                            }

                            If ((SDB0 == 0x02))
                            {
                                SDB0 = 0xAA
                                SDB1 = RBEC (SDB0)
                                SSTS = 0x80
                            }

                            If ((SDB0 == 0x03))
                            {
                                SDB0 = 0xAC
                                SDB1 = RBEC (SDB0)
                                SSTS = 0x80
                            }

                            If ((SDB0 == 0x04))
                            {
                                SDB0 = 0xAB
                                SDB1 = RBEC (SDB0)
                                SSTS = 0x80
                            }
                        }
                    }

                    If ((SCMD == 0xBD))
                    {
                        If ((SPRT == 0x06))
                        {
                            WBEC (SDB0, SDB1)
                            SSTS = 0x80
                        }

                        If ((SPRT == 0x07))
                        {
                            SDB1 = RBEC (SDB0)
                            SSTS = 0x80
                        }
                    }

                    If ((SCMD == 0xC0))
                    {
                        SDB0 = Zero
                        SDB1 = ^^PCI0.LPC.EC0.DCMB /* \_SB_.PCI0.LPC_.EC0_.DCMB */
                        SSTS = 0x80
                    }

                    If ((SCMD == 0xC1))
                    {
                        SDB0 = One
                        SDB1 = ^^PCI0.LPC.EC0.ACMB /* \_SB_.PCI0.LPC_.EC0_.ACMB */
                        SSTS = 0x80
                    }

                    If ((SCMD == 0xC2))
                    {
                        If ((SPRT == 0x08))
                        {
                            If ((SDB0 == Zero))
                            {
                                ^^PCI0.LPC.EC0.DCMB = SDB1 /* \_SB_.AMW0.SDB1 */
                                SSTS = 0x80
                            }

                            If ((SDB0 == One))
                            {
                                ^^PCI0.LPC.EC0.ACMB = SDB1 /* \_SB_.AMW0.SDB1 */
                                SSTS = 0x80
                            }
                        }

                        If ((SPRT == 0x09))
                        {
                            If ((SDB0 == Zero))
                            {
                                SDB1 = ^^PCI0.LPC.EC0.DCMB /* \_SB_.PCI0.LPC_.EC0_.DCMB */
                                SSTS = 0x80
                            }

                            If ((SDB0 == One))
                            {
                                SDB1 = ^^PCI0.LPC.EC0.ACMB /* \_SB_.PCI0.LPC_.EC0_.ACMB */
                                SSTS = 0x80
                            }
                        }
                    }

                    If ((SCMD == 0xC3))
                    {
                        If ((SDB0 <= 0x03))
                        {
                            If ((SDB0 == Zero))
                            {
                                If (((SPON == Zero) || ((SPON == One) && (OBTE == One))))
                                {
                                    ^^PCI0.LPC.EC0.RBTE = SDB1 /* \_SB_.AMW0.SDB1 */
                                    SSTS = 0x80
                                }
                            }

                            If ((SDB0 == One))
                            {
                                ^^PCI0.LPC.EC0.RGPS = SDB1 /* \_SB_.AMW0.SDB1 */
                                SSTS = 0x80
                            }

                            If ((SDB0 == 0x02))
                            {
                                If (((SPON == Zero) || ((SPON == One) && (OWWE == One))))
                                {
                                    ^^PCI0.LPC.EC0.RWWE = SDB1 /* \_SB_.AMW0.SDB1 */
                                    SSTS = 0x80
                                }
                            }

                            If ((SDB0 == 0x03))
                            {
                                If ((^^PCI0.EXP4.PDS4 == One))
                                {
                                    If (((SPON == Zero) || ((SPON == One) && (OWLE == One))))
                                    {
                                        ^^PCI0.LPC.EC0.RWLE = SDB1 /* \_SB_.AMW0.SDB1 */
                                        SSTS = 0x80
                                    }
                                }
                            }
                        }

                        If ((SDB0 == 0x04))
                        {
                            If (SDB1)
                            {
                                PDO6 = Zero
                            }
                            Else
                            {
                                PDO6 = One
                            }

                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x05))
                        {
                            If (((SPON == Zero) || ((SPON == One) && (OUBE == One))))
                            {
                                If (SDB1)
                                {
                                    Local0 = Zero
                                }
                                Else
                                {
                                    Local0 = One
                                }

                                PDO0 = Local0
                                PDO1 = Local0
                                SSTS = 0x80
                            }
                        }
                    }

                    If ((SCMD == 0xC4))
                    {
                        If ((SDB0 <= 0x03))
                        {
                            If ((^^PCI0.LPC.EC0.RDOE == Zero))
                            {
                                If ((SDB0 == Zero))
                                {
                                    SDB1 = ^^PCI0.LPC.EC0.RBTE /* \_SB_.PCI0.LPC_.EC0_.RBTE */
                                }

                                If ((SDB0 == One))
                                {
                                    SDB1 = ^^PCI0.LPC.EC0.RGPS /* \_SB_.PCI0.LPC_.EC0_.RGPS */
                                }

                                If ((SDB0 == 0x02))
                                {
                                    SDB1 = ^^PCI0.LPC.EC0.RWWE /* \_SB_.PCI0.LPC_.EC0_.RWWE */
                                }

                                If ((SDB0 == 0x03))
                                {
                                    SDB1 = ^^PCI0.LPC.EC0.RWLE /* \_SB_.PCI0.LPC_.EC0_.RWLE */
                                }
                            }
                            Else
                            {
                                SDB1 = Zero
                            }

                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x04))
                        {
                            If ((PDO6 == One))
                            {
                                SDB1 = Zero
                            }
                            Else
                            {
                                SDB1 = One
                            }

                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x05))
                        {
                            Local0 = (GL03 & 0x10)
                            If ((DBRD == One))
                            {
                                If (Local0)
                                {
                                    Local0 = One
                                }
                                Else
                                {
                                    Local0 = Zero
                                }
                            }
                            Else
                            {
                                If (Local0)
                                {
                                    Local0 = Zero
                                }
                                Else
                                {
                                    Local0 = One
                                }
                            }

                            If (Local0)
                            {
                                If (((PDO0 == One) && (PDO1 == One)))
                                {
                                    SDB1 = Zero
                                }
                                Else
                                {
                                    SDB1 = One
                                }
                            }
                            Else
                            {
                                SDB1 = Zero
                            }

                            SSTS = 0x80
                        }

                        If ((SDB0 == 0x0F))
                        {
                            If ((^^PCI0.LPC.EC0.RDOE == One))
                            {
                                SDB1 = Zero
                            }
                            Else
                            {
                                SDB1 = One
                            }

                            SSTS = 0x80
                        }
                    }

                    If ((SCMD == 0xC5))
                    {
                        If ((SPRT == 0x08))
                        {
                            ^^PCI0.LPC.EC0.PSEN = SDB0 /* \_SB_.AMW0.SDB0 */
                            SSTS = 0x80
                        }

                        If ((SPRT == 0x09))
                        {
                            SDB0 = ^^PCI0.LPC.EC0.PSEN /* \_SB_.PCI0.LPC_.EC0_.PSEN */
                            SSTS = 0x80
                        }
                    }

                    If ((SCMD == 0xC6))
                    {
                        If ((SPRT == 0x08))
                        {
                            If ((SDB0 == Zero))
                            {
                                ^^PCI0.LPC.EC0.KPHC = One
                                If ((^^PCI0.LPC.EC0.KADF == One))
                                {
                                    ^^PCI0.LPC.EC0.KBDS = (SDB1 & 0x0F)
                                }
                                Else
                                {
                                    ^^PCI0.LPC.EC0.KBAS = (SDB1 & 0x0F)
                                }

                                ^^PCI0.LPC.EC0.KPHC = Zero
                                SSTS = 0x80
                            }

                            If ((SDB0 == One))
                            {
                                ^^PCI0.LPC.EC0.KPHC = One
                                ^^PCI0.LPC.EC0.KBAS = (SDB1 & 0x0F)
                                ^^PCI0.LPC.EC0.KPHC = Zero
                                SSTS = 0x80
                            }
                        }

                        If ((SPRT == 0x09))
                        {
                            If ((SDB0 == Zero))
                            {
                                If ((^^PCI0.LPC.EC0.KADF == One))
                                {
                                    SDB1 = ^^PCI0.LPC.EC0.KBDS /* \_SB_.PCI0.LPC_.EC0_.KBDS */
                                }
                                Else
                                {
                                    SDB1 = ^^PCI0.LPC.EC0.KBAS /* \_SB_.PCI0.LPC_.EC0_.KBAS */
                                }

                                SSTS = 0x80
                            }

                            If ((SDB0 == One))
                            {
                                SDB1 = ^^PCI0.LPC.EC0.KBAS /* \_SB_.PCI0.LPC_.EC0_.KBAS */
                                SSTS = 0x80
                            }
                        }
                    }

                    If ((SCMD == 0xC7))
                    {
                        If ((SPRT == 0x08))
                        {
                            ^^PCI0.LPC.EC0.KBSA = SDB1 /* \_SB_.AMW0.SDB1 */
                            SSTS = 0x80
                        }

                        If ((SPRT == 0x09))
                        {
                            SDB1 = ^^PCI0.LPC.EC0.KBSA /* \_SB_.PCI0.LPC_.EC0_.KBSA */
                            SSTS = 0x80
                        }
                    }

                    If ((SCMD == 0xC8))
                    {
                        If ((SPRT == 0x09))
                        {
                            TTMD = (STMD & One)
                            If ((TTMD == One))
                            {
                                SDB0 = One
                            }
                            Else
                            {
                                SDB0 = Zero
                            }

                            SDB1 = Zero
                            TTMD = (STMD & 0x02)
                            If ((TTMD == 0x02))
                            {
                                SDB1 |= 0x80 /* \_SB_.AMW0.SDB1 */
                            }

                            TTMD = (STMD & 0x04)
                            If ((TTMD == 0x04))
                            {
                                SDB1 |= 0x40 /* \_SB_.AMW0.SDB1 */
                            }

                            TTMD = (STMD & 0x08)
                            If ((TTMD == 0x08))
                            {
                                SDB1 |= 0x20 /* \_SB_.AMW0.SDB1 */
                            }

                            TTMD = (STMD & 0x08)
                            If ((TTMD == 0x08))
                            {
                                SDB1 |= 0x10 /* \_SB_.AMW0.SDB1 */
                            }

                            TTMD = (STMD & 0x10)
                            If ((TTMD == 0x10))
                            {
                                SDB1 |= 0x08 /* \_SB_.AMW0.SDB1 */
                            }

                            TTMD = (STMD & 0x20)
                            If ((TTMD == 0x20))
                            {
                                SDB1 |= 0x04 /* \_SB_.AMW0.SDB1 */
                            }

                            SSTS = 0x80
                        }
                    }

                    If ((SCMD == 0xC9))
                    {
                        If ((SPRT == 0x08))
                        {
                            If ((SDB0 == Zero))
                            {
                                ^^PCI0.LPC.EC0.THID = Zero
                            }
                            Else
                            {
                                If ((SDB0 == One))
                                {
                                    ^^PCI0.LPC.EC0.THID = One
                                }
                                Else
                                {
                                    If ((SDB0 == 0x02))
                                    {
                                        ^^PCI0.LPC.EC0.THID = 0x02
                                    }
                                }
                            }

                            Notify (\_TZ.TZS0, 0x81) // Thermal Trip Point Change
                            Notify (\_TZ.TZS1, 0x81) // Thermal Trip Point Change
                            Notify (\_TZ.TZS3, 0x81) // Thermal Trip Point Change
                            Notify (\_TZ.TZS4, 0x81) // Thermal Trip Point Change
                            SSTS = 0x80
                        }

                        If ((SPRT == 0x09))
                        {
                            SDB0 = ^^PCI0.LPC.EC0.THID /* \_SB_.PCI0.LPC_.EC0_.THID */
                            SSTS = 0x80
                        }
                    }

                    If ((SCMD == 0xCA))
                    {
                        If ((SPRT == 0x09))
                        {
                            If ((SDB0 == Zero))
                            {
                                Local0 = Zero
                                Local1 = Zero
                                While ((Local0 < 0x14))
                                {
                                    ^^PCI0.LPC.EC0.KNVI = Local0
                                    Local1 += ^^PCI0.LPC.EC0.KNVD /* \_SB_.PCI0.LPC_.EC0_.KNVD */
                                    Local0 += 0x02
                                }

                                Divide (Local1, 0x0100, SDB0, Local1)
                                Local0 = One
                                While ((Local0 < 0x14))
                                {
                                    ^^PCI0.LPC.EC0.KNVI = Local0
                                    Local1 += ^^PCI0.LPC.EC0.KNVD /* \_SB_.PCI0.LPC_.EC0_.KNVD */
                                    Local0 += 0x02
                                }

                                SDB1 = Local1
                            }

                            If ((SDB0 == One))
                            {
                                ^^PCI0.LPC.EC0.KNVI = 0x14
                                SDB0 = ^^PCI0.LPC.EC0.KNVD /* \_SB_.PCI0.LPC_.EC0_.KNVD */
                                ^^PCI0.LPC.EC0.KNVI = 0x15
                                SDB1 = ^^PCI0.LPC.EC0.KNVD /* \_SB_.PCI0.LPC_.EC0_.KNVD */
                                SSTS = 0x80
                            }

                            If ((SDB0 == 0x02))
                            {
                                ^^PCI0.LPC.EC0.KNVI = 0x16
                                SDB0 = ^^PCI0.LPC.EC0.KNVD /* \_SB_.PCI0.LPC_.EC0_.KNVD */
                                ^^PCI0.LPC.EC0.KNVI = 0x17
                                SDB1 = ^^PCI0.LPC.EC0.KNVD /* \_SB_.PCI0.LPC_.EC0_.KNVD */
                                SSTS = 0x80
                            }

                            If ((SDB0 == 0x03))
                            {
                                ^^PCI0.LPC.EC0.KNVI = 0x18
                                SDB0 = ^^PCI0.LPC.EC0.KNVD /* \_SB_.PCI0.LPC_.EC0_.KNVD */
                                ^^PCI0.LPC.EC0.KNVI = 0x19
                                SDB1 = ^^PCI0.LPC.EC0.KNVD /* \_SB_.PCI0.LPC_.EC0_.KNVD */
                                SSTS = 0x80
                            }

                            If ((SDB0 == 0x03))
                            {
                                ^^PCI0.LPC.EC0.KNVI = 0x1A
                                Local0 = ^^PCI0.LPC.EC0.KNVD /* \_SB_.PCI0.LPC_.EC0_.KNVD */
                                ^^PCI0.LPC.EC0.KNVI = 0x1C
                                Local0 += ^^PCI0.LPC.EC0.KNVD /* \_SB_.PCI0.LPC_.EC0_.KNVD */
                                Divide (Local0, 0x0100, SDB0, Local0)
                                ^^PCI0.LPC.EC0.KNVI = 0x1B
                                Local0 += ^^PCI0.LPC.EC0.KNVD /* \_SB_.PCI0.LPC_.EC0_.KNVD */
                                ^^PCI0.LPC.EC0.KNVI = 0x1D
                                SDB1 = (Local0 + ^^PCI0.LPC.EC0.KNVD) /* \_SB_.PCI0.LPC_.EC0_.KNVD */
                            }
                        }
                    }
                }
            }

            Name (B0ED, Buffer (0x04)
            {
                 0x00, 0x00, 0x00, 0x00                           /* .... */
            })
            Name (B1ED, Buffer (0x04)
            {
                 0x00, 0x00, 0x00, 0x00                           /* .... */
            })
            Name (B2ED, Buffer (0x14)
            {
                /* 0000 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* ........ */
                /* 0008 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* ........ */
                /* 0010 */  0x00, 0x00, 0x00, 0x00                           /* .... */
            })
            Name (WLID, Zero)
            Name (WLMP, Zero)
            Method (_WED, 1, NotSerialized)  // _Wxx: Wake Event
            {
                P80H = 0xB0
                If ((Arg0 == 0xB0))
                {
                    B0ED = WLID /* \_SB_.AMW0.WLID */
                    Return (B0ED) /* \_SB_.AMW0.B0ED */
                }
            }

            Method (WQCA, 1, NotSerialized)
            {
                Return (B1ED) /* \_SB_.AMW0.B1ED */
            }

            Method (WSCA, 2, NotSerialized)
            {
                CreateDWordField (Arg1, Zero, DDD0)
                Index (B1ED, Zero) = DDD0 /* \_SB_.AMW0.WSCA.DDD0 */
            }

            Method (WMCB, 3, NotSerialized)
            {
                CreateWordField (Arg2, Zero, IDAX)
                CreateWordField (Arg2, 0x04, IDBX)
                CreateByteField (Arg2, 0x04, IDBL)
                CreateByteField (Arg2, 0x05, IDBH)
                CreateDWordField (B2ED, Zero, OEAX)
                CreateDWordField (B2ED, 0x04, OEBX)
                CreateDWordField (B2ED, 0x08, OECX)
                CreateDWordField (B2ED, 0x0C, OEDX)
                CreateDWordField (B2ED, 0x10, OCFL)
                B2ED = Zero
                OCFL = One
                If ((IDAX == 0x9604))
                {
                    If ((IDBH == 0xF7))
                    {
                        OECX = 0x3735
                        OEDX = 0x4954
                        OCFL = Zero
                    }
                }

                If ((IDAX == 0x9610))
                {
                    If ((IDBX == 0x012E))
                    {
                        OCFL = Zero
                    }
                }

                If ((IDAX == 0x9612))
                {
                    If ((IDBX == 0x07))
                    {
                        If (^^PCI0.LPC.EC0.KACS)
                        {
                            OECX = ^^PCI0.LPC.EC0.KBAS /* \_SB_.PCI0.LPC_.EC0_.KBAS */
                        }
                        Else
                        {
                            If ((^^PCI0.LPC.EC0.KADF == One))
                            {
                                OECX = ^^PCI0.LPC.EC0.KBDS /* \_SB_.PCI0.LPC_.EC0_.KBDS */
                            }
                            Else
                            {
                                OECX = ^^PCI0.LPC.EC0.KBAS /* \_SB_.PCI0.LPC_.EC0_.KBAS */
                            }
                        }

                        OECX++
                        OCFL = Zero
                    }

                    If ((IDBL == 0x08))
                    {
                        OEDX = (^^PCI0.LPC.EC0.KBMA << 0x08)
                        OCFL = Zero
                    }

                    If ((IDBX == 0x020F))
                    {
                        OEAX = ^^PCI0.LPC.EC0.KTPS /* \_SB_.PCI0.LPC_.EC0_.KTPS */
                        OCFL = Zero
                    }

                    If ((IDBL == 0x21))
                    {
                        Local0 = (IDBH & 0x80)
                        If (Local0)
                        {
                            Local0 = (IDBH & One)
                            ^^PCI0.LPC.EC0.KMUT = Local0
                        }
                        Else
                        {
                            If ((SMON == One))
                            {
                                If ((SADO == One))
                                {
                                    OEAX = Zero
                                }
                                Else
                                {
                                    OEAX = One
                                }
                            }
                            Else
                            {
                                OEAX = Zero
                            }
                        }

                        OCFL = Zero
                    }
                }

                If ((IDAX == 0x9630))
                {
                    If ((IDBL == 0x02))
                    {
                        If ((IDBH == Zero))
                        {
                            OECX = NATP /* \_SB_.NATP */
                            OCFL = Zero
                        }

                        If ((IDBH == One))
                        {
                            ^^DOCK.DKOU ()
                            OCFL = Zero
                        }
                    }
                }

                WLMP = One
                Return (B2ED) /* \_SB_.AMW0.B2ED */
            }

            Name (WQCC, Buffer (0x0528)
            {
                /* 0000 */  0x46, 0x4F, 0x4D, 0x42, 0x01, 0x00, 0x00, 0x00,  /* FOMB.... */
                /* 0008 */  0x18, 0x05, 0x00, 0x00, 0x90, 0x1B, 0x00, 0x00,  /* ........ */
                /* 0010 */  0x44, 0x53, 0x00, 0x01, 0x1A, 0x7D, 0xDA, 0x54,  /* DS...}.T */
                /* 0018 */  0x18, 0xDF, 0x8C, 0x00, 0x01, 0x06, 0x18, 0x42,  /* .......B */
                /* 0020 */  0x10, 0x09, 0x10, 0x8A, 0xE7, 0x80, 0x42, 0x04,  /* ......B. */
                /* 0028 */  0x0A, 0x0D, 0xA1, 0x40, 0x30, 0x28, 0x38, 0x4B,  /* ...@0(8K */
                /* 0030 */  0x82, 0x90, 0x0B, 0x26, 0x26, 0x40, 0x08, 0x84,  /* ...&&@.. */
                /* 0038 */  0x24, 0x0A, 0x30, 0x2F, 0x40, 0xB7, 0x00, 0xC3,  /* $.0/@... */
                /* 0040 */  0x02, 0x6C, 0x0B, 0x30, 0x2D, 0xC0, 0x31, 0x90,  /* .l.0-.1. */
                /* 0048 */  0xFA, 0xF7, 0x87, 0x28, 0x0D, 0x44, 0x22, 0x20,  /* ...(.D"  */
                /* 0050 */  0xA9, 0x14, 0x08, 0x09, 0x15, 0xA0, 0x5C, 0x80,  /* ......\. */
                /* 0058 */  0x6F, 0x01, 0xDA, 0x11, 0x25, 0x59, 0x80, 0x65,  /* o...%Y.e */
                /* 0060 */  0x18, 0x11, 0xD8, 0x2B, 0x32, 0x41, 0xE3, 0x04,  /* ...+2A.. */
                /* 0068 */  0xE5, 0x0C, 0x03, 0x05, 0x6F, 0xC0, 0x36, 0x05,  /* ....o.6. */
                /* 0070 */  0x98, 0x1C, 0x04, 0x95, 0x3D, 0x08, 0x94, 0x0C,  /* ....=... */
                /* 0078 */  0x08, 0x79, 0x14, 0x60, 0x15, 0x4E, 0xD3, 0x49,  /* .y.`.N.I */
                /* 0080 */  0x60, 0xF7, 0x73, 0x91, 0x30, 0x18, 0x19, 0x13,  /* `.s.0... */
                /* 0088 */  0xA0, 0x50, 0x80, 0x46, 0x01, 0xDE, 0x40, 0x64,  /* .P.F..@d */
                /* 0090 */  0x4B, 0x80, 0x41, 0x01, 0xE2, 0x04, 0x28, 0x83,  /* K.A...(. */
                /* 0098 */  0x12, 0x4A, 0xB8, 0x83, 0x69, 0x4D, 0x80, 0x39,  /* .J..iM.9 */
                /* 00A0 */  0x28, 0x82, 0x56, 0x1B, 0x98, 0x50, 0x3A, 0x03,  /* (.V..P:. */
                /* 00A8 */  0x12, 0x48, 0xAC, 0x16, 0xC1, 0x05, 0x13, 0x3B,  /* .H.....; */
                /* 00B0 */  0x6A, 0x94, 0x40, 0xD1, 0xDB, 0x1F, 0x04, 0x09,  /* j.@..... */
                /* 00B8 */  0xA7, 0x00, 0xA2, 0x06, 0x10, 0x45, 0x1A, 0x0D,  /* .....E.. */
                /* 00C0 */  0x6A, 0x44, 0x09, 0x0E, 0xCC, 0xA3, 0x39, 0xD5,  /* jD....9. */
                /* 00C8 */  0xCE, 0x05, 0x48, 0x9F, 0xAB, 0x40, 0x8E, 0xF5,  /* ..H..@.. */
                /* 00D0 */  0x34, 0xEA, 0x1C, 0x2E, 0x01, 0x49, 0x60, 0xAC,  /* 4....I`. */
                /* 00D8 */  0x04, 0xB7, 0xEE, 0x21, 0xE2, 0x5D, 0x03, 0x6A,  /* ...!.].j */
                /* 00E0 */  0xE2, 0x87, 0xC8, 0x04, 0xC1, 0xA1, 0x86, 0xE8,  /* ........ */
                /* 00E8 */  0xF1, 0x86, 0x3B, 0x81, 0xA3, 0x3E, 0x12, 0x06,  /* ..;..>.. */
                /* 00F0 */  0x71, 0x50, 0x47, 0x83, 0x39, 0x07, 0xD8, 0xE1,  /* qPG.9... */
                /* 00F8 */  0x64, 0x34, 0xE3, 0x52, 0x05, 0x98, 0x1D, 0xBA,  /* d4.R.... */
                /* 0100 */  0x46, 0x96, 0xE0, 0x78, 0x0C, 0x7D, 0xF6, 0xE7,  /* F..x.}.. */
                /* 0108 */  0xD3, 0x33, 0x24, 0x91, 0x3F, 0x08, 0xD4, 0xC8,  /* .3$.?... */
                /* 0110 */  0x0C, 0xED, 0xA1, 0x9E, 0x56, 0xCC, 0x90, 0x4F,  /* ....V..O */
                /* 0118 */  0x01, 0x87, 0xC5, 0xC4, 0x42, 0x68, 0x93, 0x1A,  /* ....Bh.. */
                /* 0120 */  0x0F, 0xC4, 0xFF, 0xFF, 0x78, 0xC0, 0xA3, 0xF8,  /* ....x... */
                /* 0128 */  0x68, 0x20, 0x84, 0x57, 0x82, 0xD8, 0x1E, 0x50,  /* h .W...P */
                /* 0130 */  0x82, 0x01, 0x21, 0xE4, 0x64, 0x3C, 0xA8, 0x51,  /* ..!.d<.Q */
                /* 0138 */  0x18, 0x35, 0xDC, 0x61, 0x1C, 0xB5, 0x8F, 0x0F,  /* .5.a.... */
                /* 0140 */  0x3A, 0x3C, 0x50, 0x51, 0xC3, 0xA6, 0x67, 0x06,  /* :<PQ..g. */
                /* 0148 */  0x7E, 0x5C, 0x60, 0xE7, 0x82, 0x98, 0x8F, 0x00,  /* ~\`..... */
                /* 0150 */  0x1E, 0xC9, 0x09, 0xF9, 0x38, 0xE1, 0x81, 0xC1,  /* ....8... */
                /* 0158 */  0x07, 0xC4, 0x7B, 0x9F, 0x32, 0x19, 0xC1, 0x99,  /* ..{.2... */
                /* 0160 */  0x7A, 0x80, 0xE0, 0xB0, 0x3E, 0x7C, 0x02, 0xFC,  /* z...>|.. */
                /* 0168 */  0xB2, 0xF0, 0xB0, 0x90, 0xC0, 0xF7, 0x07, 0x03,  /* ........ */
                /* 0170 */  0xE3, 0x46, 0x68, 0xBF, 0x02, 0x10, 0x82, 0x97,  /* .Fh..... */
                /* 0178 */  0x79, 0x02, 0x90, 0x53, 0x04, 0x8D, 0xCD, 0xD0,  /* y..S.... */
                /* 0180 */  0x4F, 0x03, 0x2F, 0x0E, 0xE1, 0x83, 0x47, 0x38,  /* O./...G8 */
                /* 0188 */  0xDF, 0x03, 0x38, 0x85, 0xC7, 0x00, 0x0F, 0xC1,  /* ..8..... */
                /* 0190 */  0x04, 0x16, 0x39, 0x02, 0x94, 0x98, 0x11, 0xA0,  /* ..9..... */
                /* 0198 */  0x8E, 0x0D, 0x27, 0x70, 0x3C, 0x61, 0x8F, 0xE0,  /* ..'p<a.. */
                /* 01A0 */  0x78, 0xA2, 0x9C, 0xC4, 0x01, 0xF9, 0xA8, 0x61,  /* x......a */
                /* 01A8 */  0x84, 0xE0, 0xE5, 0x9E, 0x38, 0x88, 0xE6, 0x71,  /* ....8..q */
                /* 01B0 */  0x6A, 0x16, 0xEF, 0x00, 0x87, 0xC0, 0xC6, 0x84,  /* j....... */
                /* 01B8 */  0x3B, 0x40, 0x78, 0x08, 0x7C, 0x00, 0x8F, 0x1A,  /* ;@x.|... */
                /* 01C0 */  0xE7, 0x67, 0xA5, 0xB3, 0x42, 0x9E, 0x3B, 0xF8,  /* .g..B.;. */
                /* 01C8 */  0x98, 0xB0, 0x03, 0xE0, 0xD2, 0x0F, 0x27, 0x28,  /* ......'( */
                /* 01D0 */  0xB1, 0xE7, 0x13, 0x50, 0xFC, 0xFF, 0xCF, 0x27,  /* ...P...' */
                /* 01D8 */  0xC0, 0x1E, 0xE4, 0x99, 0xE4, 0xED, 0xE4, 0x68,  /* .......h */
                /* 01E0 */  0x9E, 0x4B, 0x1E, 0x48, 0x9E, 0x48, 0x9E, 0x4F,  /* .K.H.H.O */
                /* 01E8 */  0x8C, 0xF3, 0x66, 0xF2, 0x64, 0x10, 0xE1, 0xF9,  /* ..f.d... */
                /* 01F0 */  0xC4, 0xD7, 0x14, 0x23, 0x44, 0x09, 0x19, 0xE8,  /* ...#D... */
                /* 01F8 */  0xE1, 0x24, 0x42, 0x94, 0x70, 0x81, 0xC2, 0x1A,  /* .$B.p... */
                /* 0200 */  0x21, 0xC8, 0x63, 0xC1, 0x09, 0x1F, 0x76, 0xAC,  /* !.c...v. */
                /* 0208 */  0x40, 0x61, 0x9E, 0x4F, 0x98, 0xF0, 0xA7, 0x86,  /* @a.O.... */
                /* 0210 */  0x2C, 0x9C, 0x4F, 0x00, 0xBA, 0xFC, 0xFF, 0xCF,  /* ,.O..... */
                /* 0218 */  0x27, 0x80, 0x33, 0x81, 0xE7, 0x13, 0x90, 0x0E,  /* '.3..... */
                /* 0220 */  0x8F, 0x1F, 0x4F, 0x80, 0xC9, 0x08, 0xB8, 0x16,  /* ..O..... */
                /* 0228 */  0x13, 0x87, 0x2F, 0xD4, 0xE3, 0xC0, 0xA7, 0x11,  /* ../..... */
                /* 0230 */  0x40, 0xCE, 0x09, 0xE4, 0xFD, 0xE3, 0x38, 0x9F,  /* @.....8. */
                /* 0238 */  0x44, 0x7C, 0xF7, 0xF2, 0xFF, 0xFF, 0xE6, 0xE5,  /* D|...... */
                /* 0240 */  0x83, 0xC8, 0x1B, 0xC8, 0xC1, 0x3E, 0x8D, 0xB0,  /* .....>.. */
                /* 0248 */  0x51, 0x05, 0x33, 0xCA, 0xE9, 0x47, 0x88, 0xFA,  /* Q.3..G.. */
                /* 0250 */  0x52, 0x62, 0xC4, 0x08, 0xC1, 0x42, 0x05, 0x8A,  /* Rb...B.. */
                /* 0258 */  0x11, 0x35, 0xB2, 0x61, 0x23, 0xC4, 0x79, 0xF8,  /* .5.a#.y. */
                /* 0260 */  0xA2, 0x0F, 0x06, 0x0D, 0xD5, 0xA7, 0x11, 0x80,  /* ........ */
                /* 0268 */  0x1F, 0xA7, 0x09, 0xDC, 0xE9, 0x02, 0x4C, 0x93,  /* ......L. */
                /* 0270 */  0x38, 0x80, 0x28, 0x45, 0xC3, 0x68, 0x3A, 0x8F,  /* 8.(E.h:. */
                /* 0278 */  0x03, 0x01, 0x9F, 0x2F, 0x80, 0x89, 0xE2, 0x97,  /* .../.... */
                /* 0280 */  0x9E, 0xCE, 0x27, 0xFE, 0xFF, 0xAB, 0x05, 0x91,  /* ..'..... */
                /* 0288 */  0x8D, 0xB5, 0x7A, 0x58, 0x34, 0xF3, 0x03, 0x48,  /* ..zX4..H */
                /* 0290 */  0xF0, 0xC5, 0x03, 0x6B, 0xD8, 0x27, 0x79, 0x16,  /* ...k.'y. */
                /* 0298 */  0x27, 0x99, 0x60, 0x56, 0x28, 0xC1, 0x7A, 0xD8,  /* '.`V(.z. */
                /* 02A0 */  0x4E, 0x09, 0xA3, 0x04, 0x24, 0x1A, 0x8E, 0xA1,  /* N...$... */
                /* 02A8 */  0xAD, 0x19, 0x46, 0x70, 0x06, 0xF1, 0x79, 0xC8,  /* ..Fp..y. */
                /* 02B0 */  0x21, 0xCE, 0x31, 0x50, 0x8E, 0x0C, 0x1E, 0xC5,  /* !.1P.... */
                /* 02B8 */  0x59, 0x3D, 0x07, 0x78, 0x8C, 0x8F, 0x0B, 0x6C,  /* Y=.x...l */
                /* 02C0 */  0x7C, 0x3E, 0x08, 0xF0, 0xC3, 0xA0, 0x6F, 0x06,  /* |>....o. */
                /* 02C8 */  0x46, 0xB6, 0x9A, 0xD3, 0x0C, 0x0A, 0xCC, 0xC7,  /* F....... */
                /* 02D0 */  0x0B, 0x4E, 0x50, 0xD7, 0xCD, 0x05, 0x64, 0x43,  /* .NP...dC */
                /* 02D8 */  0x82, 0x79, 0x10, 0x38, 0x24, 0x30, 0x4F, 0xD5,  /* .y.8$0O. */
                /* 02E0 */  0x43, 0x02, 0x1E, 0xE0, 0x87, 0x04, 0xE6, 0x2B,  /* C......+ */
                /* 02E8 */  0x81, 0x87, 0x04, 0x2C, 0xFE, 0xFF, 0xA8, 0x07,  /* ...,.... */
                /* 02F0 */  0x71, 0x48, 0x60, 0x46, 0xF2, 0x90, 0xC0, 0xA6,  /* qH`F.... */
                /* 02F8 */  0xEF, 0xC8, 0x01, 0x0A, 0x20, 0xDF, 0x30, 0x7C,  /* .... .0| */
                /* 0300 */  0xDC, 0x7B, 0xCA, 0x60, 0x63, 0x78, 0xE2, 0x33,  /* .{.`cx.3 */
                /* 0308 */  0x9A, 0xD1, 0xB9, 0xC4, 0xE5, 0xE8, 0x42, 0xC1,  /* ......B. */
                /* 0310 */  0x45, 0xC1, 0xE8, 0x58, 0x60, 0x10, 0x4F, 0xCB,  /* E..X`.O. */
                /* 0318 */  0x51, 0xA6, 0x8A, 0x9E, 0x89, 0x7D, 0x9E, 0x42,  /* Q....}.B */
                /* 0320 */  0xC8, 0x89, 0x82, 0x5F, 0xDD, 0x74, 0x9F, 0x81,  /* ..._.t.. */
                /* 0328 */  0x76, 0xF7, 0x08, 0xEA, 0x8B, 0x0A, 0x83, 0xF3,  /* v....... */
                /* 0330 */  0x64, 0x39, 0x9C, 0xAF, 0x14, 0xFC, 0xAE, 0xE3,  /* d9...... */
                /* 0338 */  0xCB, 0x15, 0xF8, 0x46, 0x05, 0xF7, 0x50, 0xC1,  /* ...F..P. */
                /* 0340 */  0x46, 0x05, 0xF6, 0xEB, 0x88, 0x47, 0x05, 0xD6,  /* F....G.. */
                /* 0348 */  0xFF, 0xFF, 0xA8, 0x60, 0x9D, 0x2B, 0xD8, 0xA8,  /* ...`.+.. */
                /* 0350 */  0xC0, 0x7E, 0x26, 0xF0, 0xA8, 0x80, 0xCB, 0xD1,  /* .~&..... */
                /* 0358 */  0x82, 0x8D, 0x0A, 0xEC, 0x1E, 0x46, 0x05, 0xCA,  /* .....F.. */
                /* 0360 */  0x20, 0xD7, 0x0F, 0x28, 0xD0, 0x8F, 0x96, 0xAF,  /*  ..(.... */
                /* 0368 */  0x40, 0x0F, 0x41, 0x8F, 0x51, 0x1E, 0x14, 0xB8,  /* @.A.Q... */
                /* 0370 */  0x61, 0x7C, 0xDF, 0x03, 0x4E, 0x17, 0x10, 0x98,  /* a|..N... */
                /* 0378 */  0xF0, 0x18, 0xC1, 0x47, 0x18, 0xF2, 0xFF, 0x27,  /* ...G...' */
                /* 0380 */  0x28, 0x6B, 0x5C, 0xA8, 0xFB, 0x8A, 0xAF, 0x72,  /* (k\....r */
                /* 0388 */  0xEC, 0x3A, 0x85, 0xBB, 0x2A, 0x62, 0x60, 0x3D,  /* .:..*b`= */
                /* 0390 */  0x52, 0x0E, 0x6B, 0xB4, 0xB0, 0x07, 0xFC, 0xA6,  /* R.k..... */
                /* 0398 */  0xE5, 0x63, 0x9A, 0x67, 0x66, 0x8C, 0xB0, 0x1E,  /* .c.gf... */
                /* 03A0 */  0xAD, 0x13, 0xDD, 0xFA, 0x50, 0xA1, 0x6E, 0x7D,  /* ....P.n} */
                /* 03A8 */  0x80, 0xA0, 0x73, 0xC0, 0xDB, 0xBB, 0x67, 0xFE,  /* ..s...g. */
                /* 03B0 */  0xB4, 0x17, 0xE4, 0x5D, 0xCF, 0x37, 0x78, 0x06,  /* ...].7x. */
                /* 03B8 */  0x11, 0xE9, 0xAD, 0xCF, 0xC7, 0xBD, 0xF7, 0xAF,  /* ........ */
                /* 03C0 */  0x67, 0x3E, 0x9F, 0x6C, 0x7D, 0x76, 0xF7, 0xC1,  /* g>.l}v.. */
                /* 03C8 */  0xCF, 0xA8, 0xB1, 0x02, 0xFB, 0x48, 0x6B, 0x30,  /* .....Hk0 */
                /* 03D0 */  0xC3, 0x1A, 0xE4, 0xAD, 0x8F, 0x05, 0xBC, 0xF5,  /* ........ */
                /* 03D8 */  0x01, 0xA2, 0xFE, 0xFF, 0xB7, 0x3E, 0x60, 0x8F,  /* .....>`. */
                /* 03E0 */  0xF5, 0xD6, 0x07, 0x7E, 0xC4, 0x73, 0xC4, 0xDD,  /* ...~.s.. */
                /* 03E8 */  0xFB, 0x80, 0x47, 0xE6, 0x7B, 0x1F, 0xCD, 0x7B,  /* ..G.{..{ */
                /* 03F0 */  0xEF, 0x43, 0x67, 0x01, 0xD2, 0xBD, 0x0F, 0x9F,  /* .Cg..... */
                /* 03F8 */  0x01, 0x96, 0x0E, 0xDC, 0xEA, 0x61, 0x74, 0xEF,  /* .....at. */
                /* 0400 */  0x03, 0x6C, 0xFD, 0xFF, 0xEF, 0x7D, 0x00, 0xA7,  /* .l...}.. */
                /* 0408 */  0xA3, 0xDF, 0xFB, 0x50, 0x61, 0xEF, 0x7D, 0x14,  /* ...Pa.}. */
                /* 0410 */  0xC4, 0xF7, 0x2D, 0x5F, 0xC4, 0xF0, 0xFF, 0xFF,  /* ..-_.... */
                /* 0418 */  0x7B, 0x1F, 0xC0, 0xFF, 0xFF, 0xFF, 0xBD, 0x0F,  /* {....... */
                /* 0420 */  0xFC, 0xC1, 0x20, 0x64, 0xE4, 0xE2, 0x43, 0x47,  /* .. d..CG */
                /* 0428 */  0xE5, 0xAB, 0x99, 0x47, 0xC5, 0x2E, 0x47, 0xBE,  /* ...G..G. */
                /* 0430 */  0x05, 0x45, 0x78, 0x36, 0x63, 0x17, 0x11, 0x9F,  /* .Ex6c... */
                /* 0438 */  0x1B, 0x3C, 0x2C, 0x70, 0x0D, 0xE7, 0xA5, 0x82,  /* .<,p.... */
                /* 0440 */  0x5D, 0xF6, 0x7C, 0x01, 0x84, 0x7B, 0xAB, 0xF3,  /* ].|..{.. */
                /* 0448 */  0xE8, 0xC0, 0x71, 0x2F, 0x7B, 0x47, 0x04, 0x76,  /* ..q/{G.v */
                /* 0450 */  0x8F, 0x3D, 0xDF, 0x11, 0x81, 0xF7, 0xDD, 0xCF,  /* .=...... */
                /* 0458 */  0x17, 0x43, 0x7E, 0x47, 0x04, 0x8F, 0x42, 0x9B,  /* .C~G..B. */
                /* 0460 */  0x3E, 0x35, 0xFE, 0xFF, 0x8D, 0x5A, 0x35, 0x28,  /* >5...Z5( */
                /* 0468 */  0x53, 0xA3, 0x4C, 0x83, 0x5A, 0x7D, 0x2A, 0x35,  /* S.L.Z}*5 */
                /* 0470 */  0x66, 0x6C, 0x7C, 0x8E, 0x41, 0xA6, 0x01, 0x58,  /* fl|.A..X */
                /* 0478 */  0xC4, 0x0B, 0x48, 0x20, 0x0E, 0x09, 0x42, 0x45,  /* ..H ..BE */
                /* 0480 */  0xBE, 0x40, 0x04, 0xE2, 0x88, 0x20, 0x34, 0xC2,  /* .@... 4. */
                /* 0488 */  0x03, 0x43, 0x20, 0x8E, 0xB7, 0x20, 0x81, 0x58,  /* .C .. .X */
                /* 0490 */  0xDC, 0x7A, 0x05, 0xE2, 0x20, 0x2A, 0x0E, 0x0D,  /* .z.. *.. */
                /* 0498 */  0x02, 0x51, 0x2A, 0x10, 0x5D, 0x7E, 0xC8, 0x0B,  /* .Q*.]~.. */
                /* 04A0 */  0x40, 0x40, 0x56, 0x06, 0x22, 0x20, 0x07, 0x02,  /* @@V." .. */
                /* 04A8 */  0xA2, 0xE9, 0x80, 0xA8, 0xA8, 0x07, 0x81, 0x80,  /* ........ */
                /* 04B0 */  0xAC, 0x10, 0x44, 0x40, 0x56, 0x63, 0x03, 0x88,  /* ..D@Vc.. */
                /* 04B8 */  0x69, 0x03, 0x11, 0x90, 0x73, 0x01, 0xD1, 0x94,  /* i...s... */
                /* 04C0 */  0x40, 0x54, 0xA1, 0x0E, 0x20, 0xA6, 0x17, 0x44,  /* @T.. ..D */
                /* 04C8 */  0x40, 0xCE, 0x0A, 0x44, 0x93, 0x03, 0x51, 0xCD,  /* @..D..Q. */
                /* 04D0 */  0x3E, 0x80, 0x58, 0x02, 0x10, 0x01, 0x39, 0x29,  /* >.X...9) */
                /* 04D8 */  0x8D, 0x40, 0xAC, 0x53, 0xC9, 0x20, 0xE8, 0x7B,  /* .@.S. .{ */
                /* 04E0 */  0x41, 0x80, 0x0E, 0x09, 0x22, 0x20, 0x6B, 0x7B,  /* A..." k{ */
                /* 04E8 */  0x5C, 0x08, 0xC8, 0x42, 0x41, 0x04, 0xE4, 0x7C,  /* \..BA..| */
                /* 04F0 */  0x40, 0x34, 0x2C, 0x10, 0xD5, 0x68, 0x05, 0x88,  /* @4,..h.. */
                /* 04F8 */  0x09, 0x06, 0xD1, 0x50, 0x89, 0x16, 0x20, 0x26,  /* ...P.. & */
                /* 0500 */  0x15, 0x44, 0x40, 0x8E, 0x09, 0x44, 0x43, 0x03,  /* .D@..DC. */
                /* 0508 */  0x51, 0xC1, 0x5E, 0x80, 0x98, 0x7C, 0x10, 0x01,  /* Q.^..|.. */
                /* 0510 */  0x39, 0x3A, 0x10, 0x15, 0xF2, 0x26, 0x10, 0x90,  /* 9:...&.. */
                /* 0518 */  0x43, 0x81, 0x08, 0xC8, 0x11, 0x81, 0xA8, 0x34,  /* C......4 */
                /* 0520 */  0x33, 0x03, 0xA2, 0x20, 0x02, 0xF2, 0xFF, 0x1F   /* 3.. .... */
            })
        }

        Device (LID0)
        {
            Name (_HID, EisaId ("PNP0C0D") /* Lid Device */)  // _HID: Hardware ID
            Method (_LID, 0, NotSerialized)  // _LID: Lid Status
            {
                If (ECON)
                {
                    Local0 = ^^PCI0.LPC.EC0.KLID /* \_SB_.PCI0.LPC_.EC0_.KLID */
                }
                Else
                {
                    Local0 = (RBEC (0x59) & 0x08)
                }

                LIDS = Local0
                If (LIDS)
                {
                    Return (One)
                }
                Else
                {
                    Return (Zero)
                }
            }

            Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
            {
                0x1D, 
                0x03
            })
        }

        Device (SLPB)
        {
            Name (_HID, EisaId ("PNP0C0E") /* Sleep Button Device */)  // _HID: Hardware ID
            Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
            {
                0x1D, 
                0x03
            })
        }

        Name (NATP, Zero)
        Name (DCKT, Zero)
        Name (NDFL, Zero)
        OperationRegion (DLCT, SystemIO, 0x1600, 0x02)
        Field (DLCT, ByteAcc, NoLock, Preserve)
        {
            DLCO,   1, 
            DCLK,   2, 
            DEXP,   1
        }

        OperationRegion (DKIO, SystemIO, 0x1660, 0x10)
        Field (DKIO, ByteAcc, NoLock, Preserve)
        {
            Offset (0x01), 
            DKI0,   1
        }

        OperationRegion (GPIO, SystemIO, 0x0500, 0x10)
        Field (GPIO, ByteAcc, NoLock, Preserve)
        {
            GU00,   8, 
            GU01,   8, 
            GU02,   8, 
            GU03,   8, 
            GIO0,   8, 
            GIO1,   8, 
            GIO2,   8, 
            GIO3,   8, 
            Offset (0x0C), 
            GL00,   8, 
                ,   2, 
            GP10,   1, 
            Offset (0x0E), 
            GL02,   8, 
            GP24,   1, 
            Offset (0x10)
        }

        Device (DOCK)
        {
            Name (_HID, EisaId ("PNP0C15") /* Docking Station */)  // _HID: Hardware ID
            Name (_UID, One)  // _UID: Unique ID
            Method (_DCK, 1, NotSerialized)  // _DCK: Dock Present
            {
                If ((Arg0 == One))
                {
                    DKIN ()
                    If (IGDS)
                    {
                        If ((OSYS == 0x07D1))
                        {
                            Sleep (0x07D0)
                            ^^PCI0.LPC.EC0.HKDS (0x02)
                        }
                    }

                    Return (One)
                }

                DKOU ()
                If (IGDS)
                {
                    If ((OSYS == 0x07D1))
                    {
                        Sleep (0x07D0)
                        ^^PCI0.LPC.EC0.HKDS (One)
                    }
                }

                Return (Zero)
            }

            Method (_EJ0, 1, NotSerialized)  // _EJx: Eject Device
            {
            }

            Method (_EJ4, 1, NotSerialized)  // _EJx: Eject Device
            {
            }

            Method (_STA, 0, NotSerialized)  // _STA: Status
            {
                If (NATP)
                {
                    Return (0x0F)
                }

                Return (Zero)
            }

            Method (DKIN, 0, Serialized)
            {
                Sleep (0x01F4)
                ^^PCI0.LPC.EC0.KDKP = One
                Sleep (0x64)
                ^^PCI0.LPC.SIO.R07H = 0x19
                ^^PCI0.LPC.SIO.R30H = One
                DLCO = One
                DCLK = 0x02
                Local0 = 0xC8
                If ((GP24 == One))
                {
                    NDFL = One
                }
                Else
                {
                    If ((GP10 == One))
                    {
                        NDFL = Zero
                    }
                    Else
                    {
                        NDFL = One
                    }
                }

                While (Local0)
                {
                    If ((DEXP && (^^PCI0.LPC.SIO.Z20H == 0xEA)))
                    {
                        Local0 = Zero
                        If ((NDFL != One))
                        {
                            ^^PCI0.LPC.SIO.R26H = 0x08
                        }

                        ^^PCI0.LPC.SIO.Z21H = 0x11
                        ^^PCI0.LPC.SIO.Z22H = 0x0C
                        ^^PCI0.LPC.SIO.Z23H = Zero
                        ^^PCI0.LPC.SIO.Z24H = 0x28
                        ^^PCI0.LPC.SIO.Z25H = 0x80
                        ^^PCI0.LPC.SIO.Z26H = Zero
                        ^^PCI0.LPC.SIO.Z28H = Zero
                        ^^PCI0.LPC.SIO.Z29H = 0x06
                        ^^PCI0.LPC.SIO.Z2AH = 0x37
                        ^^PCI0.LPC.SIO.Z07H = One
                        ^^PCI0.LPC.SIO.Z60H = 0x03
                        ^^PCI0.LPC.SIO.Z61H = 0x78
                        ^^PCI0.LPC.SIO.Z70H = 0x07
                        ^^PCI0.LPC.SIO.Z71H = 0x03
                        ^^PCI0.LPC.SIO.Z74H = 0x04
                        ^^PCI0.LPC.SIO.ZF0H = 0x22
                        ^^PCI0.LPC.SIO.Z07H = 0x07
                        ^^PCI0.LPC.SIO.Z60H = 0x16
                        ^^PCI0.LPC.SIO.Z61H = 0x60
                        ^^PCI0.LPC.SIO.Z30H = One
                        DCKT = DKI0 /* \_SB_.DKI0 */
                        ^^PCI0.LPC.SIO.Z30H = Zero
                        NATP = One
                        Notify (DOCK, Zero) // Bus Check
                    }
                    Else
                    {
                        Sleep (One)
                        Local0--
                    }
                }

                If ((NATP == Zero))
                {
                    DLCO = Zero
                    DCLK = Zero
                    ^^PCI0.LPC.EC0.KDKP = Zero
                    Notify (DOCK, One) // Device Check
                }

                ^^PCI0.LPC.SIO.R30H = Zero
            }

            Method (DKOU, 0, Serialized)
            {
                Sleep (0x01F4)
                ^^PCI0.LPC.SIO.R07H = 0x19
                ^^PCI0.LPC.SIO.R30H = One
                DLCO = Zero
                DCLK = Zero
                ^^PCI0.LPC.SIO.R30H = Zero
                GP24 = Zero
                If ((NDFL != One))
                {
                    ^^PCI0.LPC.SIO.R26H = Zero
                }

                ^^PCI0.LPC.EC0.KDKP = Zero
                NATP = Zero
                Notify (DOCK, One) // Device Check
            }

            Method (DPTS, 1, NotSerialized)
            {
                GP24 = Zero
            }

            Method (DWAK, 1, NotSerialized)
            {
                If (((Arg0 == 0x03) || (Arg0 == 0x04)))
                {
                    If (^^PCI0.LPC.EC0.KDCK)
                    {
                        DKIN ()
                    }
                    Else
                    {
                        DKOU ()
                    }
                }
            }
        }

        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A08") /* PCI Express Bus */)  // _HID: Hardware ID
            Name (_CID, EisaId ("PNP0A03") /* PCI Bus */)  // _CID: Compatible ID
            Name (_ADR, Zero)  // _ADR: Address
            Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
            {
                Return (0x02)
            }

            Method (_INI, 0, NotSerialized)  // _INI: Initialize
            {
                If (CondRefOf (_OSI, Local0))
                {
                    If (_OSI ("Linux"))
                    {
                        OSYS = 0x03E8
                    }
                    Else
                    {
                        If (_OSI ("Windows 2006"))
                        {
                            OSYS = 0x07D6
                        }
                        Else
                        {
                            OSYS = 0x07D1
                        }
                    }
                }
                Else
                {
                    OSYS = 0x07D0
                }

                OSY1 = OSYS /* \OSYS */
            }

            Method (_OSC, 5, NotSerialized)  // _OSC: Operating System Capabilities
            {
                Local0 = Arg3
                Local1 = (Local0 * 0x04)
                Name (BUF1, Buffer (Local1) {})
                BUF1 = Arg4
                Local1 = Zero
                Local2 = Zero
                While (Local0)
                {
                    Local2 = (Local1 * 0x04)
                    CreateDWordField (BUF1, Local2, CAPB)
                    If (Arg2)
                    {
                        If ((Local1 == Zero))
                        {
                            (CAPB & 0xFFFFFFFC)
                        }
                    }
                    Else
                    {
                    }

                    Local1++
                    Local0--
                }

                Return (BUF1) /* \_SB_.PCI0._OSC.BUF1 */
            }

            Name (_BBN, Zero)  // _BBN: BIOS Bus Number
            OperationRegion (HBUS, PCI_Config, 0x40, 0xC0)
            Field (HBUS, DWordAcc, NoLock, Preserve)
            {
                Offset (0x50), 
                    ,   4, 
                PM0H,   2, 
                Offset (0x51), 
                PM1L,   2, 
                    ,   2, 
                PM1H,   2, 
                Offset (0x52), 
                PM2L,   2, 
                    ,   2, 
                PM2H,   2, 
                Offset (0x53), 
                PM3L,   2, 
                    ,   2, 
                PM3H,   2, 
                Offset (0x54), 
                PM4L,   2, 
                    ,   2, 
                PM4H,   2, 
                Offset (0x55), 
                PM5L,   2, 
                    ,   2, 
                PM5H,   2, 
                Offset (0x56), 
                PM6L,   2, 
                    ,   2, 
                PM6H,   2, 
                Offset (0x57), 
                    ,   7, 
                HENA,   1, 
                Offset (0x62), 
                TUUD,   16, 
                Offset (0x70), 
                    ,   4, 
                TLUD,   12
            }

            Name (BUF0, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x00FF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0100,             // Length
                    0x00,, )
                DWordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000CF7,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000CF8,         // Length
                    0x00,, , TypeStatic)
                IO (Decode16,
                    0x0CF8,             // Range Minimum
                    0x0CF8,             // Range Maximum
                    0x01,               // Alignment
                    0x08,               // Length
                    )
                DWordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x00000000,         // Granularity
                    0x00000D00,         // Range Minimum
                    0x0000FFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x0000F300,         // Length
                    0x00,, , TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000A0000,         // Range Minimum
                    0x000BFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    0x00,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C0000,         // Range Minimum
                    0x000C3FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y00, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C4000,         // Range Minimum
                    0x000C7FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y01, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C8000,         // Range Minimum
                    0x000CBFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y02, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000CC000,         // Range Minimum
                    0x000CFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y03, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000D0000,         // Range Minimum
                    0x000D3FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y04, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000D4000,         // Range Minimum
                    0x000D7FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y05, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000D8000,         // Range Minimum
                    0x000DBFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y06, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000DC000,         // Range Minimum
                    0x000DFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y07, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000E0000,         // Range Minimum
                    0x000E3FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y08, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000E4000,         // Range Minimum
                    0x000E7FFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y09, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000E8000,         // Range Minimum
                    0x000EBFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y0A, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000EC000,         // Range Minimum
                    0x000EFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00004000,         // Length
                    0x00,, _Y0B, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000F0000,         // Range Minimum
                    0x000FFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00010000,         // Length
                    0x00,, _Y0C, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0xFED4FFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    0x00,, _Y0D, AddressRangeMemory, TypeStatic)
            })
            Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
            {
                If (PM1L)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y00._LEN, C0LN)  // _LEN: Length
                    C0LN = Zero
                }

                If ((PM1L == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y00._RW, C0RW)  // _RW_: Read-Write Status
                    C0RW = Zero
                }

                If (PM1H)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y01._LEN, C4LN)  // _LEN: Length
                    C4LN = Zero
                }

                If ((PM1H == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y01._RW, C4RW)  // _RW_: Read-Write Status
                    C4RW = Zero
                }

                If (PM2L)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y02._LEN, C8LN)  // _LEN: Length
                    C8LN = Zero
                }

                If ((PM2L == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y02._RW, C8RW)  // _RW_: Read-Write Status
                    C8RW = Zero
                }

                If (PM2H)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y03._LEN, CCLN)  // _LEN: Length
                    CCLN = Zero
                }

                If ((PM2H == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y03._RW, CCRW)  // _RW_: Read-Write Status
                    CCRW = Zero
                }

                If (PM3L)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y04._LEN, D0LN)  // _LEN: Length
                    D0LN = Zero
                }

                If ((PM3L == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y04._RW, D0RW)  // _RW_: Read-Write Status
                    D0RW = Zero
                }

                If (PM3H)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y05._LEN, D4LN)  // _LEN: Length
                    D4LN = Zero
                }

                If ((PM3H == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y05._RW, D4RW)  // _RW_: Read-Write Status
                    D4RW = Zero
                }

                If (PM4L)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y06._LEN, D8LN)  // _LEN: Length
                    D8LN = Zero
                }

                If ((PM4L == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y06._RW, D8RW)  // _RW_: Read-Write Status
                    D8RW = Zero
                }

                If (PM4H)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y07._LEN, DCLN)  // _LEN: Length
                    DCLN = Zero
                }

                If ((PM4H == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y07._RW, DCRW)  // _RW_: Read-Write Status
                    DCRW = Zero
                }

                If (PM5L)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y08._LEN, E0LN)  // _LEN: Length
                    E0LN = Zero
                }

                If ((PM5L == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y08._RW, E0RW)  // _RW_: Read-Write Status
                    E0RW = Zero
                }

                If (PM5H)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y09._LEN, E4LN)  // _LEN: Length
                    E4LN = Zero
                }

                If ((PM5H == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y09._RW, E4RW)  // _RW_: Read-Write Status
                    E4RW = Zero
                }

                If (PM6L)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y0A._LEN, E8LN)  // _LEN: Length
                    E8LN = Zero
                }

                If ((PM6L == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y0A._RW, E8RW)  // _RW_: Read-Write Status
                    E8RW = Zero
                }

                If (PM6H)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y0B._LEN, ECLN)  // _LEN: Length
                    ECLN = Zero
                }

                If ((PM6H == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y0B._RW, ECRW)  // _RW_: Read-Write Status
                    ECRW = Zero
                }

                If (PM0H)
                {
                    CreateDWordField (BUF0, \_SB.PCI0._Y0C._LEN, F0LN)  // _LEN: Length
                    F0LN = Zero
                }

                If ((PM0H == One))
                {
                    CreateBitField (BUF0, \_SB.PCI0._Y0C._RW, F0RW)  // _RW_: Read-Write Status
                    F0RW = Zero
                }

                CreateDWordField (BUF0, \_SB.PCI0._Y0D._MIN, M1MN)  // _MIN: Minimum Base Address
                CreateDWordField (BUF0, \_SB.PCI0._Y0D._MAX, M1MX)  // _MAX: Maximum Base Address
                CreateDWordField (BUF0, \_SB.PCI0._Y0D._LEN, M1LN)  // _LEN: Length
                M1MN = (TLUD << 0x14)
                M1LN = ((M1MX - M1MN) + One)
                Return (BUF0) /* \_SB_.PCI0.BUF0 */
            }

            Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
            {
                If ((GPIC == Zero))
                {
                    Return (Package (0x10)
                    {
                        Package (0x04)
                        {
                            0x0002FFFF, 
                            Zero, 
                            ^LPC.LNKA, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001AFFFF, 
                            Zero, 
                            ^LPC.LNKA, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001AFFFF, 
                            One, 
                            ^LPC.LNKF, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001AFFFF, 
                            0x02, 
                            ^LPC.LNKC, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001BFFFF, 
                            Zero, 
                            ^LPC.LNKG, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001CFFFF, 
                            Zero, 
                            ^LPC.LNKB, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001CFFFF, 
                            One, 
                            ^LPC.LNKA, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001CFFFF, 
                            0x02, 
                            ^LPC.LNKC, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001CFFFF, 
                            0x03, 
                            ^LPC.LNKD, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001DFFFF, 
                            Zero, 
                            ^LPC.LNKH, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001DFFFF, 
                            One, 
                            ^LPC.LNKD, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001DFFFF, 
                            0x02, 
                            ^LPC.LNKC, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001DFFFF, 
                            0x03, 
                            ^LPC.LNKA, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001FFFFF, 
                            One, 
                            ^LPC.LNKD, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001FFFFF, 
                            0x02, 
                            ^LPC.LNKD, 
                            Zero
                        }, 

                        Package (0x04)
                        {
                            0x001FFFFF, 
                            0x03, 
                            ^LPC.LNKD, 
                            Zero
                        }
                    })
                }
                Else
                {
                    Return (Package (0x10)
                    {
                        Package (0x04)
                        {
                            0x0002FFFF, 
                            Zero, 
                            Zero, 
                            0x10
                        }, 

                        Package (0x04)
                        {
                            0x001AFFFF, 
                            Zero, 
                            Zero, 
                            0x10
                        }, 

                        Package (0x04)
                        {
                            0x001AFFFF, 
                            One, 
                            Zero, 
                            0x15
                        }, 

                        Package (0x04)
                        {
                            0x001AFFFF, 
                            0x02, 
                            Zero, 
                            0x12
                        }, 

                        Package (0x04)
                        {
                            0x001BFFFF, 
                            Zero, 
                            Zero, 
                            0x16
                        }, 

                        Package (0x04)
                        {
                            0x001CFFFF, 
                            Zero, 
                            Zero, 
                            0x11
                        }, 

                        Package (0x04)
                        {
                            0x001CFFFF, 
                            One, 
                            Zero, 
                            0x10
                        }, 

                        Package (0x04)
                        {
                            0x001CFFFF, 
                            0x02, 
                            Zero, 
                            0x12
                        }, 

                        Package (0x04)
                        {
                            0x001CFFFF, 
                            0x03, 
                            Zero, 
                            0x13
                        }, 

                        Package (0x04)
                        {
                            0x001DFFFF, 
                            Zero, 
                            Zero, 
                            0x17
                        }, 

                        Package (0x04)
                        {
                            0x001DFFFF, 
                            One, 
                            Zero, 
                            0x13
                        }, 

                        Package (0x04)
                        {
                            0x001DFFFF, 
                            0x02, 
                            Zero, 
                            0x12
                        }, 

                        Package (0x04)
                        {
                            0x001DFFFF, 
                            0x03, 
                            Zero, 
                            0x10
                        }, 

                        Package (0x04)
                        {
                            0x001FFFFF, 
                            One, 
                            Zero, 
                            0x13
                        }, 

                        Package (0x04)
                        {
                            0x001FFFFF, 
                            0x02, 
                            Zero, 
                            0x13
                        }, 

                        Package (0x04)
                        {
                            0x001FFFFF, 
                            0x03, 
                            Zero, 
                            0x13
                        }
                    })
                }
            }

            Device (P32)
            {
                Name (_ADR, 0x001E0000)  // _ADR: Address
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If ((GPIC == Zero))
                    {
                        Return (Package (0x03)
                        {
                            Package (0x04)
                            {
                                0x0006FFFF, 
                                Zero, 
                                ^^LPC.LNKG, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0x0006FFFF, 
                                0x02, 
                                ^^LPC.LNKF, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0x0006FFFF, 
                                0x03, 
                                ^^LPC.LNKG, 
                                Zero
                            }
                        })
                    }
                    Else
                    {
                        Return (Package (0x03)
                        {
                            Package (0x04)
                            {
                                0x0006FFFF, 
                                Zero, 
                                Zero, 
                                0x16
                            }, 

                            Package (0x04)
                            {
                                0x0006FFFF, 
                                0x02, 
                                Zero, 
                                0x15
                            }, 

                            Package (0x04)
                            {
                                0x0006FFFF, 
                                0x03, 
                                Zero, 
                                0x16
                            }
                        })
                    }
                }
            }

            Device (LPC)
            {
                Name (_ADR, 0x001F0000)  // _ADR: Address
                OperationRegion (LPC0, PCI_Config, 0x40, 0xC0)
                Field (LPC0, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x20), 
                    PARC,   8, 
                    PBRC,   8, 
                    PCRC,   8, 
                    PDRC,   8, 
                    Offset (0x28), 
                    PERC,   8, 
                    PFRC,   8, 
                    PGRC,   8, 
                    PHRC,   8, 
                    Offset (0x40), 
                    IOD0,   8, 
                    IOD1,   8
                }

                OperationRegion (PRR0, PCI_Config, 0x60, 0x04)
                Field (PRR0, AnyAcc, NoLock, Preserve)
                {
                    PIRA,   8, 
                    PIRB,   8, 
                    PIRC,   8, 
                    PIRD,   8
                }

                OperationRegion (PRR1, PCI_Config, 0x68, 0x04)
                Field (PRR1, AnyAcc, NoLock, Preserve)
                {
                    PIRE,   8, 
                    PIRF,   8, 
                    PIRG,   8, 
                    PIRH,   8
                }

                OperationRegion (PRR2, PCI_Config, 0x80, 0x02)
                Field (PRR2, AnyAcc, NoLock, Preserve)
                {
                    IODL,   8, 
                    IODH,   8
                }

                Device (LNKA)
                {
                    Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                    Name (_UID, One)  // _UID: Unique ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If ((PIRA & 0x80))
                        {
                            Return (0x09)
                        }
                        Else
                        {
                            Return (0x0B)
                        }
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        PIRA |= 0x80
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (BUF0, ResourceTemplate ()
                        {
                            IRQ (Level, ActiveLow, Shared, )
                                {0}
                        })
                        CreateWordField (BUF0, One, IRQW)
                        If ((PIRA & 0x80))
                        {
                            Local0 = Zero
                        }
                        Else
                        {
                            Local0 = One
                        }

                        IRQW = (Local0 << (PIRA & 0x0F))
                        Return (BUF0) /* \_SB_.PCI0.LPC_.LNKA._CRS.BUF0 */
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,7,9,10,11,12}
                    })
                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateWordField (Arg0, One, IRQW)
                        FindSetRightBit (IRQW, Local0)
                        If ((IRQW != Zero))
                        {
                            Local0 &= 0x7F
                            Local0--
                        }
                        Else
                        {
                            Local0 |= 0x80
                        }

                        PIRA = Local0
                    }
                }

                Device (LNKB)
                {
                    Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                    Name (_UID, 0x02)  // _UID: Unique ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If ((PIRB & 0x80))
                        {
                            Return (0x09)
                        }
                        Else
                        {
                            Return (0x0B)
                        }
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        PIRB |= 0x80
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (BUF0, ResourceTemplate ()
                        {
                            IRQ (Level, ActiveLow, Shared, )
                                {0}
                        })
                        CreateWordField (BUF0, One, IRQW)
                        If ((PIRB & 0x80))
                        {
                            Local0 = Zero
                        }
                        Else
                        {
                            Local0 = One
                        }

                        IRQW = (Local0 << (PIRB & 0x0F))
                        Return (BUF0) /* \_SB_.PCI0.LPC_.LNKB._CRS.BUF0 */
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,7,9,10,11,12}
                    })
                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateWordField (Arg0, One, IRQW)
                        FindSetRightBit (IRQW, Local0)
                        If ((IRQW != Zero))
                        {
                            Local0 &= 0x7F
                            Local0--
                        }
                        Else
                        {
                            Local0 |= 0x80
                        }

                        PIRB = Local0
                    }
                }

                Device (LNKC)
                {
                    Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                    Name (_UID, 0x03)  // _UID: Unique ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If ((PIRC & 0x80))
                        {
                            Return (0x09)
                        }
                        Else
                        {
                            Return (0x0B)
                        }
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        PIRC |= 0x80
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (BUF0, ResourceTemplate ()
                        {
                            IRQ (Level, ActiveLow, Shared, )
                                {0}
                        })
                        CreateWordField (BUF0, One, IRQW)
                        If ((PIRC & 0x80))
                        {
                            Local0 = Zero
                        }
                        Else
                        {
                            Local0 = One
                        }

                        IRQW = (Local0 << (PIRC & 0x0F))
                        Return (BUF0) /* \_SB_.PCI0.LPC_.LNKC._CRS.BUF0 */
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,7,9,10,11,12}
                    })
                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateWordField (Arg0, One, IRQW)
                        FindSetRightBit (IRQW, Local0)
                        If ((IRQW != Zero))
                        {
                            Local0 &= 0x7F
                            Local0--
                        }
                        Else
                        {
                            Local0 |= 0x80
                        }

                        PIRC = Local0
                    }
                }

                Device (LNKD)
                {
                    Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                    Name (_UID, 0x04)  // _UID: Unique ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If ((PIRD & 0x80))
                        {
                            Return (0x09)
                        }
                        Else
                        {
                            Return (0x0B)
                        }
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        PIRD |= 0x80
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (BUF0, ResourceTemplate ()
                        {
                            IRQ (Level, ActiveLow, Shared, )
                                {0}
                        })
                        CreateWordField (BUF0, One, IRQW)
                        If ((PIRD & 0x80))
                        {
                            Local0 = Zero
                        }
                        Else
                        {
                            Local0 = One
                        }

                        IRQW = (Local0 << (PIRD & 0x0F))
                        Return (BUF0) /* \_SB_.PCI0.LPC_.LNKD._CRS.BUF0 */
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,7,9,10,11,12}
                    })
                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateWordField (Arg0, One, IRQW)
                        FindSetRightBit (IRQW, Local0)
                        If ((IRQW != Zero))
                        {
                            Local0 &= 0x7F
                            Local0--
                        }
                        Else
                        {
                            Local0 |= 0x80
                        }

                        PIRD = Local0
                    }
                }

                Device (LNKE)
                {
                    Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                    Name (_UID, 0x05)  // _UID: Unique ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If ((PIRE & 0x80))
                        {
                            Return (0x09)
                        }
                        Else
                        {
                            Return (0x0B)
                        }
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        PIRE |= 0x80
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (BUF0, ResourceTemplate ()
                        {
                            IRQ (Level, ActiveLow, Shared, )
                                {0}
                        })
                        CreateWordField (BUF0, One, IRQW)
                        If ((PIRE & 0x80))
                        {
                            Local0 = Zero
                        }
                        Else
                        {
                            Local0 = One
                        }

                        IRQW = (Local0 << (PIRE & 0x0F))
                        Return (BUF0) /* \_SB_.PCI0.LPC_.LNKE._CRS.BUF0 */
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,7,9,10,11,12}
                    })
                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateWordField (Arg0, One, IRQW)
                        FindSetRightBit (IRQW, Local0)
                        If ((IRQW != Zero))
                        {
                            Local0 &= 0x7F
                            Local0--
                        }
                        Else
                        {
                            Local0 |= 0x80
                        }

                        PIRE = Local0
                    }
                }

                Device (LNKF)
                {
                    Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                    Name (_UID, 0x06)  // _UID: Unique ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If ((PIRF & 0x80))
                        {
                            Return (0x09)
                        }
                        Else
                        {
                            Return (0x0B)
                        }
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        PIRF |= 0x80
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (BUF0, ResourceTemplate ()
                        {
                            IRQ (Level, ActiveLow, Shared, )
                                {0}
                        })
                        CreateWordField (BUF0, One, IRQW)
                        If ((PIRF & 0x80))
                        {
                            Local0 = Zero
                        }
                        Else
                        {
                            Local0 = One
                        }

                        IRQW = (Local0 << (PIRF & 0x0F))
                        Return (BUF0) /* \_SB_.PCI0.LPC_.LNKF._CRS.BUF0 */
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,7,9,10,11,12}
                    })
                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateWordField (Arg0, One, IRQW)
                        FindSetRightBit (IRQW, Local0)
                        If ((IRQW != Zero))
                        {
                            Local0 &= 0x7F
                            Local0--
                        }
                        Else
                        {
                            Local0 |= 0x80
                        }

                        PIRF = Local0
                    }
                }

                Device (LNKG)
                {
                    Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                    Name (_UID, 0x07)  // _UID: Unique ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If ((PIRG & 0x80))
                        {
                            Return (0x09)
                        }
                        Else
                        {
                            Return (0x0B)
                        }
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        PIRG |= 0x80
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (BUF0, ResourceTemplate ()
                        {
                            IRQ (Level, ActiveLow, Shared, )
                                {0}
                        })
                        CreateWordField (BUF0, One, IRQW)
                        If ((PIRG & 0x80))
                        {
                            Local0 = Zero
                        }
                        Else
                        {
                            Local0 = One
                        }

                        IRQW = (Local0 << (PIRG & 0x0F))
                        Return (BUF0) /* \_SB_.PCI0.LPC_.LNKG._CRS.BUF0 */
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,7,9,10,11,12}
                    })
                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateWordField (Arg0, One, IRQW)
                        FindSetRightBit (IRQW, Local0)
                        If ((IRQW != Zero))
                        {
                            Local0 &= 0x7F
                            Local0--
                        }
                        Else
                        {
                            Local0 |= 0x80
                        }

                        PIRG = Local0
                    }
                }

                Device (LNKH)
                {
                    Name (_HID, EisaId ("PNP0C0F") /* PCI Interrupt Link Device */)  // _HID: Hardware ID
                    Name (_UID, 0x08)  // _UID: Unique ID
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If ((PIRH & 0x80))
                        {
                            Return (0x09)
                        }
                        Else
                        {
                            Return (0x0B)
                        }
                    }

                    Method (_DIS, 0, NotSerialized)  // _DIS: Disable Device
                    {
                        PIRH |= 0x80
                    }

                    Method (_CRS, 0, NotSerialized)  // _CRS: Current Resource Settings
                    {
                        Name (BUF0, ResourceTemplate ()
                        {
                            IRQ (Level, ActiveLow, Shared, )
                                {0}
                        })
                        CreateWordField (BUF0, One, IRQW)
                        If ((PIRH & 0x80))
                        {
                            Local0 = Zero
                        }
                        Else
                        {
                            Local0 = One
                        }

                        IRQW = (Local0 << (PIRH & 0x0F))
                        Return (BUF0) /* \_SB_.PCI0.LPC_.LNKH._CRS.BUF0 */
                    }

                    Name (_PRS, ResourceTemplate ()  // _PRS: Possible Resource Settings
                    {
                        IRQ (Level, ActiveLow, Shared, )
                            {3,4,5,7,9,10,11,12}
                    })
                    Method (_SRS, 1, NotSerialized)  // _SRS: Set Resource Settings
                    {
                        CreateWordField (Arg0, One, IRQW)
                        FindSetRightBit (IRQW, Local0)
                        If ((IRQW != Zero))
                        {
                            Local0 &= 0x7F
                            Local0--
                        }
                        Else
                        {
                            Local0 |= 0x80
                        }

                        PIRH = Local0
                    }
                }

                Device (SYSR)
                {
                    Name (_HID, EisaId ("PNP0C02") /* PNP Motherboard Resources */)  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x002E,             // Range Minimum
                            0x002E,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x004E,             // Range Minimum
                            0x004E,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x162E,             // Range Minimum
                            0x162E,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x164E,             // Range Minimum
                            0x164E,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0061,             // Range Minimum
                            0x0061,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0092,             // Range Minimum
                            0x0092,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x00B2,             // Range Minimum
                            0x00B2,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0063,             // Range Minimum
                            0x0063,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0065,             // Range Minimum
                            0x0065,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0067,             // Range Minimum
                            0x0067,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0600,             // Range Minimum
                            0x0600,             // Range Maximum
                            0x01,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0610,             // Range Minimum
                            0x0610,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0800,             // Range Minimum
                            0x0800,             // Range Maximum
                            0x01,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0400,             // Range Minimum
                            0x0400,             // Range Maximum
                            0x01,               // Alignment
                            0x80,               // Length
                            )
                        IO (Decode16,
                            0x0500,             // Range Minimum
                            0x0500,             // Range Maximum
                            0x01,               // Alignment
                            0x40,               // Length
                            )
                        IO (Decode16,
                            0x0200,             // Range Minimum
                            0x0200,             // Range Maximum
                            0x01,               // Alignment
                            0x10,               // Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xE0000000,         // Address Base
                            0x10000000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED1C000,         // Address Base
                            0x00004000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED14000,         // Address Base
                            0x00004000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED18000,         // Address Base
                            0x00001000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED19000,         // Address Base
                            0x00001000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED30000,         // Address Base
                            0x00001000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFEC00000,         // Address Base
                            0x00001000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFEE00000,         // Address Base
                            0x00001000,         // Address Length
                            )
                    })
                }

                Device (DMAC)
                {
                    Name (_HID, EisaId ("PNP0200") /* PC-class DMA Controller */)  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x01,               // Alignment
                            0x20,               // Length
                            )
                        IO (Decode16,
                            0x0081,             // Range Minimum
                            0x0081,             // Range Maximum
                            0x01,               // Alignment
                            0x11,               // Length
                            )
                        IO (Decode16,
                            0x0093,             // Range Minimum
                            0x0093,             // Range Maximum
                            0x01,               // Alignment
                            0x0D,               // Length
                            )
                        IO (Decode16,
                            0x00C0,             // Range Minimum
                            0x00C0,             // Range Maximum
                            0x01,               // Alignment
                            0x20,               // Length
                            )
                        DMA (Compatibility, NotBusMaster, Transfer8_16, )
                            {4}
                    })
                }

                Device (RTC)
                {
                    Name (_HID, EisaId ("PNP0B00") /* AT Real-Time Clock */)  // _HID: Hardware ID
                    Name (BUF0, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                    })
                    Name (BUF1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x01,               // Alignment
                            0x08,               // Length
                            )
                        IRQNoFlags ()
                            {8}
                    })
                    Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                    {
                        If ((HPTS == One))
                        {
                            Return (BUF0) /* \_SB_.PCI0.LPC_.RTC_.BUF0 */
                        }
                        Else
                        {
                            Return (BUF1) /* \_SB_.PCI0.LPC_.RTC_.BUF1 */
                        }
                    }
                }

                Device (HPET)
                {
                    Name (_HID, EisaId ("PNP0103") /* HPET System Timer */)  // _HID: Hardware ID
                    Name (BUF0, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {0}
                        IRQNoFlags ()
                            {8}
                        Memory32Fixed (ReadOnly,
                            0xFED00000,         // Address Base
                            0x00000400,         // Address Length
                            _Y0E)
                    })
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If ((OSYS >= 0x07D1))
                        {
                            If ((HPTS == One))
                            {
                                Return (0x0F)
                            }
                            Else
                            {
                                Return (Zero)
                            }
                        }
                        Else
                        {
                            If (HPTS)
                            {
                                Return (0x0B)
                            }
                            Else
                            {
                                Return (Zero)
                            }
                        }
                    }

                    Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                    {
                        If ((HPTS == One))
                        {
                            CreateDWordField (BUF0, \_SB.PCI0.LPC.HPET._Y0E._BAS, HPT0)  // _BAS: Base Address
                            If ((HPTA == One))
                            {
                                HPT0 = 0xFED01000
                            }

                            If ((HPTA == 0x02))
                            {
                                HPT0 = 0xFED02000
                            }

                            If ((HPTA == 0x03))
                            {
                                HPT0 = 0xFED03000
                            }
                        }

                        Return (BUF0) /* \_SB_.PCI0.LPC_.HPET.BUF0 */
                    }
                }

                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000") /* 8259-compatible Programmable Interrupt Controller */)  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0020,             // Range Minimum
                            0x0020,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0024,             // Range Minimum
                            0x0024,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0028,             // Range Minimum
                            0x0028,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x002C,             // Range Minimum
                            0x002C,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0030,             // Range Minimum
                            0x0030,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0034,             // Range Minimum
                            0x0034,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0038,             // Range Minimum
                            0x0038,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x003C,             // Range Minimum
                            0x003C,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A0,             // Range Minimum
                            0x00A0,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A4,             // Range Minimum
                            0x00A4,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A8,             // Range Minimum
                            0x00A8,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00AC,             // Range Minimum
                            0x00AC,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00B0,             // Range Minimum
                            0x00B0,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00B4,             // Range Minimum
                            0x00B4,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00B8,             // Range Minimum
                            0x00B8,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00BC,             // Range Minimum
                            0x00BC,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {2}
                    })
                }

                Device (FPU)
                {
                    Name (_HID, EisaId ("PNP0C04") /* x87-compatible Floating Point Processing Unit */)  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x00F0,             // Range Minimum
                            0x00F0,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {13}
                    })
                }

                Device (TIMR)
                {
                    Name (_HID, EisaId ("PNP0100") /* PC-class System Timer */)  // _HID: Hardware ID
                    Name (BUF0, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IO (Decode16,
                            0x0050,             // Range Minimum
                            0x0050,             // Range Maximum
                            0x10,               // Alignment
                            0x04,               // Length
                            )
                    })
                    Name (BUF1, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x01,               // Alignment
                            0x04,               // Length
                            )
                        IO (Decode16,
                            0x0050,             // Range Minimum
                            0x0050,             // Range Maximum
                            0x10,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {0}
                    })
                    Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                    {
                        If (HPTS)
                        {
                            Return (BUF0) /* \_SB_.PCI0.LPC_.TIMR.BUF0 */
                        }

                        Return (BUF1) /* \_SB_.PCI0.LPC_.TIMR.BUF1 */
                    }
                }

                Device (FWHD)
                {
                    Name (_HID, EisaId ("INT0800") /* Intel 82802 Firmware Hub Device */)  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        Memory32Fixed (ReadOnly,
                            0xFF800000,         // Address Base
                            0x00800000,         // Address Length
                            )
                    })
                }

                Device (SIO)
                {
                    Name (_HID, EisaId ("PNP0A05") /* Generic Container Device */)  // _HID: Hardware ID
                    Name (_UID, 0x02)  // _UID: Unique ID
                    Method (_STA, 0, Serialized)  // _STA: Status
                    {
                        Return (0x0F)
                    }

                    OperationRegion (N392, SystemIO, 0x2E, 0x02)
                    Field (N392, ByteAcc, Lock, Preserve)
                    {
                        AINX,   8, 
                        ADTA,   8
                    }

                    IndexField (AINX, ADTA, ByteAcc, Lock, Preserve)
                    {
                        Offset (0x07), 
                        X07H,   8, 
                        Offset (0x20), 
                        X20H,   8, 
                        X21H,   8, 
                        X22H,   8, 
                        X23H,   8, 
                        X24H,   8, 
                        X25H,   8, 
                        X26H,   8, 
                        X27H,   8, 
                        X28H,   8, 
                        X29H,   8, 
                        X2AH,   8, 
                        Offset (0x30), 
                        X30H,   8, 
                        Offset (0x60), 
                        X60H,   8, 
                        X61H,   8, 
                        Offset (0x70), 
                        X70H,   8, 
                        X71H,   8, 
                        Offset (0x74), 
                        X74H,   8, 
                        X75H,   8, 
                        Offset (0xF0), 
                        XF0H,   8, 
                        XF1H,   8
                    }

                    OperationRegion (DSIO, SystemIO, 0x4E, 0x02)
                    Field (DSIO, ByteAcc, Lock, Preserve)
                    {
                        BINX,   8, 
                        BDTA,   8
                    }

                    IndexField (BINX, BDTA, ByteAcc, Lock, Preserve)
                    {
                        Offset (0x07), 
                        Z07H,   8, 
                        Offset (0x20), 
                        Z20H,   8, 
                        Z21H,   8, 
                        Z22H,   8, 
                        Z23H,   8, 
                        Z24H,   8, 
                        Z25H,   8, 
                        Z26H,   8, 
                        Z27H,   8, 
                        Z28H,   8, 
                        Z29H,   8, 
                        Z2AH,   8, 
                        Offset (0x30), 
                        Z30H,   8, 
                        Offset (0x60), 
                        Z60H,   8, 
                        Z61H,   8, 
                        Offset (0x70), 
                        Z70H,   8, 
                        Z71H,   8, 
                        Offset (0x74), 
                        Z74H,   8, 
                        Z75H,   8, 
                        Offset (0xF0), 
                        ZF0H,   8, 
                        ZF1H,   8
                    }

                    OperationRegion (N382, SystemIO, 0x164E, 0x02)
                    Field (N382, ByteAcc, Lock, Preserve)
                    {
                        INDX,   8, 
                        DATA,   8
                    }

                    IndexField (INDX, DATA, ByteAcc, Lock, Preserve)
                    {
                        Offset (0x07), 
                        R07H,   8, 
                        Offset (0x20), 
                        R20H,   8, 
                        R21H,   8, 
                        R22H,   8, 
                        R23H,   8, 
                        R24H,   8, 
                        R25H,   8, 
                        R26H,   8, 
                        R27H,   8, 
                        R28H,   8, 
                        R29H,   8, 
                        R2AH,   8, 
                        Offset (0x30), 
                        R30H,   8, 
                        Offset (0x60), 
                        R60H,   8, 
                        R61H,   8, 
                        Offset (0x70), 
                        R70H,   8, 
                        R71H,   8, 
                        Offset (0x74), 
                        R74H,   8, 
                        R75H,   8, 
                        Offset (0xF0), 
                        RF0H,   8, 
                        RF1H,   8
                    }

                    Device (UAR1)
                    {
                        Name (_HID, EisaId ("PNP0501") /* 16550A-compatible COM Serial Port */)  // _HID: Hardware ID
                        Name (_UID, One)  // _UID: Unique ID
                        Name (_EJD, "DOCK")  // _EJD: Ejection Dependent Device
                        Method (_STA, 0, Serialized)  // _STA: Status
                        {
                            If (COMA)
                            {
                                If (NATP)
                                {
                                    If (NDFL)
                                    {
                                        R07H = 0x03
                                        If (R30H)
                                        {
                                            Return (0x0F)
                                        }

                                        Return (0x0D)
                                    }
                                    Else
                                    {
                                        Z07H = 0x03
                                        If (Z30H)
                                        {
                                            Return (0x0F)
                                        }

                                        Return (0x0D)
                                    }
                                }
                                Else
                                {
                                    R07H = 0x03
                                    If (R30H)
                                    {
                                        Return (0x0F)
                                    }

                                    Return (0x0D)
                                }
                            }

                            Return (Zero)
                        }

                        Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                        {
                            If (NATP)
                            {
                                If (NDFL)
                                {
                                    R07H = 0x03
                                    R30H = Zero
                                }
                                Else
                                {
                                    Z07H = 0x03
                                    Z30H = Zero
                                }
                            }
                            Else
                            {
                                R07H = 0x03
                                R30H = Zero
                            }
                        }

                        Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x03E8,             // Range Minimum
                                    0x03E8,             // Range Maximum
                                    0x01,               // Alignment
                                    0x08,               // Length
                                    _Y0F)
                                IRQNoFlags (_Y10)
                                    {4}
                            })
                            If (COMA)
                            {
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.UAR1._CRS._Y0F._MIN, IOL0)  // _MIN: Minimum Base Address
                                CreateByteField (BUF0, 0x03, IOH0)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.UAR1._CRS._Y0F._MAX, IOL1)  // _MAX: Maximum Base Address
                                CreateByteField (BUF0, 0x05, IOH1)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.UAR1._CRS._Y0F._LEN, LEN0)  // _LEN: Length
                                CreateWordField (BUF0, \_SB.PCI0.LPC.SIO.UAR1._CRS._Y10._INT, IRQW)  // _INT: Interrupts
                                If (NATP)
                                {
                                    If (NDFL)
                                    {
                                        R07H = 0x03
                                        IOH0 = R60H /* \_SB_.PCI0.LPC_.SIO_.R60H */
                                        IOL0 = R61H /* \_SB_.PCI0.LPC_.SIO_.R61H */
                                        IOH1 = R60H /* \_SB_.PCI0.LPC_.SIO_.R60H */
                                        IOL1 = R61H /* \_SB_.PCI0.LPC_.SIO_.R61H */
                                        LEN0 = 0x08
                                        Local0 = (R70H & 0x0F)
                                        If (Local0)
                                        {
                                            IRQW = (One << Local0)
                                        }
                                        Else
                                        {
                                            IRQW = Zero
                                        }
                                    }
                                    Else
                                    {
                                        Z07H = 0x03
                                        IOH0 = Z60H /* \_SB_.PCI0.LPC_.SIO_.Z60H */
                                        IOL0 = Z61H /* \_SB_.PCI0.LPC_.SIO_.Z61H */
                                        IOH1 = Z60H /* \_SB_.PCI0.LPC_.SIO_.Z60H */
                                        IOL1 = Z61H /* \_SB_.PCI0.LPC_.SIO_.Z61H */
                                        LEN0 = 0x08
                                        Local0 = (Z70H & 0x0F)
                                        If (Local0)
                                        {
                                            IRQW = (One << Local0)
                                        }
                                        Else
                                        {
                                            IRQW = Zero
                                        }
                                    }
                                }
                                Else
                                {
                                    R07H = 0x03
                                    IOH0 = R60H /* \_SB_.PCI0.LPC_.SIO_.R60H */
                                    IOL0 = R61H /* \_SB_.PCI0.LPC_.SIO_.R61H */
                                    IOH1 = R60H /* \_SB_.PCI0.LPC_.SIO_.R60H */
                                    IOL1 = R61H /* \_SB_.PCI0.LPC_.SIO_.R61H */
                                    LEN0 = 0x08
                                    Local0 = (R70H & 0x0F)
                                    If (Local0)
                                    {
                                        IRQW = (One << Local0)
                                    }
                                    Else
                                    {
                                        IRQW = Zero
                                    }
                                }
                            }

                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.UAR1._CRS.BUF0 */
                        }

                        Method (_PRS, 0, Serialized)  // _PRS: Possible Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x03E8,             // Range Minimum
                                        0x03E8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x02E8,             // Range Minimum
                                        0x02E8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x03F8,             // Range Minimum
                                        0x03F8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x02F8,             // Range Minimum
                                        0x02F8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x03E8,             // Range Minimum
                                        0x03E8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x02E8,             // Range Minimum
                                        0x02E8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x03F8,             // Range Minimum
                                        0x03F8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x02F8,             // Range Minimum
                                        0x02F8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                EndDependentFn ()
                            })
                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.UAR1._PRS.BUF0 */
                        }

                        Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                        {
                            CreateByteField (Arg0, 0x02, IOLO)
                            CreateByteField (Arg0, 0x03, IOHI)
                            CreateWordField (Arg0, 0x09, IRQW)
                            If (NATP)
                            {
                                If (NDFL)
                                {
                                    R07H = 0x03
                                    R30H = Zero
                                    R61H = IOLO /* \_SB_.PCI0.LPC_.SIO_.UAR1._SRS.IOLO */
                                    R60H = IOHI /* \_SB_.PCI0.LPC_.SIO_.UAR1._SRS.IOHI */
                                    FindSetRightBit (IRQW, Local0)
                                    If ((IRQW != Zero))
                                    {
                                        Local0--
                                    }

                                    R70H = Local0
                                    IODL &= 0xF8
                                    If ((IOHI == 0x03))
                                    {
                                        If ((IOLO == 0xF8))
                                        {
                                            IODL |= Zero
                                        }
                                        Else
                                        {
                                            IODL |= 0x07
                                        }
                                    }
                                    Else
                                    {
                                        If ((IOLO == 0xF8))
                                        {
                                            IODL |= One
                                        }
                                        Else
                                        {
                                            IODL |= 0x05
                                        }
                                    }

                                    R30H = One
                                }
                                Else
                                {
                                    Z07H = 0x03
                                    Z30H = Zero
                                    Z61H = IOLO /* \_SB_.PCI0.LPC_.SIO_.UAR1._SRS.IOLO */
                                    Z60H = IOHI /* \_SB_.PCI0.LPC_.SIO_.UAR1._SRS.IOHI */
                                    FindSetRightBit (IRQW, Local0)
                                    If ((IRQW != Zero))
                                    {
                                        Local0--
                                    }

                                    Z70H = Local0
                                    IODL &= 0xF8
                                    If ((IOHI == 0x03))
                                    {
                                        If ((IOLO == 0xF8))
                                        {
                                            IODL |= Zero
                                        }
                                        Else
                                        {
                                            IODL |= 0x07
                                        }
                                    }
                                    Else
                                    {
                                        If ((IOLO == 0xF8))
                                        {
                                            IODL |= One
                                        }
                                        Else
                                        {
                                            IODL |= 0x05
                                        }
                                    }

                                    Z30H = One
                                }
                            }
                            Else
                            {
                                R07H = 0x03
                                R30H = Zero
                                R61H = IOLO /* \_SB_.PCI0.LPC_.SIO_.UAR1._SRS.IOLO */
                                R60H = IOHI /* \_SB_.PCI0.LPC_.SIO_.UAR1._SRS.IOHI */
                                FindSetRightBit (IRQW, Local0)
                                If ((IRQW != Zero))
                                {
                                    Local0--
                                }

                                R70H = Local0
                                IODL &= 0xF8
                                If ((IOHI == 0x03))
                                {
                                    If ((IOLO == 0xF8))
                                    {
                                        IODL |= Zero
                                    }
                                    Else
                                    {
                                        IODL |= 0x07
                                    }
                                }
                                Else
                                {
                                    If ((IOLO == 0xF8))
                                    {
                                        IODL |= One
                                    }
                                    Else
                                    {
                                        IODL |= 0x05
                                    }
                                }

                                R30H = One
                            }
                        }

                        Method (_PS0, 0, Serialized)  // _PS0: Power State 0
                        {
                            If (NATP)
                            {
                                If (NDFL)
                                {
                                    R07H = 0x03
                                    R30H = One
                                }
                                Else
                                {
                                    Z07H = 0x03
                                    Z30H = One
                                }
                            }
                            Else
                            {
                                R07H = 0x03
                                R30H = One
                            }
                        }

                        Method (_PS3, 0, Serialized)  // _PS3: Power State 3
                        {
                            If (NATP)
                            {
                                If (NDFL)
                                {
                                    R07H = 0x03
                                    R30H = Zero
                                }
                                Else
                                {
                                    Z07H = 0x03
                                    Z30H = Zero
                                }
                            }
                            Else
                            {
                                R07H = 0x03
                                R30H = Zero
                            }
                        }

                        Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                        {
                            Return (Package (0x02)
                            {
                                0x08, 
                                0x03
                            })
                        }
                    }

                    Device (UAR2)
                    {
                        Name (_HID, EisaId ("PNP0501") /* 16550A-compatible COM Serial Port */)  // _HID: Hardware ID
                        Name (_UID, 0x02)  // _UID: Unique ID
                        Method (_STA, 0, Serialized)  // _STA: Status
                        {
                            X07H = 0x03
                            If (X30H)
                            {
                                Return (0x0F)
                            }

                            Return (0x0D)
                        }

                        Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                        {
                            X07H = 0x03
                            X30H = Zero
                        }

                        Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x06F0,             // Range Minimum
                                    0x06F0,             // Range Maximum
                                    0x01,               // Alignment
                                    0x08,               // Length
                                    _Y11)
                                IRQNoFlags (_Y12)
                                    {6}
                            })
                            X07H = 0x03
                            CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.UAR2._CRS._Y11._MIN, IOL0)  // _MIN: Minimum Base Address
                            CreateByteField (BUF0, 0x03, IOH0)
                            CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.UAR2._CRS._Y11._MAX, IOL1)  // _MAX: Maximum Base Address
                            CreateByteField (BUF0, 0x05, IOH1)
                            CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.UAR2._CRS._Y11._LEN, LEN0)  // _LEN: Length
                            CreateWordField (BUF0, \_SB.PCI0.LPC.SIO.UAR2._CRS._Y12._INT, IRQW)  // _INT: Interrupts
                            IOH0 = X60H /* \_SB_.PCI0.LPC_.SIO_.X60H */
                            IOL0 = X61H /* \_SB_.PCI0.LPC_.SIO_.X61H */
                            IOH1 = X60H /* \_SB_.PCI0.LPC_.SIO_.X60H */
                            IOL1 = X61H /* \_SB_.PCI0.LPC_.SIO_.X61H */
                            LEN0 = 0x08
                            Local0 = (X70H & 0x0F)
                            If (Local0)
                            {
                                IRQW = (One << Local0)
                            }
                            Else
                            {
                                IRQW = Zero
                            }

                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.UAR2._CRS.BUF0 */
                        }

                        Method (_PRS, 0, Serialized)  // _PRS: Possible Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x06F0,             // Range Minimum
                                        0x06F0,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {6}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x06F0,             // Range Minimum
                                        0x06F0,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x06F0,             // Range Minimum
                                        0x06F0,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                EndDependentFn ()
                            })
                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.UAR2._PRS.BUF0 */
                        }

                        Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                        {
                            CreateByteField (Arg0, 0x02, IOLO)
                            CreateByteField (Arg0, 0x03, IOHI)
                            CreateWordField (Arg0, 0x09, IRQW)
                            X07H = 0x03
                            X30H = Zero
                            X61H = IOLO /* \_SB_.PCI0.LPC_.SIO_.UAR2._SRS.IOLO */
                            X60H = IOHI /* \_SB_.PCI0.LPC_.SIO_.UAR2._SRS.IOHI */
                            FindSetRightBit (IRQW, Local0)
                            If ((IRQW != Zero))
                            {
                                Local0--
                            }

                            X70H = Local0
                            X30H = One
                        }

                        Method (_PS0, 0, Serialized)  // _PS0: Power State 0
                        {
                            X07H = 0x03
                            X30H = One
                        }

                        Method (_PS3, 0, Serialized)  // _PS3: Power State 3
                        {
                            X07H = 0x03
                            X30H = Zero
                        }
                    }

                    Device (UAR3)
                    {
                        Name (_HID, EisaId ("PNP0501") /* 16550A-compatible COM Serial Port */)  // _HID: Hardware ID
                        Name (_UID, 0x03)  // _UID: Unique ID
                        Method (_STA, 0, Serialized)  // _STA: Status
                        {
                            X07H = 0x02
                            If (X30H)
                            {
                                Return (0x0F)
                            }

                            Return (0x0D)
                        }

                        Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                        {
                            X07H = 0x02
                            X30H = Zero
                        }

                        Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x06F8,             // Range Minimum
                                    0x06F8,             // Range Maximum
                                    0x01,               // Alignment
                                    0x08,               // Length
                                    _Y13)
                                IRQNoFlags (_Y14)
                                    {5}
                            })
                            X07H = 0x02
                            CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.UAR3._CRS._Y13._MIN, IOL0)  // _MIN: Minimum Base Address
                            CreateByteField (BUF0, 0x03, IOH0)
                            CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.UAR3._CRS._Y13._MAX, IOL1)  // _MAX: Maximum Base Address
                            CreateByteField (BUF0, 0x05, IOH1)
                            CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.UAR3._CRS._Y13._LEN, LEN0)  // _LEN: Length
                            CreateWordField (BUF0, \_SB.PCI0.LPC.SIO.UAR3._CRS._Y14._INT, IRQW)  // _INT: Interrupts
                            IOH0 = X60H /* \_SB_.PCI0.LPC_.SIO_.X60H */
                            IOL0 = X61H /* \_SB_.PCI0.LPC_.SIO_.X61H */
                            IOH1 = X60H /* \_SB_.PCI0.LPC_.SIO_.X60H */
                            IOL1 = X61H /* \_SB_.PCI0.LPC_.SIO_.X61H */
                            LEN0 = 0x08
                            Local0 = (X70H & 0x0F)
                            If (Local0)
                            {
                                IRQW = (One << Local0)
                            }
                            Else
                            {
                                IRQW = Zero
                            }

                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.UAR3._CRS.BUF0 */
                        }

                        Method (_PRS, 0, Serialized)  // _PRS: Possible Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x06F8,             // Range Minimum
                                        0x06F8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x06F8,             // Range Minimum
                                        0x06F8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x06F8,             // Range Minimum
                                        0x06F8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {6}
                                }
                                EndDependentFn ()
                            })
                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.UAR3._PRS.BUF0 */
                        }

                        Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                        {
                            CreateByteField (Arg0, 0x02, IOLO)
                            CreateByteField (Arg0, 0x03, IOHI)
                            CreateWordField (Arg0, 0x09, IRQW)
                            X07H = 0x02
                            X30H = Zero
                            X61H = IOLO /* \_SB_.PCI0.LPC_.SIO_.UAR3._SRS.IOLO */
                            X60H = IOHI /* \_SB_.PCI0.LPC_.SIO_.UAR3._SRS.IOHI */
                            FindSetRightBit (IRQW, Local0)
                            If ((IRQW != Zero))
                            {
                                Local0--
                            }

                            X70H = Local0
                            X30H = One
                        }

                        Method (_PS0, 0, Serialized)  // _PS0: Power State 0
                        {
                            X07H = 0x02
                            X30H = One
                        }

                        Method (_PS3, 0, Serialized)  // _PS3: Power State 3
                        {
                            X07H = 0x02
                            X30H = Zero
                        }
                    }

                    Device (UAR4)
                    {
                        Name (_HID, EisaId ("PNP0501") /* 16550A-compatible COM Serial Port */)  // _HID: Hardware ID
                        Name (_UID, 0x04)  // _UID: Unique ID
                        Name (_EJD, "DOCK")  // _EJD: Ejection Dependent Device
                        Method (_STA, 0, Serialized)  // _STA: Status
                        {
                            If (((NATP && COMB) && DCKT))
                            {
                                Z07H = 0x02
                                If (Z30H)
                                {
                                    Return (0x0F)
                                }

                                Return (0x0D)
                            }

                            Return (Zero)
                        }

                        Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                        {
                            Z07H = 0x02
                            Z30H = Zero
                        }

                        Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x02E8,             // Range Minimum
                                    0x02E8,             // Range Maximum
                                    0x01,               // Alignment
                                    0x08,               // Length
                                    _Y15)
                                IRQNoFlags (_Y16)
                                    {3}
                            })
                            Z07H = 0x02
                            If (((NATP && COMB) && DCKT))
                            {
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.UAR4._CRS._Y15._MIN, IOL0)  // _MIN: Minimum Base Address
                                CreateByteField (BUF0, 0x03, IOH0)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.UAR4._CRS._Y15._MAX, IOL1)  // _MAX: Maximum Base Address
                                CreateByteField (BUF0, 0x05, IOH1)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.UAR4._CRS._Y15._LEN, LEN0)  // _LEN: Length
                                CreateWordField (BUF0, \_SB.PCI0.LPC.SIO.UAR4._CRS._Y16._INT, IRQW)  // _INT: Interrupts
                                IOH0 = Z60H /* \_SB_.PCI0.LPC_.SIO_.Z60H */
                                IOL0 = Z61H /* \_SB_.PCI0.LPC_.SIO_.Z61H */
                                IOH1 = Z60H /* \_SB_.PCI0.LPC_.SIO_.Z60H */
                                IOL1 = Z61H /* \_SB_.PCI0.LPC_.SIO_.Z61H */
                                LEN0 = 0x08
                                Local0 = (Z70H & 0x0F)
                                If (Local0)
                                {
                                    IRQW = (One << Local0)
                                }
                                Else
                                {
                                    IRQW = Zero
                                }
                            }

                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.UAR4._CRS.BUF0 */
                        }

                        Method (_PRS, 0, Serialized)  // _PRS: Possible Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x02E8,             // Range Minimum
                                        0x02E8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x03E8,             // Range Minimum
                                        0x03E8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x02F8,             // Range Minimum
                                        0x02F8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x03F8,             // Range Minimum
                                        0x03F8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x02E8,             // Range Minimum
                                        0x02E8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x03E8,             // Range Minimum
                                        0x03E8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x02F8,             // Range Minimum
                                        0x02F8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {4}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x03F8,             // Range Minimum
                                        0x03F8,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {3}
                                }
                                EndDependentFn ()
                            })
                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.UAR4._PRS.BUF0 */
                        }

                        Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                        {
                            CreateByteField (Arg0, 0x02, IOLO)
                            CreateByteField (Arg0, 0x03, IOHI)
                            CreateWordField (Arg0, 0x09, IRQW)
                            Z07H = 0x02
                            Z30H = Zero
                            Z61H = IOLO /* \_SB_.PCI0.LPC_.SIO_.UAR4._SRS.IOLO */
                            Z60H = IOHI /* \_SB_.PCI0.LPC_.SIO_.UAR4._SRS.IOHI */
                            FindSetRightBit (IRQW, Local0)
                            If ((IRQW != Zero))
                            {
                                Local0--
                            }

                            Z70H = Local0
                            IOD0 &= 0x8F
                            If ((IOHI == 0x03))
                            {
                                If ((IOLO == 0xF8))
                                {
                                    IOD0 |= Zero
                                }
                                Else
                                {
                                    IOD0 |= 0x70
                                }
                            }
                            Else
                            {
                                If ((IOLO == 0xF8))
                                {
                                    IOD0 |= 0x10
                                }
                                Else
                                {
                                    IOD0 |= 0x50
                                }
                            }

                            Z30H = One
                        }

                        Method (_PS0, 0, Serialized)  // _PS0: Power State 0
                        {
                            Z07H = 0x02
                            Z30H = One
                        }

                        Method (_PS3, 0, Serialized)  // _PS3: Power State 3
                        {
                            Z07H = 0x02
                            Z30H = Zero
                        }
                    }

                    Device (POUT)
                    {
                        Name (_HID, EisaId ("PNP0400") /* Standard LPT Parallel Port */)  // _HID: Hardware ID
                        Name (_UID, One)  // _UID: Unique ID
                        Name (_EJD, "DOCK")  // _EJD: Ejection Dependent Device
                        Method (_STA, 0, Serialized)  // _STA: Status
                        {
                            Z07H = One
                            If (((ZF0H & 0xE0) == Zero))
                            {
                                If ((NATP && LPT1))
                                {
                                    If (Z30H)
                                    {
                                        Return (0x0F)
                                    }

                                    Return (0x0D)
                                }
                            }

                            Return (Zero)
                        }

                        Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                        {
                            Z07H = One
                            If (((ZF0H & 0xE0) == Zero))
                            {
                                Z30H = Zero
                            }
                        }

                        Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x0378,             // Range Minimum
                                    0x0378,             // Range Maximum
                                    0x01,               // Alignment
                                    0x04,               // Length
                                    _Y17)
                                IRQNoFlags (_Y18)
                                    {7}
                            })
                            Z07H = One
                            If (((ZF0H & 0xE0) == Zero))
                            {
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.POUT._CRS._Y17._MIN, IOL0)  // _MIN: Minimum Base Address
                                CreateByteField (BUF0, 0x03, IOH0)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.POUT._CRS._Y17._MAX, IOL1)  // _MAX: Maximum Base Address
                                CreateByteField (BUF0, 0x05, IOH1)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.POUT._CRS._Y17._LEN, LEN0)  // _LEN: Length
                                CreateWordField (BUF0, \_SB.PCI0.LPC.SIO.POUT._CRS._Y18._INT, IRQW)  // _INT: Interrupts
                                IOL0 = Z61H /* \_SB_.PCI0.LPC_.SIO_.Z61H */
                                IOH0 = Z60H /* \_SB_.PCI0.LPC_.SIO_.Z60H */
                                IOL1 = IOL0 /* \_SB_.PCI0.LPC_.SIO_.POUT._CRS.IOL0 */
                                IOH1 = IOH0 /* \_SB_.PCI0.LPC_.SIO_.POUT._CRS.IOH0 */
                                LEN0 = 0x04
                                Local0 = (Z70H & 0x0F)
                                If (Local0)
                                {
                                    IRQW = (One << Local0)
                                }
                                Else
                                {
                                    IRQW = Zero
                                }
                            }

                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.POUT._CRS.BUF0 */
                        }

                        Method (_PRS, 0, Serialized)  // _PRS: Possible Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x01,               // Alignment
                                        0x04,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x01,               // Alignment
                                        0x04,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x03BC,             // Range Minimum
                                        0x03BC,             // Range Maximum
                                        0x01,               // Alignment
                                        0x04,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x01,               // Alignment
                                        0x04,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x01,               // Alignment
                                        0x04,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x03BC,             // Range Minimum
                                        0x03BC,             // Range Maximum
                                        0x01,               // Alignment
                                        0x04,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                EndDependentFn ()
                            })
                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.POUT._PRS.BUF0 */
                        }

                        Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                        {
                            CreateByteField (Arg0, 0x02, IOL0)
                            CreateByteField (Arg0, 0x03, IOH0)
                            CreateWordField (Arg0, 0x09, IRQW)
                            Z07H = One
                            Z30H = Zero
                            ZF0H = (RF0H & 0x0F)
                            Z74H = 0x04
                            Z61H = IOL0 /* \_SB_.PCI0.LPC_.SIO_.POUT._SRS.IOL0 */
                            Z60H = IOH0 /* \_SB_.PCI0.LPC_.SIO_.POUT._SRS.IOH0 */
                            FindSetRightBit (IRQW, Local0)
                            If ((IRQW != Zero))
                            {
                                Local0--
                            }

                            Z70H = Local0
                            IOD1 &= 0xFC
                            If ((IOH0 == 0x03))
                            {
                                If ((IOL0 == 0x78))
                                {
                                    IOD1 |= Zero
                                }
                                Else
                                {
                                    IOD1 |= 0x02
                                }
                            }
                            Else
                            {
                                IOD1 |= One
                            }

                            Z30H = One
                        }

                        Method (_PS0, 0, Serialized)  // _PS0: Power State 0
                        {
                            Z07H = One
                            Z30H = One
                        }

                        Method (_PS3, 0, Serialized)  // _PS3: Power State 3
                        {
                            Z07H = One
                            Z30H = Zero
                        }
                    }

                    Device (PBID)
                    {
                        Name (_HID, EisaId ("PNP0400") /* Standard LPT Parallel Port */)  // _HID: Hardware ID
                        Name (_UID, 0x02)  // _UID: Unique ID
                        Name (_EJD, "DOCK")  // _EJD: Ejection Dependent Device
                        Method (_STA, 0, Serialized)  // _STA: Status
                        {
                            Z07H = One
                            If (((ZF0H & 0xE0) == 0x20))
                            {
                                If ((NATP && LPT1))
                                {
                                    If (Z30H)
                                    {
                                        Return (0x0F)
                                    }

                                    Return (0x0D)
                                }
                            }

                            Return (Zero)
                        }

                        Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                        {
                            Z07H = One
                            If (((ZF0H & 0xE0) == 0x20))
                            {
                                Z30H = Zero
                            }
                        }

                        Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x0378,             // Range Minimum
                                    0x0378,             // Range Maximum
                                    0x01,               // Alignment
                                    0x04,               // Length
                                    _Y19)
                                IRQNoFlags (_Y1A)
                                    {7}
                            })
                            Z07H = One
                            If (((ZF0H & 0xE0) == 0x20))
                            {
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PBID._CRS._Y19._MIN, IOL0)  // _MIN: Minimum Base Address
                                CreateByteField (BUF0, 0x03, IOH0)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PBID._CRS._Y19._MAX, IOL1)  // _MAX: Maximum Base Address
                                CreateByteField (BUF0, 0x05, IOH1)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PBID._CRS._Y19._LEN, LEN0)  // _LEN: Length
                                CreateWordField (BUF0, \_SB.PCI0.LPC.SIO.PBID._CRS._Y1A._INT, IRQW)  // _INT: Interrupts
                                IOL0 = Z61H /* \_SB_.PCI0.LPC_.SIO_.Z61H */
                                IOH0 = Z60H /* \_SB_.PCI0.LPC_.SIO_.Z60H */
                                IOL1 = IOL0 /* \_SB_.PCI0.LPC_.SIO_.PBID._CRS.IOL0 */
                                IOH1 = IOH0 /* \_SB_.PCI0.LPC_.SIO_.PBID._CRS.IOH0 */
                                LEN0 = 0x04
                                Local0 = (Z70H & 0x0F)
                                If (Local0)
                                {
                                    IRQW = (One << Local0)
                                }
                                Else
                                {
                                    IRQW = Zero
                                }
                            }

                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.PBID._CRS.BUF0 */
                        }

                        Method (_PRS, 0, Serialized)  // _PRS: Possible Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x01,               // Alignment
                                        0x04,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x01,               // Alignment
                                        0x04,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x03BC,             // Range Minimum
                                        0x03BC,             // Range Maximum
                                        0x01,               // Alignment
                                        0x04,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x01,               // Alignment
                                        0x04,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x01,               // Alignment
                                        0x04,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x03BC,             // Range Minimum
                                        0x03BC,             // Range Maximum
                                        0x01,               // Alignment
                                        0x04,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                EndDependentFn ()
                            })
                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.PBID._PRS.BUF0 */
                        }

                        Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                        {
                            CreateByteField (Arg0, 0x02, IOL0)
                            CreateByteField (Arg0, 0x03, IOH0)
                            CreateWordField (Arg0, 0x09, IRQW)
                            Z07H = One
                            Z30H = Zero
                            ZF0H = ((ZF0H & 0x0F) | 0x20)
                            Z74H = 0x04
                            Z61H = IOL0 /* \_SB_.PCI0.LPC_.SIO_.PBID._SRS.IOL0 */
                            Z60H = IOH0 /* \_SB_.PCI0.LPC_.SIO_.PBID._SRS.IOH0 */
                            FindSetRightBit (IRQW, Local0)
                            If ((IRQW != Zero))
                            {
                                Local0--
                            }

                            Z70H = Local0
                            IOD1 &= 0xFC
                            If ((IOH0 == 0x03))
                            {
                                If ((IOL0 == 0x78))
                                {
                                    IOD1 |= Zero
                                }
                                Else
                                {
                                    IOD1 |= 0x02
                                }
                            }
                            Else
                            {
                                IOD1 |= One
                            }

                            Z30H = One
                        }

                        Method (_PS0, 0, Serialized)  // _PS0: Power State 0
                        {
                            Z07H = One
                            Z30H = One
                        }

                        Method (_PS3, 0, Serialized)  // _PS3: Power State 3
                        {
                            Z07H = One
                            Z30H = Zero
                        }
                    }

                    Device (PEPP)
                    {
                        Name (_HID, EisaId ("PNP0400") /* Standard LPT Parallel Port */)  // _HID: Hardware ID
                        Name (_UID, 0x03)  // _UID: Unique ID
                        Name (_EJD, "DOCK")  // _EJD: Ejection Dependent Device
                        Method (_STA, 0, Serialized)  // _STA: Status
                        {
                            Z07H = One
                            If (((ZF0H & 0xE0) == 0x60))
                            {
                                If ((NATP && LPT1))
                                {
                                    If (Z30H)
                                    {
                                        Return (0x0F)
                                    }
                                    Else
                                    {
                                        Return (0x0D)
                                    }
                                }
                            }

                            Return (Zero)
                        }

                        Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                        {
                            Z07H = One
                            If (((ZF0H & 0xE0) == 0x60))
                            {
                                Z30H = Zero
                            }
                        }

                        Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x0378,             // Range Minimum
                                    0x0378,             // Range Maximum
                                    0x01,               // Alignment
                                    0x08,               // Length
                                    _Y1B)
                                IRQNoFlags (_Y1C)
                                    {7}
                            })
                            Z07H = One
                            If (((ZF0H & 0xE0) == 0x60))
                            {
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PEPP._CRS._Y1B._MIN, IOL0)  // _MIN: Minimum Base Address
                                CreateByteField (BUF0, 0x03, IOH0)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PEPP._CRS._Y1B._MAX, IOL1)  // _MAX: Maximum Base Address
                                CreateByteField (BUF0, 0x05, IOH1)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PEPP._CRS._Y1B._LEN, LEN0)  // _LEN: Length
                                CreateWordField (BUF0, \_SB.PCI0.LPC.SIO.PEPP._CRS._Y1C._INT, IRQW)  // _INT: Interrupts
                                IOL0 = Z61H /* \_SB_.PCI0.LPC_.SIO_.Z61H */
                                IOH0 = Z60H /* \_SB_.PCI0.LPC_.SIO_.Z60H */
                                IOL1 = IOL0 /* \_SB_.PCI0.LPC_.SIO_.PEPP._CRS.IOL0 */
                                IOH1 = IOH0 /* \_SB_.PCI0.LPC_.SIO_.PEPP._CRS.IOH0 */
                                LEN0 = 0x08
                                Local0 = (Z70H & 0x0F)
                                If (Local0)
                                {
                                    IRQW = (One << Local0)
                                }
                                Else
                                {
                                    IRQW = Zero
                                }
                            }

                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.PEPP._CRS.BUF0 */
                        }

                        Method (_PRS, 0, Serialized)  // _PRS: Possible Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                }
                                EndDependentFn ()
                            })
                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.PEPP._PRS.BUF0 */
                        }

                        Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                        {
                            CreateByteField (Arg0, 0x02, IOL0)
                            CreateByteField (Arg0, 0x03, IOH0)
                            CreateWordField (Arg0, 0x09, IRQW)
                            Z07H = One
                            Z30H = Zero
                            ZF0H = ((ZF0H & 0x0F) | 0x60)
                            Z74H = 0x04
                            Z61H = IOL0 /* \_SB_.PCI0.LPC_.SIO_.PEPP._SRS.IOL0 */
                            Z60H = IOH0 /* \_SB_.PCI0.LPC_.SIO_.PEPP._SRS.IOH0 */
                            FindSetRightBit (IRQW, Local0)
                            If ((IRQW != Zero))
                            {
                                Local0--
                            }

                            Z70H = Local0
                            IOD1 &= 0xFC
                            If ((IOH0 == 0x03))
                            {
                                IOD1 |= Zero
                            }
                            Else
                            {
                                IOD1 |= One
                            }

                            Z30H = One
                        }

                        Method (_PS0, 0, Serialized)  // _PS0: Power State 0
                        {
                            Z07H = One
                            Z30H = One
                        }

                        Method (_PS3, 0, Serialized)  // _PS3: Power State 3
                        {
                            Z07H = One
                            Z30H = Zero
                        }
                    }

                    Device (PECP)
                    {
                        Name (_HID, EisaId ("PNP0401") /* ECP Parallel Port */)  // _HID: Hardware ID
                        Name (_UID, 0x04)  // _UID: Unique ID
                        Name (_EJD, "DOCK")  // _EJD: Ejection Dependent Device
                        Method (_STA, 0, Serialized)  // _STA: Status
                        {
                            Z07H = One
                            If (((ZF0H & 0xE0) == 0xE0))
                            {
                                If ((NATP && LPT1))
                                {
                                    If (Z30H)
                                    {
                                        Return (0x0F)
                                    }
                                    Else
                                    {
                                        Return (0x0D)
                                    }
                                }
                            }

                            Return (Zero)
                        }

                        Method (_DIS, 0, Serialized)  // _DIS: Disable Device
                        {
                            Z07H = One
                            If (((ZF0H & 0xE0) == 0xE0))
                            {
                                Z30H = Zero
                            }
                        }

                        Method (_CRS, 0, Serialized)  // _CRS: Current Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                IO (Decode16,
                                    0x0378,             // Range Minimum
                                    0x0378,             // Range Maximum
                                    0x01,               // Alignment
                                    0x08,               // Length
                                    _Y1D)
                                IO (Decode16,
                                    0x0778,             // Range Minimum
                                    0x0778,             // Range Maximum
                                    0x01,               // Alignment
                                    0x08,               // Length
                                    _Y1E)
                                IRQNoFlags (_Y1F)
                                    {7}
                                DMA (Compatibility, NotBusMaster, Transfer8_16, _Y20)
                                    {1}
                            })
                            Z07H = One
                            If (((ZF0H & 0xE0) == 0xE0))
                            {
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PECP._CRS._Y1D._MIN, IOL0)  // _MIN: Minimum Base Address
                                CreateByteField (BUF0, 0x03, IOH0)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PECP._CRS._Y1D._MAX, IOL1)  // _MAX: Maximum Base Address
                                CreateByteField (BUF0, 0x05, IOH1)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PECP._CRS._Y1D._LEN, LEN0)  // _LEN: Length
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PECP._CRS._Y1E._MIN, IOL2)  // _MIN: Minimum Base Address
                                CreateByteField (BUF0, 0x0B, IOH2)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PECP._CRS._Y1E._MAX, IOL3)  // _MAX: Maximum Base Address
                                CreateByteField (BUF0, 0x0D, IOH3)
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PECP._CRS._Y1E._LEN, LEN1)  // _LEN: Length
                                CreateWordField (BUF0, \_SB.PCI0.LPC.SIO.PECP._CRS._Y1F._INT, IRQW)  // _INT: Interrupts
                                CreateByteField (BUF0, \_SB.PCI0.LPC.SIO.PECP._CRS._Y20._DMA, DMA0)  // _DMA: Direct Memory Access
                                IOL0 = Z61H /* \_SB_.PCI0.LPC_.SIO_.Z61H */
                                IOH0 = Z60H /* \_SB_.PCI0.LPC_.SIO_.Z60H */
                                IOL1 = IOL0 /* \_SB_.PCI0.LPC_.SIO_.PECP._CRS.IOL0 */
                                IOH1 = IOH0 /* \_SB_.PCI0.LPC_.SIO_.PECP._CRS.IOH0 */
                                IOL2 = IOL0 /* \_SB_.PCI0.LPC_.SIO_.PECP._CRS.IOL0 */
                                IOH2 = (0x04 + IOH0)
                                IOL3 = IOL0 /* \_SB_.PCI0.LPC_.SIO_.PECP._CRS.IOL0 */
                                IOH3 = (0x04 + IOH0)
                                LEN0 = 0x08
                                LEN1 = 0x08
                                Local0 = (Z70H & 0x0F)
                                If (Local0)
                                {
                                    IRQW = (One << Local0)
                                }
                                Else
                                {
                                    IRQW = Zero
                                }

                                Local0 = Z74H /* \_SB_.PCI0.LPC_.SIO_.Z74H */
                                If ((Local0 == 0x04))
                                {
                                    DMA0 = Zero
                                }
                                Else
                                {
                                    DMA0 = (One << Local0)
                                }
                            }

                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.PECP._CRS.BUF0 */
                        }

                        Method (_PRS, 0, Serialized)  // _PRS: Possible Resource Settings
                        {
                            Name (BUF0, ResourceTemplate ()
                            {
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0778,             // Range Minimum
                                        0x0778,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                    DMA (Compatibility, NotBusMaster, Transfer8_16, )
                                        {3}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0678,             // Range Minimum
                                        0x0678,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                    DMA (Compatibility, NotBusMaster, Transfer8_16, )
                                        {3}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0778,             // Range Minimum
                                        0x0778,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                    DMA (Compatibility, NotBusMaster, Transfer8_16, )
                                        {3}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0678,             // Range Minimum
                                        0x0678,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                    DMA (Compatibility, NotBusMaster, Transfer8_16, )
                                        {3}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0778,             // Range Minimum
                                        0x0778,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                    DMA (Compatibility, NotBusMaster, Transfer8_16, )
                                        {1}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0678,             // Range Minimum
                                        0x0678,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {7}
                                    DMA (Compatibility, NotBusMaster, Transfer8_16, )
                                        {1}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0378,             // Range Minimum
                                        0x0378,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0778,             // Range Minimum
                                        0x0778,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                    DMA (Compatibility, NotBusMaster, Transfer8_16, )
                                        {1}
                                }
                                StartDependentFn (0x00, 0x02)
                                {
                                    IO (Decode16,
                                        0x0278,             // Range Minimum
                                        0x0278,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IO (Decode16,
                                        0x0678,             // Range Minimum
                                        0x0678,             // Range Maximum
                                        0x01,               // Alignment
                                        0x08,               // Length
                                        )
                                    IRQNoFlags ()
                                        {5}
                                    DMA (Compatibility, NotBusMaster, Transfer8_16, )
                                        {1}
                                }
                                EndDependentFn ()
                            })
                            Return (BUF0) /* \_SB_.PCI0.LPC_.SIO_.PECP._PRS.BUF0 */
                        }

                        Method (_SRS, 1, Serialized)  // _SRS: Set Resource Settings
                        {
                            CreateByteField (Arg0, 0x02, IOL0)
                            CreateByteField (Arg0, 0x03, IOH0)
                            CreateWordField (Arg0, 0x11, IRQW)
                            CreateByteField (Arg0, 0x14, DMA0)
                            Z07H = One
                            Z30H = Zero
                            RF0H = (ZF0H | 0xF0)
                            Z61H = IOL0 /* \_SB_.PCI0.LPC_.SIO_.PECP._SRS.IOL0 */
                            Z60H = IOH0 /* \_SB_.PCI0.LPC_.SIO_.PECP._SRS.IOH0 */
                            FindSetRightBit (IRQW, Local0)
                            If ((IRQW != Zero))
                            {
                                Local0--
                            }

                            Z70H = Local0
                            FindSetRightBit (DMA0, Local0)
                            If ((DMA0 != Zero))
                            {
                                Local0--
                            }

                            Z74H = Local0
                            IOD1 &= 0xFC
                            If ((IOH0 == 0x03))
                            {
                                IOD1 |= Zero
                            }
                            Else
                            {
                                IOD1 |= One
                            }

                            Z30H = One
                        }

                        Method (_PS0, 0, Serialized)  // _PS0: Power State 0
                        {
                            Z07H = One
                            Z30H = One
                        }

                        Method (_PS3, 0, Serialized)  // _PS3: Power State 3
                        {
                            Z07H = One
                            Z30H = Zero
                        }
                    }
                }

                Device (EC0)
                {
                    Name (_HID, EisaId ("PNP0C09") /* Embedded Controller Device */)  // _HID: Hardware ID
                    Name (_GPE, 0x17)  // _GPE: General Purpose Events
                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        Return (0x0F)
                    }

                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0062,             // Range Minimum
                            0x0062,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0066,             // Range Minimum
                            0x0066,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                    })
                    OperationRegion (RAM, EmbeddedControl, Zero, 0xFF)
                    Field (RAM, ByteAcc, Lock, Preserve)
                    {
                        Offset (0x30), 
                            ,   1, 
                        KBDC,   1, 
                        KBSC,   1, 
                        Offset (0x50), 
                            ,   2, 
                        KADF,   1, 
                            ,   4, 
                        KPHC,   1, 
                        Offset (0x52), 
                        KBMA,   8, 
                        KBMD,   8, 
                        KBAS,   8, 
                        KBDS,   8, 
                        KCBV,   8, 
                        ECID,   8, 
                        KACS,   1, 
                        Offset (0x59), 
                            ,   3, 
                        KLID,   1, 
                            ,   2, 
                        KDCK,   1, 
                        Offset (0x5C), 
                            ,   1, 
                        KLWE,   1, 
                        Offset (0x5D), 
                        KMUT,   1, 
                        Offset (0x5E), 
                            ,   1, 
                        LIDW,   1, 
                            ,   3, 
                        RTCW,   1, 
                        Offset (0x60), 
                        KSPR,   8, 
                        KSST,   8, 
                        KSAD,   8, 
                        KSCM,   8, 
                        KSD0,   32, 
                        KSD1,   32, 
                        KSD2,   32, 
                        KSD3,   32, 
                        KSD4,   32, 
                        KSD5,   32, 
                        KSD6,   32, 
                        KSD7,   32, 
                        Offset (0x88), 
                        KF1S,   1, 
                            ,   3, 
                        KF1C,   1, 
                        Offset (0x89), 
                        KF1P,   8, 
                        Offset (0x8B), 
                        KF1F,   8, 
                        Offset (0x8D), 
                        THID,   3, 
                        Offset (0x91), 
                        KHCL,   1, 
                            ,   3, 
                        KOSD,   1, 
                        KCSS,   1, 
                        KCTT,   1, 
                        KDTT,   1, 
                        Offset (0x96), 
                        KSMC,   4, 
                        Offset (0x97), 
                            ,   4, 
                        TPDW,   1, 
                            ,   2, 
                        KEYW,   1, 
                        Offset (0x9D), 
                            ,   1, 
                        KTPS,   1, 
                        Offset (0xA0), 
                        K0TL,   4, 
                        K0TE,   1, 
                        K0IS,   1, 
                        K0SE,   1, 
                        Offset (0xA1), 
                        K1TL,   4, 
                        K1TE,   1, 
                        K1IS,   1, 
                        K1SE,   1, 
                        Offset (0xA2), 
                        K2TL,   4, 
                        K2TE,   1, 
                        K2IS,   1, 
                        K2SE,   1, 
                        Offset (0xA3), 
                        K3TL,   4, 
                        K3TE,   1, 
                        K3IS,   1, 
                        K3SE,   1, 
                        Offset (0xA4), 
                        K4TL,   4, 
                        K4TE,   1, 
                        K4IS,   1, 
                        K4SE,   1, 
                        Offset (0xA5), 
                        K5TL,   4, 
                        K5TE,   1, 
                        K5IS,   1, 
                        K5SE,   1, 
                        Offset (0xA6), 
                        K6TL,   4, 
                        K6TE,   1, 
                        K6IS,   1, 
                        K6SE,   1, 
                        Offset (0xA7), 
                        K7TL,   4, 
                        K7TE,   1, 
                        K7IS,   1, 
                        K7SE,   1, 
                        Offset (0xA8), 
                        KTS0,   8, 
                        KTS1,   8, 
                        KTS2,   8, 
                        KTS3,   8, 
                        KTS4,   8, 
                        Offset (0xBC), 
                        SPSV,   8, 
                        Offset (0xBE), 
                        SCRT,   8, 
                        Offset (0xC1), 
                            ,   7, 
                        PSEN,   1, 
                        RDOE,   1, 
                        RWWE,   1, 
                        RWLE,   1, 
                        RBTE,   1, 
                        RGPS,   1, 
                        Offset (0xC4), 
                        BLRN,   8, 
                        ACMB,   8, 
                        DCMB,   8, 
                        KBSA,   8, 
                        KDKP,   1, 
                        Offset (0xC9), 
                        Offset (0xCA), 
                        KNVI,   8, 
                        KNVD,   8
                    }

                    Field (RAM, ByteAcc, Lock, Preserve)
                    {
                        Offset (0x91), 
                        KTAF,   8
                    }

                    Field (RAM, ByteAcc, Lock, Preserve)
                    {
                        Offset (0x50), 
                            ,   3, 
                        BNEN,   1, 
                        Offset (0x54), 
                        BNAC,   8, 
                        BNDC,   8
                    }

                    OperationRegion (ECO1, SystemIO, 0x62, One)
                    Field (ECO1, ByteAcc, Lock, Preserve)
                    {
                        PX62,   8
                    }

                    OperationRegion (ECO2, SystemIO, 0x66, One)
                    Field (ECO2, ByteAcc, Lock, Preserve)
                    {
                        PX66,   8
                    }

                    Method (_REG, 2, NotSerialized)  // _REG: Region Availability
                    {
                        If (((Arg0 == 0x03) && (Arg1 == One)))
                        {
                            ECON = One
                            KTAF = Zero
                            ^^^^DOCK.DWAK (0x04)
                            If ((OSYS == 0x07D6))
                            {
                                BNEN = Zero
                            }
                        }

                        ^^^OVGA.CLID = One
                    }

                    Method (HKDS, 1, NotSerialized)
                    {
                        If ((Zero == DSEN))
                        {
                            If ((Arg0 == 0x10))
                            {
                                If (IGDS)
                                {
                                    If (^^^OVGA.ASLS)
                                    {
                                        ^^^OVGA.GHDS (Zero)
                                        Return (Zero)
                                    }
                                }

                                Local0 = PHSR (0x27, Zero)
                                Local0++
                                If ((Local0 >= 0x03))
                                {
                                    Local0 = Zero
                                }
                            }
                            Else
                            {
                                Local0 = Arg0
                            }

                            If ((Local0 == Zero))
                            {
                                NSTE = 0x0101
                            }

                            If ((Local0 == One))
                            {
                                NSTE = 0x0808
                            }

                            If ((Local0 == 0x02))
                            {
                                NSTE = 0x0909
                            }

                            If ((Local0 == 0x03))
                            {
                                NSTE = 0x0404
                            }

                            If ((Local0 == 0x04))
                            {
                                NSTE = 0x0202
                            }

                            If ((Local0 == 0x05))
                            {
                                NSTE = 0x0C0C
                            }

                            If ((Local0 == 0x06))
                            {
                                NSTE = 0x0A0A
                            }

                            If (IGDS)
                            {
                                If (^^^OVGA.ASLS)
                                {
                                    ^^^OVGA.SNDL (NSTE)
                                    ^^^OVGA.GHDS (Zero)
                                }
                                Else
                                {
                                    Notify (OVGA, 0x80) // Status Change
                                }
                            }
                            Else
                            {
                            }
                        }

                        If ((One == DSEN))
                        {
                            If ((Arg0 == 0x10))
                            {
                                PHSR (0x26, Zero)
                            }
                            Else
                            {
                                PHSR (0x28, Arg0)
                            }
                        }
                    }

                    Method (_Q19, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x19
                        HKDS (0x10)
                    }

                    Method (_Q80, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x80
                        HKDS (Zero)
                    }

                    Method (_Q81, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x81
                        HKDS (One)
                    }

                    Method (_Q82, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x82
                        HKDS (0x02)
                    }

                    Method (_Q83, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x83
                        HKDS (0x03)
                    }

                    Method (_Q84, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x84
                        HKDS (0x04)
                    }

                    Method (_Q85, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x85
                        HKDS (0x05)
                    }

                    Method (_Q86, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x86
                        HKDS (0x06)
                    }

                    Method (_Q1A, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x1A
                        Sleep (0x01F4)
                        LAMN (0x06)
                    }

                    Method (_Q22, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x22
                        LAMN (0x07)
                    }

                    Method (_Q13, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x13
                        LAMN (0x11)
                    }

                    Method (_Q1C, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x1C
                        LAMN (0x27)
                        If (BNEN) {}
                        Else
                        {
                            BIAN (0x86)
                        }
                    }

                    Method (_Q1D, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x1D
                        LAMN (0x28)
                        If (BNEN) {}
                        Else
                        {
                            BIAN (0x87)
                        }
                    }

                    Method (_Q30, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x30
                        HKEY (0x30)
                        KDTT = One
                    }

                    Method (_Q31, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x31
                        HKEY (0x31)
                        KDTT = Zero
                    }

                    Method (_Q32, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x32
                        HKEY (0x32)
                        KCTT = Zero
                    }

                    Method (_Q33, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x33
                        KCSS = Zero
                        Notify (\_TZ.TZS0, 0x80) // Thermal Status Change
                        Notify (\_TZ.TZS1, 0x80) // Thermal Status Change
                        Notify (\_TZ.TZS4, 0x80) // Thermal Status Change
                    }

                    Method (_Q34, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x34
                        KCSS = One
                        Notify (\_TZ.TZS0, 0x80) // Thermal Status Change
                        Notify (\_TZ.TZS1, 0x80) // Thermal Status Change
                        Notify (\_TZ.TZS4, 0x80) // Thermal Status Change
                    }

                    Method (_Q35, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x35
                        HKEY (0x35)
                        KCTT = One
                    }

                    Method (_Q36, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x36
                        KOSD = One
                        Sleep (0x01F4)
                        Notify (\_TZ.TZS0, 0x80) // Thermal Status Change
                        Notify (\_TZ.TZS1, 0x80) // Thermal Status Change
                        Notify (\_TZ.TZS3, 0x80) // Thermal Status Change
                        Notify (\_TZ.TZS4, 0x80) // Thermal Status Change
                    }

                    Method (_Q40, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x40
                        B0SS = One
                        Notify (BAT0, 0x81) // Information Change
                    }

                    Method (_Q41, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x41
                        B0SS = Zero
                        Notify (BAT0, 0x81) // Information Change
                    }

                    Method (_Q48, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x48
                        Notify (BAT0, 0x80) // Status Change
                    }

                    Method (_Q4C, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x4C
                        Notify (SLPB, 0x02) // Device Wake
                        If (B0SS)
                        {
                            Notify (BAT0, 0x80) // Status Change
                        }
                    }

                    Method (_Q50, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x50
                        Notify (ADP1, 0x80) // Status Change
                    }

                    Method (_Q51, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x51
                        Notify (ADP1, 0x80) // Status Change
                    }

                    Method (_Q52, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x52
                        LIDS = One
                        Notify (LID0, 0x80) // Status Change
                    }

                    Method (_Q53, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x53
                        LIDS = Zero
                        Notify (LID0, 0x80) // Status Change
                    }

                    Method (_Q56, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x56
                        ^^^^DOCK.DKIN ()
                    }

                    Method (_Q57, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x57
                        ^^^^DOCK.DKOU ()
                    }

                    Method (_Q37, 0, NotSerialized)  // _Qxx: EC Query
                    {
                        P80H = 0x37
                        KHCL = One
                        LAMN (0x72)
                    }

                    Name (B0SS, Zero)
                    Field (RAM, ByteAcc, Lock, Preserve)
                    {
                        Offset (0x57), 
                        NBID,   8, 
                            ,   3, 
                        NBL2,   1, 
                        Offset (0x92), 
                        NB0A,   1, 
                        Offset (0x93), 
                        NB1A,   1, 
                        Offset (0x94), 
                        NB2A,   1, 
                        Offset (0x95), 
                        NB3A,   1
                    }

                    Field (RAM, ByteAcc, Lock, Preserve)
                    {
                        Offset (0x92), 
                        NB0S,   4, 
                        Offset (0x93), 
                        NB1S,   4, 
                        Offset (0x94), 
                        NB2S,   4, 
                        Offset (0x95), 
                        NB3S,   4
                    }

                    Field (RAM, ByteAcc, Lock, Preserve)
                    {
                        Offset (0xB0), 
                        BSMA,   16, 
                        BSCA,   16, 
                        BSTA,   16, 
                            ,   15, 
                        BSCM,   1, 
                        BSFC,   16, 
                        BSDC,   16, 
                        BSDV,   16, 
                        BSSN,   16
                    }

                    Field (RAM, ByteAcc, Lock, Preserve)
                    {
                        Offset (0xB0), 
                        BSVO,   16, 
                        BSAC,   16, 
                        BSPE,   16, 
                        BSRC,   16, 
                        BSRE,   16, 
                        BSAE,   16, 
                        BSAF,   16, 
                        BSBS,   8
                    }

                    Field (RAM, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0xB0), 
                        BSTM,   16, 
                        BSCU,   16, 
                        BSAP,   16, 
                        BSCC,   16, 
                        BSCV,   16, 
                        BSCY,   16, 
                        BSSI,   16, 
                        BSMD,   16
                    }

                    Field (RAM, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0xB0), 
                        BSMN,   128
                    }

                    Field (RAM, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0xB0), 
                        BSDN,   128
                    }

                    Field (RAM, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0xB0), 
                        BSCH,   64, 
                        BSMF,   64
                    }

                    Mutex (BATM, 0x07)
                    Method (GBIF, 3, NotSerialized)
                    {
                        Acquire (BATM, 0xFFFF)
                        If (Arg2)
                        {
                            Index (Arg1, One) = Ones
                            Index (Arg1, 0x02) = Ones
                            Index (Arg1, 0x04) = Ones
                            Index (Arg1, 0x05) = Zero
                            Index (Arg1, 0x06) = Zero
                        }
                        Else
                        {
                            NBID = Arg0
                            Local0 = BSCM /* \_SB_.PCI0.LPC_.EC0_.BSCM */
                            Index (Arg1, Zero) = (Local0 ^ One)
                            If (Local0)
                            {
                                Local1 = (BSDC * 0x0A)
                            }
                            Else
                            {
                                Local1 = BSDC /* \_SB_.PCI0.LPC_.EC0_.BSDC */
                            }

                            Index (Arg1, One) = Local1
                            If (Local0)
                            {
                                Local2 = (BSFC * 0x0A)
                            }
                            Else
                            {
                                Local2 = BSFC /* \_SB_.PCI0.LPC_.EC0_.BSFC */
                            }

                            Index (Arg1, 0x02) = Local2
                            Index (Arg1, 0x04) = BSDV /* \_SB_.PCI0.LPC_.EC0_.BSDV */
                            Divide (Local1, 0x64, Local7, Local6)
                            Local3 = (Local6 * 0x05)
                            Index (Arg1, 0x05) = Local3
                            Local4 = (Local6 * 0x03)
                            Index (Arg1, 0x06) = Local4
                            Index (Arg1, 0x07) = (Local3 - Local4)
                            Index (Arg1, 0x08) = (Local2 - Local3)
                            Local7 = BSSN /* \_SB_.PCI0.LPC_.EC0_.BSSN */
                            Name (SERN, Buffer (0x06)
                            {
                                "     "
                            })
                            Local6 = 0x04
                            While (Local7)
                            {
                                Divide (Local7, 0x0A, Local5, Local7)
                                Index (SERN, Local6) = (Local5 + 0x30)
                                Local6--
                            }

                            Index (Arg1, 0x0A) = SERN /* \_SB_.PCI0.LPC_.EC0_.GBIF.SERN */
                            NBID = (Arg0 | 0x04)
                            Index (Arg1, 0x09) = "VR2 Main Battery"
                            NBID = (Arg0 | 0x05)
                            Index (Arg1, 0x0B) = BSCH /* \_SB_.PCI0.LPC_.EC0_.BSCH */
                            NBID = (Arg0 | 0x03)
                            Index (Arg1, 0x0C) = BSMN /* \_SB_.PCI0.LPC_.EC0_.BSMN */
                        }

                        Release (BATM)
                        Return (Arg1)
                    }

                    Method (GBST, 4, NotSerialized)
                    {
                        Acquire (BATM, 0xFFFF)
                        If ((Arg1 & 0x02))
                        {
                            Local0 = 0x02
                        }
                        Else
                        {
                            If ((Arg1 & 0x04))
                            {
                                Local0 = One
                            }
                            Else
                            {
                                Local0 = Zero
                            }
                        }

                        If (NBL2)
                        {
                            Local0 |= 0x04
                        }

                        If ((Arg1 & One))
                        {
                            NBID = (Arg0 | One)
                            Local1 = BSAC /* \_SB_.PCI0.LPC_.EC0_.BSAC */
                            If (Arg2)
                            {
                                Local2 = (BSRC * 0x0A)
                            }
                            Else
                            {
                                Local2 = BSRC /* \_SB_.PCI0.LPC_.EC0_.BSRC */
                            }

                            Local3 = BSVO /* \_SB_.PCI0.LPC_.EC0_.BSVO */
                            If ((Local1 >= 0x8000))
                            {
                                If ((Local0 & One))
                                {
                                    Local1 -= 0x00010000
                                }
                                Else
                                {
                                    Local1 = Zero
                                }
                            }
                            Else
                            {
                                If (((Local0 & 0x02) == Zero))
                                {
                                    Local1 = Zero
                                }
                            }

                            If (Arg2)
                            {
                                Local1 *= Local3
                                Divide (Local1, 0x03E8, Local7, Local1)
                            }
                        }
                        Else
                        {
                            Local0 = Zero
                            Local1 = Ones
                            Local2 = Ones
                            Local3 = Ones
                        }

                        Index (Arg3, Zero) = Local0
                        Index (Arg3, One) = Local1
                        Index (Arg3, 0x02) = Local2
                        Index (Arg3, 0x03) = Local3
                        Release (BATM)
                        Return (Arg3)
                    }

                    Device (BAT0)
                    {
                        Name (_HID, EisaId ("PNP0C0A") /* Control Method Battery */)  // _HID: Hardware ID
                        Name (_UID, One)  // _UID: Unique ID
                        Method (_PCL, 0, NotSerialized)  // _PCL: Power Consumer List
                        {
                            Return (_SB) /* \_SB_ */
                        }

                        Name (B0IP, Package (0x0D)
                        {
                            One, 
                            Ones, 
                            Ones, 
                            One, 
                            Ones, 
                            Zero, 
                            Zero, 
                            0x5A, 
                            0x5A, 
                            "", 
                            "100", 
                            "Lion", 
                            Zero
                        })
                        Name (B0SP, Package (0x04)
                        {
                            Zero, 
                            Ones, 
                            Zero, 
                            Ones
                        })
                        Method (_STA, 0, NotSerialized)  // _STA: Status
                        {
                            Sleep (0x07)
                            If (ECON)
                            {
                                Local0 = NB0A /* \_SB_.PCI0.LPC_.EC0_.NB0A */
                            }
                            Else
                            {
                                Local0 = (RBEC (0x92) >> Zero)
                                Local0 &= One
                            }

                            B0SS = Local0
                            If (B0SS)
                            {
                                Return (0x1F)
                            }
                            Else
                            {
                                Return (0x0F)
                            }
                        }

                        Method (_BIF, 0, NotSerialized)  // _BIF: Battery Information
                        {
                            Sleep (0x07)
                            Local6 = B0SS /* \_SB_.PCI0.LPC_.EC0_.B0SS */
                            Local7 = 0x14
                            While ((Local6 && Local7))
                            {
                                If ((NB0S & 0x08))
                                {
                                    Sleep (0x01F4)
                                    Local7--
                                }
                                Else
                                {
                                    Local6 = Zero
                                }
                            }

                            Return (GBIF (Zero, B0IP, Local6))
                        }

                        Method (_BST, 0, NotSerialized)  // _BST: Battery Status
                        {
                            Sleep (0x07)
                            Local0 = (DerefOf (Index (B0IP, Zero)) ^ One)
                            Return (GBST (Zero, NB0S, Local0, B0SP))
                        }
                    }

                    Name (ACST, One)
                    Name (LACS, Zero)
                    OperationRegion (GPIO, SystemIO, 0x0500, 0x10)
                    Field (GPIO, ByteAcc, NoLock, Preserve)
                    {
                        GU00,   8, 
                        GU01,   8, 
                        GU02,   8, 
                        GU03,   8, 
                        GIO0,   8, 
                        GIO1,   8, 
                        GIO2,   8, 
                        GIO3,   8, 
                        Offset (0x0C), 
                        GL00,   8, 
                            ,   2, 
                        GP10,   1, 
                        Offset (0x0E), 
                        GL02,   8, 
                        GP24,   1, 
                        Offset (0x10)
                    }

                    Device (ADP1)
                    {
                        Name (_HID, "ACPI0003" /* Power Source Device */)  // _HID: Hardware ID
                        Method (_PSR, 0, NotSerialized)  // _PSR: Power Source
                        {
                            Sleep (0x05)
                            If (ECON)
                            {
                                Local1 = KACS /* \_SB_.PCI0.LPC_.EC0_.KACS */
                            }
                            Else
                            {
                                Local0 = RBEC (0x58)
                                Local1 = (Local0 & One)
                            }

                            If ((Local1 != LACS))
                            {
                                If (Local1)
                                {
                                    If (KDCK)
                                    {
                                        If ((GP24 == Zero))
                                        {
                                            If ((GP10 == Zero))
                                            {
                                                GP24 = One
                                            }
                                        }
                                    }
                                }
                                Else
                                {
                                    GP24 = Zero
                                }
                            }

                            If (Local1)
                            {
                                ACST = One
                                If (KDCK)
                                {
                                    If ((Local1 != LACS))
                                    {
                                        Notify (DOCK, Zero) // Bus Check
                                    }
                                }
                            }
                            Else
                            {
                                ACST = Zero
                                If (KDCK)
                                {
                                    If ((Local1 != LACS))
                                    {
                                        Notify (DOCK, One) // Device Check
                                    }
                                }
                            }

                            If (ECON)
                            {
                                If (BLRN)
                                {
                                    ACST = One
                                    If (KDCK)
                                    {
                                        If ((Local1 != LACS))
                                        {
                                            Notify (DOCK, Zero) // Bus Check
                                        }
                                    }
                                }

                                If (KBDC)
                                {
                                    ACST = One
                                    If (KDCK)
                                    {
                                        If ((Local1 != LACS))
                                        {
                                            Notify (DOCK, Zero) // Bus Check
                                        }
                                    }
                                }
                            }

                            If ((ACST != LACS))
                            {
                                LACS = ACST /* \_SB_.PCI0.LPC_.EC0_.ACST */
                            }

                            Return (ACST) /* \_SB_.PCI0.LPC_.EC0_.ACST */
                        }

                        Method (_PCL, 0, NotSerialized)  // _PCL: Power Consumer List
                        {
                            Return (_SB) /* \_SB_ */
                        }

                        Method (_STA, 0, NotSerialized)  // _STA: Status
                        {
                            Return (0x0F)
                        }
                    }
                }

                Device (KBD0)
                {
                    Name (_HID, EisaId ("PNP0303") /* IBM Enhanced Keyboard (101/102-key, PS/2 Mouse) */)  // _HID: Hardware ID
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x01,               // Alignment
                            0x01,               // Length
                            )
                        IRQ (Edge, ActiveHigh, Exclusive, )
                            {1}
                    })
                    Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                    {
                        If (ECON)
                        {
                            ^^EC0.KEYW = Arg0
                        }
                        Else
                        {
                            If (Arg0)
                            {
                                MBEC (0x97, 0x7F, 0x80)
                            }
                            Else
                            {
                                MBEC (0x97, 0x7F, Zero)
                            }
                        }
                    }

                    Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                    {
                        0x1D, 
                        0x03
                    })
                }

                Device (PS2M)
                {
                    Name (_HID, EisaId ("SYN0306"))  // _HID: Hardware ID
                    Name (_CID, Package (0x03)  // _CID: Compatible ID
                    {
                        EisaId ("SYN0300"), 
                        EisaId ("SYN0002"), 
                        EisaId ("PNP0F13") /* PS/2 Mouse */
                    })
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IRQ (Edge, ActiveHigh, Exclusive, )
                            {12}
                    })
                    Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                    {
                        If (ECON)
                        {
                            ^^EC0.TPDW = Arg0
                        }
                        Else
                        {
                            If (Arg0)
                            {
                                MBEC (0x97, 0xEF, 0x10)
                            }
                            Else
                            {
                                MBEC (0x97, 0xEF, Zero)
                            }
                        }
                    }

                    Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                    {
                        0x1D, 
                        0x03
                    })
                }

                Scope (\_GPE)
                {
                    Method (_L1D, 0, NotSerialized)  // _Lxx: Level-Triggered GPE
                    {
                        P80H = 0x1D
                        Notify (\_SB.SLPB, 0x02) // Device Wake
                    }
                }

                Device (TPM)
                {
                    Name (_HID, EisaId ("IFX0102"))  // _HID: Hardware ID
                    Name (_CID, EisaId ("PNP0C31"))  // _CID: Compatible ID
                    Name (_STR, Unicode ("Infineon Trusted Platform Module"))  // _STR: Description String
                    Name (_CRS, ResourceTemplate ()  // _CRS: Current Resource Settings
                    {
                        IO (Decode16,
                            0x1670,             // Range Minimum
                            0x1670,             // Range Maximum
                            0x01,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0620,             // Range Minimum
                            0x0620,             // Range Maximum
                            0x01,               // Alignment
                            0x0C,               // Length
                            )
                        Memory32Fixed (ReadWrite,
                            0xFED40000,         // Address Base
                            0x00005000,         // Address Length
                            )
                    })
                    OperationRegion (CMOS, SystemIO, 0x70, 0x04)
                    Field (CMOS, ByteAcc, NoLock, Preserve)
                    {
                        IDX0,   7, 
                        Offset (0x01), 
                        DAT0,   8, 
                        IDX1,   7, 
                        Offset (0x03), 
                        DAT1,   8
                    }

                    IndexField (IDX1, DAT1, ByteAcc, NoLock, Preserve)
                    {
                        Offset (0x40), 
                        CCMD,   8, 
                        LCMD,   8, 
                        LRET,   32, 
                        EXST,   8
                    }

                    OperationRegion (SSMI, SystemIO, 0xB2, One)
                    Field (SSMI, ByteAcc, NoLock, Preserve)
                    {
                        SMID,   8
                    }

                    OperationRegion (TPMR, SystemMemory, 0xFED40000, 0x5000)
                    Field (TPMR, AnyAcc, NoLock, Preserve)
                    {
                        ACC0,   8
                    }

                    Method (_INI, 0, NotSerialized)  // _INI: Initialize
                    {
                        If (((OSYS > 0x07D1) || (OSYS < 0x07D6)))
                        {
                            ACC0 |= 0x20
                        }

                        EXST = _STA ()
                    }

                    Method (_STA, 0, NotSerialized)  // _STA: Status
                    {
                        If ((ACC0 == 0xFF))
                        {
                            Return (Zero)
                        }

                        Return (0x0F)
                    }

                    Method (HINF, 3, NotSerialized)
                    {
                        Name (_T_0, Zero)  // _T_x: Emitted by ASL Compiler
                        _T_0 = Arg1
                        If ((_T_0 == Zero))
                        {
                            Return (Buffer (One)
                            {
                                 0x01                                             /* . */
                            })
                        }
                        Else
                        {
                            If ((_T_0 == One))
                            {
                                If ((_STA () == Zero))
                                {
                                    Return (Package (0x01)
                                    {
                                        Zero
                                    })
                                }

                                Return (Package (0x02)
                                {
                                    One, 
                                    Package (0x02)
                                    {
                                        One, 
                                        0x20
                                    }
                                })
                            }
                            Else
                            {
                                BreakPoint
                            }
                        }

                        Return (Buffer (Zero) {})
                    }

                    Method (TPPI, 3, NotSerialized)
                    {
                        Name (_T_0, Zero)  // _T_x: Emitted by ASL Compiler
                        _T_0 = Arg1
                        If ((_T_0 == Zero))
                        {
                            Return (Buffer (One)
                            {
                                 0x3F                                             /* ? */
                            })
                        }
                        Else
                        {
                            If ((_T_0 == One))
                            {
                                Return ("1.0")
                            }
                            Else
                            {
                                If ((_T_0 == 0x02))
                                {
                                    CreateByteField (Arg2, Zero, TPC1)
                                    P80H = TPC1 /* \_SB_.PCI0.LPC_.TPM_.TPPI.TPC1 */
                                    Sleep (0x07D0)
                                    TPCC = (TPC1 | 0x80)
                                    P80H = TPCC /* \TPCC */
                                    Sleep (0x07D0)
                                    SMID = 0x50
                                    P80H = TPCC /* \TPCC */
                                    Sleep (0x07D0)
                                    Return (Zero)
                                }
                                Else
                                {
                                    If ((_T_0 == 0x03))
                                    {
                                        Name (TCCP, Package (0x02)
                                        {
                                            Zero, 
                                            0xFF
                                        })
                                        Index (TCCP, One) = TPCC /* \TPCC */
                                        Return (TCCP) /* \_SB_.PCI0.LPC_.TPM_.TPPI.TCCP */
                                    }
                                    Else
                                    {
                                        If ((_T_0 == 0x04))
                                        {
                                            Return (0x02)
                                        }
                                        Else
                                        {
                                            If ((_T_0 == 0x05))
                                            {
                                                Name (TLCR, Package (0x03)
                                                {
                                                    Zero, 
                                                    0xFF, 
                                                    0xFFFF
                                                })
                                                Index (TLCR, One) = TPLC /* \TPLC */
                                                Index (TLCR, 0x02) = TPLR /* \TPLR */
                                                Return (TLCR) /* \_SB_.PCI0.LPC_.TPM_.TPPI.TLCR */
                                            }
                                            Else
                                            {
                                                If ((_T_0 == 0x06))
                                                {
                                                    Local0 = Index (Arg2, Zero)
                                                    Name (_T_1, Zero)  // _T_x: Emitted by ASL Compiler
                                                    _T_1 = Local0
                                                    If ((_T_1 == "EN"))
                                                    {
                                                        Return (Zero)
                                                    }
                                                    Else
                                                    {
                                                        Return (One)
                                                    }
                                                }
                                                Else
                                                {
                                                    BreakPoint
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        Return (One)
                    }

                    Method (SMOR, 3, NotSerialized)
                    {
                        TPMM = Index (Arg2, Zero)
                        SMID = 0x48
                        Return (Zero)
                    }

                    Method (_DSM, 4, NotSerialized)  // _DSM: Device-Specific Method
                    {
                        If ((Arg0 == ToUUID ("cf8e16a5-c1e8-4e25-b712-4f54a96702c8")))
                        {
                            Return (HINF (Arg1, Arg2, Arg3))
                        }

                        If ((Arg0 == ToUUID ("3dddfaa6-361b-4eb4-a424-8d10089d1653") /* Physical Presence Interface */))
                        {
                            Return (TPPI (Arg1, Arg2, Arg3))
                        }

                        If ((Arg0 == ToUUID ("376054ed-cc13-4675-901c-4756d7f2d45d")))
                        {
                            Return (SMOR (Arg1, Arg2, Arg3))
                        }

                        Return (Buffer (Zero) {})
                    }
                }
            }

            Device (UHC1)
            {
                Name (_ADR, 0x001D0000)  // _ADR: Address
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x03, 
                    0x03
                })
                OperationRegion (USBR, PCI_Config, 0xC4, One)
                Field (USBR, AnyAcc, NoLock, Preserve)
                {
                    URES,   8
                }

                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If ((Arg0 == Zero))
                    {
                        URES = Zero
                    }

                    If ((Arg0 == One))
                    {
                        URES = 0x03
                    }
                }
            }

            Device (UHC2)
            {
                Name (_ADR, 0x001D0001)  // _ADR: Address
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x04, 
                    0x03
                })
                OperationRegion (USBR, PCI_Config, 0xC4, One)
                Field (USBR, AnyAcc, NoLock, Preserve)
                {
                    URES,   8
                }

                OperationRegion (PSCR, SystemIO, 0x8052, One)
                Field (PSCR, AnyAcc, NoLock, Preserve)
                {
                    CCST,   1
                }

                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If ((Arg0 == Zero))
                    {
                        URES = Zero
                    }

                    If ((Arg0 == One))
                    {
                        URES = 0x03
                    }
                }
            }

            Device (UHC3)
            {
                Name (_ADR, 0x001D0002)  // _ADR: Address
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x0C, 
                    0x03
                })
                OperationRegion (USBR, PCI_Config, 0xC4, One)
                Field (USBR, AnyAcc, NoLock, Preserve)
                {
                    URES,   8
                }

                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If ((Arg0 == Zero))
                    {
                        URES = Zero
                    }

                    If ((Arg0 == One))
                    {
                        URES = 0x03
                    }
                }
            }

            Device (UHC4)
            {
                Name (_ADR, 0x001A0000)  // _ADR: Address
                OperationRegion (USBR, PCI_Config, 0xC4, One)
                Field (USBR, AnyAcc, NoLock, Preserve)
                {
                    URES,   8
                }

                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If ((Arg0 == Zero))
                    {
                        URES = Zero
                    }

                    If ((Arg0 == One))
                    {
                        URES = 0x03
                    }
                }

                Method (_S3D, 0, NotSerialized)  // _S3D: S3 Device State
                {
                    Return (0x02)
                }
            }

            Device (UHC5)
            {
                Name (_ADR, 0x001A0001)  // _ADR: Address
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x05, 
                    0x03
                })
                OperationRegion (USBR, PCI_Config, 0xC4, One)
                Field (USBR, AnyAcc, NoLock, Preserve)
                {
                    URES,   8
                }

                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If ((Arg0 == Zero))
                    {
                        URES = Zero
                    }

                    If ((Arg0 == One))
                    {
                        URES = 0x03
                    }
                }
            }

            Device (EHCI)
            {
                Name (_ADR, 0x001D0007)  // _ADR: Address
                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x0D, 
                    0x03
                })
                OperationRegion (USBR, PCI_Config, 0xC4, One)
                Field (USBR, AnyAcc, NoLock, Preserve)
                {
                    URES,   8
                }

                Method (_PSW, 1, NotSerialized)  // _PSW: Power State Wake
                {
                    If ((Arg0 == Zero))
                    {
                        URES = Zero
                    }

                    If ((Arg0 == One))
                    {
                        URES = 0x03
                    }
                }
            }

            Device (EXP1)
            {
                Name (_ADR, 0x001C0000)  // _ADR: Address
                OperationRegion (P1CS, PCI_Config, 0x40, 0x0100)
                Field (P1CS, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x10), 
                        ,   4, 
                    LKD1,   1, 
                    Offset (0x1A), 
                    ABP1,   1, 
                        ,   2, 
                    PDC1,   1, 
                        ,   2, 
                    PDS1,   1, 
                    Offset (0x20), 
                    RID1,   16, 
                    PSP1,   1, 
                    PPP1,   1, 
                    Offset (0x9C), 
                        ,   30, 
                    HPCS,   1, 
                    PMCS,   1
                }

                Device (PXS1)
                {
                    Name (_ADR, Zero)  // _ADR: Address
                    Method (_RMV, 0, NotSerialized)  // _RMV: Removal Status
                    {
                        Return (One)
                    }
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x09, 
                    0x04
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If ((GPIC == Zero))
                    {
                        Return (Package (0x04)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                Zero, 
                                ^^LPC.LNKA, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                One, 
                                ^^LPC.LNKB, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x02, 
                                ^^LPC.LNKC, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x03, 
                                ^^LPC.LNKD, 
                                Zero
                            }
                        })
                    }
                    Else
                    {
                        Return (Package (0x04)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                Zero, 
                                Zero, 
                                0x10
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                One, 
                                Zero, 
                                0x11
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x02, 
                                Zero, 
                                0x12
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x03, 
                                Zero, 
                                0x13
                            }
                        })
                    }
                }
            }

            Device (EXP2)
            {
                Name (_ADR, 0x001C0001)  // _ADR: Address
                OperationRegion (P2CS, PCI_Config, 0x40, 0x0100)
                Field (P2CS, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x10), 
                        ,   4, 
                    LKD2,   1, 
                    Offset (0x1A), 
                    ABP2,   1, 
                        ,   2, 
                    PDC2,   1, 
                        ,   2, 
                    PDS2,   1, 
                    Offset (0x20), 
                    RID2,   16, 
                    PSP2,   1, 
                    PPP2,   1, 
                    Offset (0x9C), 
                        ,   30, 
                    HPCS,   1, 
                    PMCS,   1
                }

                Device (PXS2)
                {
                    Name (_ADR, Zero)  // _ADR: Address
                    Method (_RMV, 0, NotSerialized)  // _RMV: Removal Status
                    {
                        Return (One)
                    }
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x09, 
                    0x04
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If ((GPIC == Zero))
                    {
                        Return (Package (0x04)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                Zero, 
                                ^^LPC.LNKB, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                One, 
                                ^^LPC.LNKC, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x02, 
                                ^^LPC.LNKD, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x03, 
                                ^^LPC.LNKA, 
                                Zero
                            }
                        })
                    }
                    Else
                    {
                        Return (Package (0x04)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                Zero, 
                                Zero, 
                                0x11
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                One, 
                                Zero, 
                                0x12
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x02, 
                                Zero, 
                                0x13
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x03, 
                                Zero, 
                                0x10
                            }
                        })
                    }
                }
            }

            Device (EXP3)
            {
                Name (_ADR, 0x001C0002)  // _ADR: Address
                OperationRegion (P3CS, PCI_Config, 0x40, 0x0100)
                Field (P3CS, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x10), 
                        ,   4, 
                    LKD3,   1, 
                    Offset (0x1A), 
                    ABP3,   1, 
                        ,   2, 
                    PDC3,   1, 
                        ,   2, 
                    PDS3,   1, 
                    Offset (0x20), 
                    RID3,   16, 
                    PSP3,   1, 
                    PPP3,   1, 
                    Offset (0x9C), 
                        ,   30, 
                    HPCS,   1, 
                    PMCS,   1
                }

                Device (PXS3)
                {
                    Name (_ADR, Zero)  // _ADR: Address
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x0B, 
                    0x05
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If ((GPIC == Zero))
                    {
                        Return (Package (0x04)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                Zero, 
                                ^^LPC.LNKC, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                One, 
                                ^^LPC.LNKD, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x02, 
                                ^^LPC.LNKA, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x03, 
                                ^^LPC.LNKB, 
                                Zero
                            }
                        })
                    }
                    Else
                    {
                        Return (Package (0x04)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                Zero, 
                                Zero, 
                                0x12
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                One, 
                                Zero, 
                                0x13
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x02, 
                                Zero, 
                                0x10
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x03, 
                                Zero, 
                                0x11
                            }
                        })
                    }
                }
            }

            Device (EXP4)
            {
                Name (_ADR, 0x001C0003)  // _ADR: Address
                OperationRegion (P4CS, PCI_Config, 0x40, 0x0100)
                Field (P4CS, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x10), 
                        ,   4, 
                    LKD4,   1, 
                    Offset (0x1A), 
                    ABP4,   1, 
                        ,   2, 
                    PDC4,   1, 
                        ,   2, 
                    PDS4,   1, 
                    Offset (0x20), 
                    RID4,   16, 
                    PSP4,   1, 
                    PPP4,   1, 
                    Offset (0x9C), 
                        ,   30, 
                    HPCS,   1, 
                    PMCS,   1
                }

                Device (PXS4)
                {
                    Name (_ADR, Zero)  // _ADR: Address
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x09, 
                    0x04
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If ((GPIC == Zero))
                    {
                        Return (Package (0x04)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                Zero, 
                                ^^LPC.LNKD, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                One, 
                                ^^LPC.LNKA, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x02, 
                                ^^LPC.LNKB, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x03, 
                                ^^LPC.LNKC, 
                                Zero
                            }
                        })
                    }
                    Else
                    {
                        Return (Package (0x04)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                Zero, 
                                Zero, 
                                0x13
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                One, 
                                Zero, 
                                0x10
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x02, 
                                Zero, 
                                0x11
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x03, 
                                Zero, 
                                0x12
                            }
                        })
                    }
                }
            }

            Device (EXP5)
            {
                Name (_ADR, 0x001C0004)  // _ADR: Address
                OperationRegion (P5CS, PCI_Config, 0x40, 0x0100)
                Field (P5CS, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x10), 
                        ,   4, 
                    LKD5,   1, 
                    Offset (0x1A), 
                    ABP5,   1, 
                        ,   2, 
                    PDC5,   1, 
                        ,   2, 
                    PDS5,   1, 
                    Offset (0x20), 
                    RID5,   16, 
                    PSP5,   1, 
                    PPP5,   1, 
                    Offset (0x9C), 
                        ,   30, 
                    HPCS,   1, 
                    PMCS,   1
                }

                Device (PXS5)
                {
                    Name (_ADR, Zero)  // _ADR: Address
                    Method (_RMV, 0, NotSerialized)  // _RMV: Removal Status
                    {
                        Return (One)
                    }
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x09, 
                    0x04
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If ((GPIC == Zero))
                    {
                        Return (Package (0x04)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                Zero, 
                                ^^LPC.LNKA, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                One, 
                                ^^LPC.LNKB, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x02, 
                                ^^LPC.LNKC, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x03, 
                                ^^LPC.LNKD, 
                                Zero
                            }
                        })
                    }
                    Else
                    {
                        Return (Package (0x04)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                Zero, 
                                Zero, 
                                0x10
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                One, 
                                Zero, 
                                0x11
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x02, 
                                Zero, 
                                0x12
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x03, 
                                Zero, 
                                0x13
                            }
                        })
                    }
                }
            }

            Device (EXP6)
            {
                Name (_ADR, 0x001C0005)  // _ADR: Address
                OperationRegion (P6CS, PCI_Config, 0x40, 0x0100)
                Field (P6CS, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x10), 
                        ,   4, 
                    LKD6,   1, 
                    Offset (0x1A), 
                    ABP6,   1, 
                        ,   2, 
                    PDC6,   1, 
                        ,   2, 
                    PDS6,   1, 
                    Offset (0x20), 
                    RID6,   16, 
                    PSP6,   1, 
                    PPP6,   1, 
                    Offset (0x9C), 
                        ,   30, 
                    HPCS,   1, 
                    PMCS,   1
                }

                Device (PXS6)
                {
                    Name (_ADR, Zero)  // _ADR: Address
                    Method (_RMV, 0, NotSerialized)  // _RMV: Removal Status
                    {
                        Return (One)
                    }
                }

                Name (_PRW, Package (0x02)  // _PRW: Power Resources for Wake
                {
                    0x09, 
                    0x04
                })
                Method (_PRT, 0, NotSerialized)  // _PRT: PCI Routing Table
                {
                    If ((GPIC == Zero))
                    {
                        Return (Package (0x04)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                Zero, 
                                ^^LPC.LNKB, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                One, 
                                ^^LPC.LNKC, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x02, 
                                ^^LPC.LNKD, 
                                Zero
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x03, 
                                ^^LPC.LNKA, 
                                Zero
                            }
                        })
                    }
                    Else
                    {
                        Return (Package (0x04)
                        {
                            Package (0x04)
                            {
                                0xFFFF, 
                                Zero, 
                                Zero, 
                                0x11
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                One, 
                                Zero, 
                                0x12
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x02, 
                                Zero, 
                                0x13
                            }, 

                            Package (0x04)
                            {
                                0xFFFF, 
                                0x03, 
                                Zero, 
                                0x10
                            }
                        })
                    }
                }
            }

            Device (AZAL)
            {
                Name (_ADR, 0x001B0000)  // _ADR: Address
                Method (_PRW, 0, NotSerialized)  // _PRW: Power Resources for Wake
                {
                    Return (Package (0x02)
                    {
                        0x0D, 
                        0x04
                    })
                }
            }

            Device (OVGA)
            {
                Name (_ADR, 0x00020000)  // _ADR: Address
                Method (_DOS, 1, NotSerialized)  // _DOS: Disable Output Switching
                {
                    DSEN = (Arg0 & 0x03)
                }

                Method (_DOD, 0, NotSerialized)  // _DOD: Display Output Devices
                {
                    NDID = Zero
                    If ((DIDL != Zero))
                    {
                        DID1 = SDDL (DID1)
                    }

                    If ((DDL2 != Zero))
                    {
                        DID2 = SDDL (DID2)
                    }

                    If ((DDL3 != Zero))
                    {
                        DID3 = SDDL (DID3)
                    }

                    If ((DDL4 != Zero))
                    {
                        DID4 = SDDL (DID4)
                    }

                    If ((DDL5 != Zero))
                    {
                        DID5 = SDDL (DID5)
                    }

                    If ((NDID == One))
                    {
                        Name (TMP1, Package (0x01)
                        {
                            Ones
                        })
                        Index (TMP1, Zero) = (0x00010000 | DID1)
                        Return (TMP1) /* \_SB_.PCI0.OVGA._DOD.TMP1 */
                    }

                    If ((NDID == 0x02))
                    {
                        Name (TMP2, Package (0x02)
                        {
                            Ones, 
                            Ones
                        })
                        Index (TMP2, Zero) = (0x00010000 | DID1)
                        Index (TMP2, One) = (0x00010000 | DID2)
                        Return (TMP2) /* \_SB_.PCI0.OVGA._DOD.TMP2 */
                    }

                    If ((NDID == 0x03))
                    {
                        Name (TMP3, Package (0x03)
                        {
                            Ones, 
                            Ones, 
                            Ones
                        })
                        Index (TMP3, Zero) = (0x00010000 | DID1)
                        Index (TMP3, One) = (0x00010000 | DID2)
                        Index (TMP3, 0x02) = (0x00010000 | DID3)
                        Return (TMP3) /* \_SB_.PCI0.OVGA._DOD.TMP3 */
                    }

                    If ((NDID == 0x04))
                    {
                        Name (TMP4, Package (0x04)
                        {
                            Ones, 
                            Ones, 
                            Ones, 
                            Ones
                        })
                        Index (TMP4, Zero) = (0x00010000 | DID1)
                        Index (TMP4, One) = (0x00010000 | DID2)
                        Index (TMP4, 0x02) = (0x00010000 | DID3)
                        Index (TMP4, 0x03) = (0x00010000 | DID4)
                        Return (TMP4) /* \_SB_.PCI0.OVGA._DOD.TMP4 */
                    }

                    If ((NDID > 0x04))
                    {
                        Name (TMP5, Package (0x05)
                        {
                            Ones, 
                            Ones, 
                            Ones, 
                            Ones, 
                            Ones
                        })
                        Index (TMP5, Zero) = (0x00010000 | DID1)
                        Index (TMP5, One) = (0x00010000 | DID2)
                        Index (TMP5, 0x02) = (0x00010000 | DID3)
                        Index (TMP5, 0x03) = (0x00010000 | DID4)
                        Index (TMP5, 0x04) = (0x00010000 | DID4)
                        Return (TMP5) /* \_SB_.PCI0.OVGA._DOD.TMP5 */
                    }

                    Return (Package (0x01)
                    {
                        0x0400
                    })
                }

                Device (DD01)
                {
                    Method (_ADR, 0, Serialized)  // _ADR: Address
                    {
                        If ((DID1 == Zero))
                        {
                            Return (One)
                        }
                        Else
                        {
                            Return ((0xFFFF & DID1))
                        }
                    }

                    Method (_DCS, 0, NotSerialized)  // _DCS: Display Current Status
                    {
                        Return (CDDS (DID1))
                    }

                    Method (_DGS, 0, NotSerialized)  // _DGS: Display Graphics State
                    {
                        Return (NDDS (DID1))
                    }

                    Method (_DSS, 1, NotSerialized)  // _DSS: Device Set State
                    {
                        If (((Arg0 & 0xC0000000) == 0xC0000000))
                        {
                            CSTE = NSTE /* \NSTE */
                        }
                    }
                }

                Device (DD02)
                {
                    Method (_ADR, 0, Serialized)  // _ADR: Address
                    {
                        If ((DID2 == Zero))
                        {
                            Return (0x02)
                        }
                        Else
                        {
                            Return ((0xFFFF & DID2))
                        }
                    }

                    Method (_DCS, 0, NotSerialized)  // _DCS: Display Current Status
                    {
                        Return (CDDS (DID2))
                    }

                    Method (_DGS, 0, NotSerialized)  // _DGS: Display Graphics State
                    {
                        Return (NDDS (DID2))
                    }

                    Method (_DSS, 1, NotSerialized)  // _DSS: Device Set State
                    {
                        If (((Arg0 & 0xC0000000) == 0xC0000000))
                        {
                            CSTE = NSTE /* \NSTE */
                        }
                    }
                }

                Device (DD03)
                {
                    Method (_ADR, 0, Serialized)  // _ADR: Address
                    {
                        If ((DID3 == Zero))
                        {
                            Return (0x03)
                        }
                        Else
                        {
                            Return ((0xFFFF & DID3))
                        }
                    }

                    Method (_DCS, 0, NotSerialized)  // _DCS: Display Current Status
                    {
                        If ((DID3 == Zero))
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (CDDS (DID3))
                        }
                    }

                    Method (_DGS, 0, NotSerialized)  // _DGS: Display Graphics State
                    {
                        Return (NDDS (DID3))
                    }

                    Method (_DSS, 1, NotSerialized)  // _DSS: Device Set State
                    {
                        If (((Arg0 & 0xC0000000) == 0xC0000000))
                        {
                            CSTE = NSTE /* \NSTE */
                        }
                    }

                    Method (_BCL, 0, NotSerialized)  // _BCL: Brightness Control Levels
                    {
                        Return (\BCLP)
                    }

                    Method (_BCM, 1, NotSerialized)  // _BCM: Brightness Control Method
                    {
                        Local0 = One
                        Local1 = 0x02
                        While (Local0)
                        {
                            If ((Arg0 == DerefOf (Index (\BCLP, Local1))))
                            {
                                Local0 = Zero
                            }
                            Else
                            {
                                Local1++
                                If ((0x11 == Local1))
                                {
                                    Local0 = Zero
                                }
                            }
                        }

                        Local1--
                        Local1--
                        If (^^^LPC.EC0.ACST)
                        {
                            ^^^LPC.EC0.BNAC = Local1
                        }
                        Else
                        {
                            ^^^LPC.EC0.BNDC = Local1
                        }
                    }

                    Method (_BQC, 0, NotSerialized)  // _BQC: Brightness Query Current
                    {
                        If (^^^LPC.EC0.ACST)
                        {
                            Local1 = ^^^LPC.EC0.BNAC /* \_SB_.PCI0.LPC_.EC0_.BNAC */
                        }
                        Else
                        {
                            Local1 = ^^^LPC.EC0.BNDC /* \_SB_.PCI0.LPC_.EC0_.BNDC */
                        }

                        Local1++
                        Local1++
                        Local0 = DerefOf (Index (\BCLP, Local1))
                        Return (Local0)
                    }
                }

                Device (DD04)
                {
                    Method (_ADR, 0, Serialized)  // _ADR: Address
                    {
                        If ((DID4 == Zero))
                        {
                            Return (0x04)
                        }
                        Else
                        {
                            Return ((0xFFFF & DID4))
                        }
                    }

                    Method (_DCS, 0, NotSerialized)  // _DCS: Display Current Status
                    {
                        If ((DID4 == Zero))
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (CDDS (DID4))
                        }
                    }

                    Method (_DGS, 0, NotSerialized)  // _DGS: Display Graphics State
                    {
                        Return (NDDS (DID4))
                    }

                    Method (_DSS, 1, NotSerialized)  // _DSS: Device Set State
                    {
                        If (((Arg0 & 0xC0000000) == 0xC0000000))
                        {
                            CSTE = NSTE /* \NSTE */
                        }
                    }
                }

                Device (DD05)
                {
                    Method (_ADR, 0, Serialized)  // _ADR: Address
                    {
                        If ((DID5 == Zero))
                        {
                            Return (0x05)
                        }
                        Else
                        {
                            Return ((0xFFFF & DID5))
                        }
                    }

                    Method (_DCS, 0, NotSerialized)  // _DCS: Display Current Status
                    {
                        If ((DID5 == Zero))
                        {
                            Return (0x0B)
                        }
                        Else
                        {
                            Return (CDDS (DID5))
                        }
                    }

                    Method (_DGS, 0, NotSerialized)  // _DGS: Display Graphics State
                    {
                        Return (NDDS (DID5))
                    }

                    Method (_DSS, 1, NotSerialized)  // _DSS: Device Set State
                    {
                        If (((Arg0 & 0xC0000000) == 0xC0000000))
                        {
                            CSTE = NSTE /* \NSTE */
                        }
                    }
                }

                Method (SDDL, 1, NotSerialized)
                {
                    NDID++
                    Local0 = (Arg0 & 0x0F0F)
                    Local1 = (0x80000000 | Local0)
                    If ((DIDL == Local0))
                    {
                        Return (Local1)
                    }

                    If ((DDL2 == Local0))
                    {
                        Return (Local1)
                    }

                    If ((DDL3 == Local0))
                    {
                        Return (Local1)
                    }

                    If ((DDL4 == Local0))
                    {
                        Return (Local1)
                    }

                    If ((DDL5 == Local0))
                    {
                        Return (Local1)
                    }

                    If ((DDL6 == Local0))
                    {
                        Return (Local1)
                    }

                    If ((DDL7 == Local0))
                    {
                        Return (Local1)
                    }

                    If ((DDL8 == Local0))
                    {
                        Return (Local1)
                    }

                    Return (Zero)
                }

                Method (CDDS, 1, NotSerialized)
                {
                    If ((CADL == (Arg0 & 0x0F0F)))
                    {
                        Return (0x1F)
                    }

                    If ((CAL2 == (Arg0 & 0x0F0F)))
                    {
                        Return (0x1F)
                    }

                    If ((CAL3 == (Arg0 & 0x0F0F)))
                    {
                        Return (0x1F)
                    }

                    If ((CAL4 == (Arg0 & 0x0F0F)))
                    {
                        Return (0x1F)
                    }

                    If ((CAL5 == (Arg0 & 0x0F0F)))
                    {
                        Return (0x1F)
                    }

                    If ((CAL6 == (Arg0 & 0x0F0F)))
                    {
                        Return (0x1F)
                    }

                    If ((CAL7 == (Arg0 & 0x0F0F)))
                    {
                        Return (0x1F)
                    }

                    If ((CAL8 == (Arg0 & 0x0F0F)))
                    {
                        Return (0x1F)
                    }

                    Return (0x1D)
                }

                Method (NDDS, 1, NotSerialized)
                {
                    If ((NADL == (Arg0 & 0x0F0F)))
                    {
                        Return (One)
                    }

                    If ((NDL2 == (Arg0 & 0x0F0F)))
                    {
                        Return (One)
                    }

                    If ((NDL3 == (Arg0 & 0x0F0F)))
                    {
                        Return (One)
                    }

                    If ((NDL4 == (Arg0 & 0x0F0F)))
                    {
                        Return (One)
                    }

                    If ((NDL5 == (Arg0 & 0x0F0F)))
                    {
                        Return (One)
                    }

                    If ((NDL6 == (Arg0 & 0x0F0F)))
                    {
                        Return (One)
                    }

                    If ((NDL7 == (Arg0 & 0x0F0F)))
                    {
                        Return (One)
                    }

                    If ((NDL8 == (Arg0 & 0x0F0F)))
                    {
                        Return (One)
                    }

                    Return (Zero)
                }

                Scope (^^PCI0)
                {
                    OperationRegion (MCHP, PCI_Config, 0x40, 0xC0)
                    Field (MCHP, AnyAcc, NoLock, Preserve)
                    {
                        Offset (0x60), 
                        TASM,   9, 
                        Offset (0x62)
                    }
                }

                OperationRegion (IGDP, PCI_Config, 0x40, 0xC0)
                Field (IGDP, AnyAcc, NoLock, Preserve)
                {
                    Offset (0x12), 
                        ,   1, 
                    GIVD,   1, 
                        ,   2, 
                    GUMA,   3, 
                    Offset (0x14), 
                        ,   4, 
                    GMFN,   1, 
                    Offset (0x18), 
                    Offset (0xA4), 
                    ASLE,   8, 
                    Offset (0xA8), 
                    GSSE,   1, 
                    GSSB,   14, 
                    GSES,   1, 
                    Offset (0xB0), 
                    Offset (0xB1), 
                    CDVL,   5, 
                    Offset (0xB2), 
                    Offset (0xB5), 
                    LBPC,   8, 
                    Offset (0xBC), 
                    ASLS,   32
                }

                OperationRegion (IGDM, SystemMemory, ASLS, 0x2000)
                Field (IGDM, AnyAcc, NoLock, Preserve)
                {
                    SIGN,   128, 
                    SIZE,   32, 
                    OVER,   32, 
                    SVER,   256, 
                    VVER,   128, 
                    GVER,   128, 
                    MBOX,   32, 
                    Offset (0x100), 
                    DRDY,   32, 
                    CSTS,   32, 
                    CEVT,   32, 
                    Offset (0x120), 
                    DIDL,   32, 
                    DDL2,   32, 
                    DDL3,   32, 
                    DDL4,   32, 
                    DDL5,   32, 
                    DDL6,   32, 
                    DDL7,   32, 
                    DDL8,   32, 
                    CPDL,   32, 
                    CPL2,   32, 
                    CPL3,   32, 
                    CPL4,   32, 
                    CPL5,   32, 
                    CPL6,   32, 
                    CPL7,   32, 
                    CPL8,   32, 
                    CADL,   32, 
                    CAL2,   32, 
                    CAL3,   32, 
                    CAL4,   32, 
                    CAL5,   32, 
                    CAL6,   32, 
                    CAL7,   32, 
                    CAL8,   32, 
                    NADL,   32, 
                    NDL2,   32, 
                    NDL3,   32, 
                    NDL4,   32, 
                    NDL5,   32, 
                    NDL6,   32, 
                    NDL7,   32, 
                    NDL8,   32, 
                    ASLP,   32, 
                    TIDX,   32, 
                    CHPD,   32, 
                    CLID,   32, 
                    CDCK,   32, 
                    SXSW,   32, 
                    EVTS,   32, 
                    CNOT,   32, 
                    NRDY,   32, 
                    Offset (0x200), 
                    SCIE,   1, 
                    GEFC,   4, 
                    GXFC,   3, 
                    GESF,   8, 
                    Offset (0x204), 
                    PARM,   32, 
                    DSLP,   32, 
                    Offset (0x300), 
                    ARDY,   32, 
                    ASLC,   32, 
                    TCHE,   32, 
                    ALSI,   32, 
                    BCLP,   32, 
                    PFIT,   32, 
                    Offset (0x400), 
                    GVD1,   57344
                }

                Name (DBTB, Package (0x15)
                {
                    Zero, 
                    0x07, 
                    0x38, 
                    0x01C0, 
                    0x0E00, 
                    0x3F, 
                    0x01C7, 
                    0x0E07, 
                    0x01F8, 
                    0x0E38, 
                    0x0FC0, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    Zero, 
                    0x7000, 
                    0x7007, 
                    0x7038, 
                    0x71C0, 
                    0x7E00
                })
                Name (CDCT, Package (0x03)
                {
                    Package (0x03)
                    {
                        0xC8, 
                        0x0140, 
                        0x0190
                    }, 

                    Package (0x03)
                    {
                        0xC8, 
                        0x014D, 
                        0x0190
                    }, 

                    Package (0x03)
                    {
                        0xDE, 
                        0x014D, 
                        0x017D
                    }
                })
                Name (SUCC, One)
                Name (NVLD, 0x02)
                Name (CRIT, 0x04)
                Name (NCRT, 0x06)
                Method (GSCI, 0, Serialized)
                {
                    Method (GBDA, 0, Serialized)
                    {
                        If ((GESF == Zero))
                        {
                            PARM = 0x0279
                            GESF = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == One))
                        {
                            PARM = 0x0240
                            GESF = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x04))
                        {
                            PARM &= 0xEFFF0000
                            PARM &= (DerefOf (Index (DBTB, IBTT)) << 0x10)
                            PARM |= IBTT /* \_SB_.PCI0.OVGA.PARM */
                            GESF = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x05))
                        {
                            PARM = IPSC /* \IPSC */
                            PARM |= (IPAT << 0x08)
                            PARM += 0x0100
                            PARM |= (LIDS << 0x10)
                            PARM += 0x00010000
                            PARM |= (IBIA << 0x14)
                            GESF = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x06))
                        {
                            PARM = ITVF /* \ITVF */
                            PARM |= (ITVM << 0x04)
                            GESF = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x07))
                        {
                            PARM = GIVD /* \_SB_.PCI0.OVGA.GIVD */
                            PARM ^= One
                            PARM |= (GMFN << One)
                            PARM |= 0x1000
                            If ((DVGM == 0x80))
                            {
                                PARM |= 0x00020000
                            }
                            Else
                            {
                                If ((DVGM == 0x0100))
                                {
                                    PARM |= 0x00040000
                                }
                                Else
                                {
                                    If ((DVGM == 0x0180))
                                    {
                                        PARM |= 0x00060000
                                    }
                                }
                            }

                            PARM |= (DerefOf (Index (DerefOf (Index (CDCT, HVCO)), (CDVL - 
                                One))) << 0x15) /* \_SB_.PCI0.OVGA.PARM */
                            GESF = One
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x0A))
                        {
                            PARM = Zero
                            If (ISSC)
                            {
                                PARM |= 0x03 /* \_SB_.PCI0.OVGA.PARM */
                            }

                            GESF = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        GESF = Zero
                        Return (CRIT) /* \_SB_.PCI0.OVGA.CRIT */
                    }

                    Method (SBCB, 0, Serialized)
                    {
                        If ((GESF == Zero))
                        {
                            PARM = Zero
                            PARM = 0xF7FD
                            GESF = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == One))
                        {
                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x03))
                        {
                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x04))
                        {
                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x05))
                        {
                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x06))
                        {
                            ITVF = (PARM & 0x0F)
                            ITVM = ((PARM & 0xF0) >> 0x04)
                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x07))
                        {
                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x08))
                        {
                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x09))
                        {
                            IBTT = (PARM & 0xFF)
                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x0A))
                        {
                            IPSC = (PARM & 0xFF)
                            If (((PARM >> 0x08) & 0xFF))
                            {
                                IPAT = ((PARM >> 0x08) & 0xFF)
                                IPAT--
                            }

                            IBIA = ((PARM >> 0x14) & 0x07)
                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x0B))
                        {
                            IF1E = ((PARM >> One) & One)
                            If ((PARM & 0x0001E000))
                            {
                                IDMS = ((PARM >> 0x0D) & 0x0F)
                                IDMM = Zero
                            }
                            Else
                            {
                                IDMS = ((PARM >> 0x11) & 0x0F)
                                IDMM = One
                            }

                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x10))
                        {
                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x11))
                        {
                            PARM = (LIDS << 0x08)
                            PARM += 0x0100
                            GESF = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x12))
                        {
                            If ((PARM & One))
                            {
                                If (((PARM >> One) == One))
                                {
                                    ISSC = One
                                }
                                Else
                                {
                                    GESF = Zero
                                    Return (CRIT) /* \_SB_.PCI0.OVGA.CRIT */
                                }
                            }
                            Else
                            {
                                ISSC = Zero
                            }

                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        If ((GESF == 0x13))
                        {
                            GESF = Zero
                            PARM = Zero
                            Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                        }

                        GESF = Zero
                        Return (SUCC) /* \_SB_.PCI0.OVGA.SUCC */
                    }

                    If ((GEFC == 0x04))
                    {
                        GXFC = GBDA ()
                    }

                    If ((GEFC == 0x06))
                    {
                        GXFC = SBCB ()
                    }

                    GEFC = Zero
                    SCIS = One
                    GSSE = Zero
                    SCIE = Zero
                    Return (Zero)
                }

                Method (PDRD, 0, NotSerialized)
                {
                    If (!DRDY)
                    {
                        Sleep (ASLP)
                    }

                    Return (!DRDY)
                }

                Method (PSTS, 0, NotSerialized)
                {
                    If ((CSTS > 0x02))
                    {
                        Sleep (ASLP)
                    }

                    Return ((CSTS == 0x03))
                }

                Method (GNOT, 2, NotSerialized)
                {
                    If (PDRD ())
                    {
                        Return (One)
                    }

                    If (PSTS ())
                    {
                        Return (One)
                    }

                    CEVT = Arg0
                    CSTS = 0x03
                    If (((CHPD == Zero) && (Arg1 == Zero)))
                    {
                        If (((OSYS > 0x07D0) || (OSYS < 0x07D6)))
                        {
                            Notify (PCI0, Arg1)
                        }
                        Else
                        {
                            Notify (OVGA, Arg1)
                        }
                    }

                    Notify (OVGA, 0x80) // Status Change
                    If (!PSTS ())
                    {
                        CEVT = Zero
                    }

                    Return (Zero)
                }

                Method (GHDS, 1, NotSerialized)
                {
                    TIDX = Arg0
                    Return (GNOT (One, Zero))
                }

                Method (GLID, 1, NotSerialized)
                {
                    CLID = Arg0
                    Return (GNOT (0x02, Zero))
                }

                Method (GDCK, 1, NotSerialized)
                {
                    CDCK = Arg0
                    Return (GNOT (0x04, 0x80))
                }

                Method (PARD, 0, NotSerialized)
                {
                    If (!ARDY)
                    {
                        Sleep (ASLP)
                    }

                    Return (!ARDY)
                }

                Method (AINT, 2, NotSerialized)
                {
                    If (!(TCHE & (One << Arg0)))
                    {
                        Return (One)
                    }

                    If (PARD ())
                    {
                        Return (One)
                    }

                    If ((Arg0 == 0x02))
                    {
                        PFIT ^= 0x07
                        PFIT |= 0x80000000
                        ASLC = 0x04
                    }
                    Else
                    {
                        If ((Arg0 == One))
                        {
                            BCLP = ((Arg1 * 0xFF) / 0x64)
                            BCLP |= 0x80000000
                            ASLC = 0x02
                        }
                        Else
                        {
                            If ((Arg0 == Zero))
                            {
                                ALSI = Arg1
                                ASLC = One
                            }
                            Else
                            {
                                Return (One)
                            }
                        }
                    }

                    LBPC = Zero
                    Return (Zero)
                }

                Method (SCIP, 0, NotSerialized)
                {
                    If ((OVER != Zero))
                    {
                        Return (!GSMI)
                    }

                    Return (Zero)
                }

                Name (NDLC, Zero)
                Method (SNDL, 1, NotSerialized)
                {
                    NDLC = Zero
                    NADL = Zero
                    NDL2 = Zero
                    NDL3 = Zero
                    NDL4 = Zero
                    NDL5 = Zero
                    If ((Arg0 & 0x08))
                    {
                        S2ND (0x0400)
                    }

                    If ((Arg0 & One))
                    {
                        S2ND (0x0100)
                    }

                    If ((Arg0 & 0x02))
                    {
                        S2ND (0x0200)
                    }

                    If ((Arg0 & 0x04))
                    {
                        S2ND (0x0300)
                    }
                }

                Method (S2ND, 1, NotSerialized)
                {
                    NDLC++
                    If ((NDLC == One))
                    {
                        NADL = Arg0
                    }

                    If ((NDLC == 0x02))
                    {
                        NDL2 = Arg0
                    }

                    If ((NDLC == 0x03))
                    {
                        NDL3 = Arg0
                    }

                    If ((NDLC == 0x04))
                    {
                        NDL4 = Arg0
                    }

                    If ((NDLC == 0x05))
                    {
                        NDL5 = Arg0
                    }
                }
            }

            Device (IDEC)
            {
                Name (_ADR, 0x001F0001)  // _ADR: Address
                OperationRegion (PACS, PCI_Config, 0x40, 0xC0)
                Field (PACS, DWordAcc, NoLock, Preserve)
                {
                    PRIT,   16, 
                    Offset (0x04), 
                    PSIT,   4, 
                    Offset (0x08), 
                    SYNC,   4, 
                    Offset (0x0A), 
                    SDT0,   2, 
                        ,   2, 
                    SDT1,   2, 
                    Offset (0x14), 
                    ICR0,   4, 
                    ICR1,   4, 
                    ICR2,   4, 
                    ICR3,   4, 
                    ICR4,   4, 
                    ICR5,   4
                }

                Device (PRID)
                {
                    Name (_ADR, Zero)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        Name (PBUF, Buffer (0x14)
                        {
                            /* 0000 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* ........ */
                            /* 0008 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* ........ */
                            /* 0010 */  0x00, 0x00, 0x00, 0x00                           /* .... */
                        })
                        CreateDWordField (PBUF, Zero, PIO0)
                        CreateDWordField (PBUF, 0x04, DMA0)
                        CreateDWordField (PBUF, 0x08, PIO1)
                        CreateDWordField (PBUF, 0x0C, DMA1)
                        CreateDWordField (PBUF, 0x10, FLAG)
                        PIO0 = GETP (PRIT)
                        DMA0 = GDMA ((SYNC & One), (ICR3 & One), (
                            ICR0 & One), SDT0, (ICR1 & One))
                        If ((DMA0 == Ones))
                        {
                            DMA0 = PIO0 /* \_SB_.PCI0.IDEC.PRID._GTM.PIO0 */
                        }

                        If ((PRIT & 0x4000))
                        {
                            If (((PRIT & 0x90) == 0x80))
                            {
                                PIO1 = 0x0384
                            }
                            Else
                            {
                                PIO1 = GETT (PSIT)
                            }
                        }
                        Else
                        {
                            PIO1 = Ones
                        }

                        DMA1 = GDMA ((SYNC & 0x02), (ICR3 & 0x02), (
                            ICR0 & 0x02), SDT1, (ICR1 & 0x02))
                        If ((DMA1 == Ones))
                        {
                            DMA1 = PIO1 /* \_SB_.PCI0.IDEC.PRID._GTM.PIO1 */
                        }

                        FLAG = GETF ((SYNC & One), (SYNC & 0x02), PRIT)
                        If (((PIO0 == Ones) & (DMA0 == Ones)))
                        {
                            PIO0 = 0x78
                            DMA0 = 0x14
                            FLAG |= 0x03
                        }

                        Return (PBUF) /* \_SB_.PCI0.IDEC.PRID._GTM.PBUF */
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        CreateDWordField (Arg0, Zero, PIO0)
                        CreateDWordField (Arg0, 0x04, DMA0)
                        CreateDWordField (Arg0, 0x08, PIO1)
                        CreateDWordField (Arg0, 0x0C, DMA1)
                        CreateDWordField (Arg0, 0x10, FLAG)
                        If ((SizeOf (Arg1) == 0x0200))
                        {
                            PRIT &= 0x40F0
                            SYNC &= 0x02
                            SDT0 = Zero
                            ICR0 &= 0x02
                            ICR1 &= 0x02
                            ICR3 &= 0x02
                            ICR5 &= 0x02
                            CreateWordField (Arg1, 0x62, W490)
                            CreateWordField (Arg1, 0x6A, W530)
                            CreateWordField (Arg1, 0x7E, W630)
                            CreateWordField (Arg1, 0x80, W640)
                            CreateWordField (Arg1, 0xB0, W880)
                            CreateWordField (Arg1, 0xBA, W930)
                            PRIT |= 0x8004
                            If (((FLAG & 0x02) && (W490 & 0x0800)))
                            {
                                PRIT |= 0x02
                            }

                            PRIT |= SETP (PIO0, W530, W640)
                            If ((FLAG & One))
                            {
                                SYNC |= One
                                SDT0 = SDMA (DMA0)
                                If ((DMA0 < 0x1E))
                                {
                                    ICR3 |= One
                                }

                                If ((DMA0 < 0x3C))
                                {
                                    ICR0 |= One
                                }

                                If ((W930 & 0x2000))
                                {
                                    ICR1 |= One
                                }
                            }
                        }

                        If ((SizeOf (Arg2) == 0x0200))
                        {
                            PRIT &= 0x3F0F
                            PSIT = Zero
                            SYNC &= One
                            SDT1 = Zero
                            ICR0 &= One
                            ICR1 &= One
                            ICR3 &= One
                            ICR5 &= One
                            CreateWordField (Arg2, 0x62, W491)
                            CreateWordField (Arg2, 0x6A, W531)
                            CreateWordField (Arg2, 0x7E, W631)
                            CreateWordField (Arg2, 0x80, W641)
                            CreateWordField (Arg2, 0xB0, W881)
                            CreateWordField (Arg2, 0xBA, W931)
                            PRIT |= 0x8040
                            If (((FLAG & 0x08) && (W491 & 0x0800)))
                            {
                                PRIT |= 0x20
                            }

                            If ((FLAG & 0x10))
                            {
                                PRIT |= 0x4000
                                If ((PIO1 > 0xF0))
                                {
                                    PRIT |= 0x80
                                }
                                Else
                                {
                                    PRIT |= 0x10
                                    PSIT = SETT (PIO1, W531, W641)
                                }
                            }

                            If ((FLAG & 0x04))
                            {
                                SYNC |= 0x02
                                SDT1 = SDMA (DMA1)
                                If ((DMA1 < 0x1E))
                                {
                                    ICR3 |= 0x02
                                }

                                If ((DMA1 < 0x3C))
                                {
                                    ICR0 |= 0x02
                                }

                                If ((W931 & 0x2000))
                                {
                                    ICR1 |= 0x02
                                }
                            }
                        }
                    }

                    Device (P_D0)
                    {
                        Name (_ADR, Zero)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Name (PIB0, Buffer (0x0E)
                            {
                                /* 0000 */  0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF, 0x03,  /* ........ */
                                /* 0008 */  0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF               /* ...... */
                            })
                            CreateByteField (PIB0, One, PMD0)
                            CreateByteField (PIB0, 0x08, DMD0)
                            If ((PRIT & 0x02))
                            {
                                If (((PRIT & 0x09) == 0x08))
                                {
                                    PMD0 = 0x08
                                }
                                Else
                                {
                                    PMD0 = 0x0A
                                    Local0 = ((PRIT & 0x0300) >> 0x08)
                                    Local1 = ((PRIT & 0x3000) >> 0x0C)
                                    Local2 = (Local0 + Local1)
                                    If ((0x03 == Local2))
                                    {
                                        PMD0 = 0x0B
                                    }

                                    If ((0x05 == Local2))
                                    {
                                        PMD0 = 0x0C
                                    }
                                }
                            }
                            Else
                            {
                                PMD0 = One
                            }

                            If ((SYNC & One))
                            {
                                DMD0 = (SDT0 | 0x40)
                                If ((ICR1 & One))
                                {
                                    If ((ICR0 & One))
                                    {
                                        DMD0 += 0x02
                                    }

                                    If ((ICR3 & One))
                                    {
                                        DMD0 = 0x45
                                    }
                                }
                            }
                            Else
                            {
                                DMD0 = (((PMD0 & 0x07) - 0x02) | 0x20)
                            }

                            Return (PIB0) /* \_SB_.PCI0.IDEC.PRID.P_D0._GTF.PIB0 */
                        }
                    }

                    Device (P_D1)
                    {
                        Name (_ADR, One)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            Name (PIB1, Buffer (0x0E)
                            {
                                /* 0000 */  0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF, 0x03,  /* ........ */
                                /* 0008 */  0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF               /* ...... */
                            })
                            CreateByteField (PIB1, One, PMD1)
                            CreateByteField (PIB1, 0x08, DMD1)
                            If ((PRIT & 0x20))
                            {
                                If (((PRIT & 0x90) == 0x80))
                                {
                                    PMD1 = 0x08
                                }
                                Else
                                {
                                    Local0 = ((PSIT & 0x03) + ((PSIT & 0x0C) >> 0x02
                                        ))
                                    If ((0x05 == Local0))
                                    {
                                        PMD1 = 0x0C
                                    }
                                    Else
                                    {
                                        If ((0x03 == Local0))
                                        {
                                            PMD1 = 0x0B
                                        }
                                        Else
                                        {
                                            PMD1 = 0x0A
                                        }
                                    }
                                }
                            }
                            Else
                            {
                                PMD1 = One
                            }

                            If ((SYNC & 0x02))
                            {
                                DMD1 = (SDT1 | 0x40)
                                If ((ICR1 & 0x02))
                                {
                                    If ((ICR0 & 0x02))
                                    {
                                        DMD1 += 0x02
                                    }

                                    If ((ICR3 & 0x02))
                                    {
                                        DMD1 = 0x45
                                    }
                                }
                            }
                            Else
                            {
                                DMD1 = (((PMD1 & 0x07) - 0x02) | 0x20)
                            }

                            Return (PIB1) /* \_SB_.PCI0.IDEC.PRID.P_D1._GTF.PIB1 */
                        }
                    }
                }
            }

            Device (SATA)
            {
                Name (_ADR, 0x001F0002)  // _ADR: Address
                OperationRegion (SACS, PCI_Config, 0x40, 0xC0)
                Field (SACS, DWordAcc, NoLock, Preserve)
                {
                    PRIT,   16, 
                    SECT,   16, 
                    PSIT,   4, 
                    SSIT,   4, 
                    Offset (0x08), 
                    SYNC,   4, 
                    Offset (0x0A), 
                    SDT0,   2, 
                        ,   2, 
                    SDT1,   2, 
                    Offset (0x0B), 
                    SDT2,   2, 
                        ,   2, 
                    SDT3,   2, 
                    Offset (0x14), 
                    ICR0,   4, 
                    ICR1,   4, 
                    ICR2,   4, 
                    ICR3,   4, 
                    ICR4,   4, 
                    ICR5,   4, 
                    Offset (0x50), 
                    MAPV,   2
                }

                Device (PRID)
                {
                    Name (_ADR, Zero)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        If ((SCFG != 0x04))
                        {
                            Name (PBUF, Buffer (0x14)
                            {
                                /* 0000 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* ........ */
                                /* 0008 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* ........ */
                                /* 0010 */  0x00, 0x00, 0x00, 0x00                           /* .... */
                            })
                            CreateDWordField (PBUF, Zero, PIO0)
                            CreateDWordField (PBUF, 0x04, DMA0)
                            CreateDWordField (PBUF, 0x08, PIO1)
                            CreateDWordField (PBUF, 0x0C, DMA1)
                            CreateDWordField (PBUF, 0x10, FLAG)
                            PIO0 = GETP (PRIT)
                            DMA0 = GDMA ((SYNC & One), (ICR3 & One), (
                                ICR0 & One), SDT0, (ICR1 & One))
                            If ((DMA0 == Ones))
                            {
                                DMA0 = PIO0 /* \_SB_.PCI0.SATA.PRID._GTM.PIO0 */
                            }

                            If ((PRIT & 0x4000))
                            {
                                If (((PRIT & 0x90) == 0x80))
                                {
                                    PIO1 = 0x0384
                                }
                                Else
                                {
                                    PIO1 = GETT (PSIT)
                                }
                            }
                            Else
                            {
                                PIO1 = Ones
                            }

                            DMA1 = GDMA ((SYNC & 0x02), (ICR3 & 0x02), (
                                ICR0 & 0x02), SDT1, (ICR1 & 0x02))
                            If ((DMA1 == Ones))
                            {
                                DMA1 = PIO1 /* \_SB_.PCI0.SATA.PRID._GTM.PIO1 */
                            }

                            FLAG = GETF ((SYNC & One), (SYNC & 0x02), PRIT)
                            Return (PBUF) /* \_SB_.PCI0.SATA.PRID._GTM.PBUF */
                        }
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        If ((SCFG != 0x04))
                        {
                            CreateDWordField (Arg0, Zero, PIO0)
                            CreateDWordField (Arg0, 0x04, DMA0)
                            CreateDWordField (Arg0, 0x08, PIO1)
                            CreateDWordField (Arg0, 0x0C, DMA1)
                            CreateDWordField (Arg0, 0x10, FLAG)
                            If ((SizeOf (Arg1) == 0x0200))
                            {
                                PRIT &= 0x40F0
                                SYNC &= 0x0E
                                SDT0 = Zero
                                ICR0 &= 0x0E
                                ICR1 &= 0x0E
                                ICR3 &= 0x0E
                                ICR5 &= 0x0E
                                CreateWordField (Arg1, 0x62, W490)
                                CreateWordField (Arg1, 0x6A, W530)
                                CreateWordField (Arg1, 0x7E, W630)
                                CreateWordField (Arg1, 0x80, W640)
                                CreateWordField (Arg1, 0xB0, W880)
                                CreateWordField (Arg1, 0xBA, W930)
                                PRIT |= 0x8004
                                If (((FLAG & 0x02) && (W490 & 0x0800)))
                                {
                                    PRIT |= 0x02
                                }

                                PRIT |= SETP (PIO0, W530, W640)
                                If ((FLAG & One))
                                {
                                    SYNC |= One
                                    SDT0 = SDMA (DMA0)
                                    If ((DMA0 < 0x1E))
                                    {
                                        ICR3 |= One
                                    }

                                    If ((DMA0 < 0x3C))
                                    {
                                        ICR0 |= One
                                    }

                                    ICR1 |= One
                                }
                            }

                            If ((SizeOf (Arg2) == 0x0200))
                            {
                                PRIT &= 0x3F0F
                                PSIT = Zero
                                SYNC &= 0x0D
                                SDT1 = Zero
                                ICR0 &= 0x0D
                                ICR1 &= 0x0D
                                ICR3 &= 0x0D
                                ICR5 &= 0x0D
                                CreateWordField (Arg2, 0x62, W491)
                                CreateWordField (Arg2, 0x6A, W531)
                                CreateWordField (Arg2, 0x7E, W631)
                                CreateWordField (Arg2, 0x80, W641)
                                CreateWordField (Arg2, 0xB0, W881)
                                CreateWordField (Arg2, 0xBA, W931)
                                PRIT |= 0x8040
                                If (((FLAG & 0x08) && (W491 & 0x0800)))
                                {
                                    PRIT |= 0x20
                                }

                                If ((FLAG & 0x10))
                                {
                                    PRIT |= 0x4000
                                    If ((PIO1 > 0xF0))
                                    {
                                        PRIT |= 0x80
                                    }
                                    Else
                                    {
                                        PRIT |= 0x10
                                        PSIT = SETT (PIO1, W531, W641)
                                    }
                                }

                                If ((FLAG & 0x04))
                                {
                                    SYNC |= 0x02
                                    SDT1 = SDMA (DMA1)
                                    If ((DMA1 < 0x1E))
                                    {
                                        ICR3 |= 0x02
                                    }

                                    If ((DMA1 < 0x3C))
                                    {
                                        ICR0 |= 0x02
                                    }

                                    ICR1 |= 0x02
                                }
                            }
                        }
                    }

                    Device (P_D0)
                    {
                        Name (_ADR, Zero)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            If ((SCFG != 0x04))
                            {
                                Name (PIB0, Buffer (0x0E)
                                {
                                    /* 0000 */  0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF, 0x03,  /* ........ */
                                    /* 0008 */  0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF               /* ...... */
                                })
                                CreateByteField (PIB0, One, PMD0)
                                CreateByteField (PIB0, 0x08, DMD0)
                                If ((PRIT & 0x02))
                                {
                                    If (((PRIT & 0x09) == 0x08))
                                    {
                                        PMD0 = 0x08
                                    }
                                    Else
                                    {
                                        PMD0 = 0x0A
                                        Local0 = ((PRIT & 0x0300) >> 0x08)
                                        Local1 = ((PRIT & 0x3000) >> 0x0C)
                                        Local2 = (Local0 + Local1)
                                        If ((0x03 == Local2))
                                        {
                                            PMD0 = 0x0B
                                        }

                                        If ((0x05 == Local2))
                                        {
                                            PMD0 = 0x0C
                                        }
                                    }
                                }
                                Else
                                {
                                    PMD0 = One
                                }

                                If ((SYNC & One))
                                {
                                    DMD0 = (SDT0 | 0x40)
                                    If ((ICR1 & One))
                                    {
                                        If ((ICR0 & One))
                                        {
                                            DMD0 += 0x02
                                        }

                                        If ((ICR3 & One))
                                        {
                                            DMD0 = 0x45
                                        }
                                    }
                                }
                                Else
                                {
                                    DMD0 = (((PMD0 & 0x07) - 0x02) | 0x20)
                                }

                                Return (PIB0) /* \_SB_.PCI0.SATA.PRID.P_D0._GTF.PIB0 */
                            }
                        }
                    }

                    Device (P_D1)
                    {
                        Name (_ADR, One)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            If ((SCFG != 0x04))
                            {
                                Name (PIB1, Buffer (0x0E)
                                {
                                    /* 0000 */  0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF, 0x03,  /* ........ */
                                    /* 0008 */  0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF               /* ...... */
                                })
                                CreateByteField (PIB1, One, PMD1)
                                CreateByteField (PIB1, 0x08, DMD1)
                                If ((PRIT & 0x20))
                                {
                                    If (((PRIT & 0x90) == 0x80))
                                    {
                                        PMD1 = 0x08
                                    }
                                    Else
                                    {
                                        Local0 = ((PSIT & 0x03) + ((PSIT & 0x0C) >> 0x02
                                            ))
                                        If ((0x05 == Local0))
                                        {
                                            PMD1 = 0x0C
                                        }
                                        Else
                                        {
                                            If ((0x03 == Local0))
                                            {
                                                PMD1 = 0x0B
                                            }
                                            Else
                                            {
                                                PMD1 = 0x0A
                                            }
                                        }
                                    }
                                }
                                Else
                                {
                                    PMD1 = One
                                }

                                If ((SYNC & 0x02))
                                {
                                    DMD1 = (SDT1 | 0x40)
                                    If ((ICR1 & 0x02))
                                    {
                                        If ((ICR0 & 0x02))
                                        {
                                            DMD1 += 0x02
                                        }

                                        If ((ICR3 & 0x02))
                                        {
                                            DMD1 = 0x45
                                        }
                                    }
                                }
                                Else
                                {
                                    DMD1 = (((PMD1 & 0x07) - 0x02) | 0x20)
                                }

                                Return (PIB1) /* \_SB_.PCI0.SATA.PRID.P_D1._GTF.PIB1 */
                            }
                        }
                    }
                }

                Device (SECD)
                {
                    Name (_ADR, One)  // _ADR: Address
                    Method (_GTM, 0, NotSerialized)  // _GTM: Get Timing Mode
                    {
                        If ((SCFG != 0x04))
                        {
                            Name (SBUF, Buffer (0x14)
                            {
                                /* 0000 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* ........ */
                                /* 0008 */  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* ........ */
                                /* 0010 */  0x00, 0x00, 0x00, 0x00                           /* .... */
                            })
                            CreateDWordField (SBUF, Zero, PIO0)
                            CreateDWordField (SBUF, 0x04, DMA0)
                            CreateDWordField (SBUF, 0x08, PIO1)
                            CreateDWordField (SBUF, 0x0C, DMA1)
                            CreateDWordField (SBUF, 0x10, FLAG)
                            PIO0 = GETP (SECT)
                            DMA0 = GDMA ((SYNC & 0x04), (ICR3 & 0x04), (
                                ICR0 & 0x04), SDT2, (ICR1 & 0x04))
                            If ((DMA0 == Ones))
                            {
                                DMA0 = PIO0 /* \_SB_.PCI0.SATA.SECD._GTM.PIO0 */
                            }

                            If ((SECT & 0x4000))
                            {
                                If (((SECT & 0x90) == 0x80))
                                {
                                    PIO1 = 0x0384
                                }
                                Else
                                {
                                    PIO1 = GETT (SSIT)
                                }
                            }
                            Else
                            {
                                PIO1 = Ones
                            }

                            DMA1 = GDMA ((SYNC & 0x08), (ICR3 & 0x08), (
                                ICR0 & 0x08), SDT3, (ICR1 & 0x08))
                            If ((DMA1 == Ones))
                            {
                                DMA1 = PIO1 /* \_SB_.PCI0.SATA.SECD._GTM.PIO1 */
                            }

                            FLAG = GETF ((SYNC & 0x04), (SYNC & 0x08), SECT)
                            If (((PIO0 == Ones) & (DMA0 == Ones)))
                            {
                                PIO0 = 0x78
                                DMA0 = 0x14
                                FLAG = 0x03
                            }

                            Return (SBUF) /* \_SB_.PCI0.SATA.SECD._GTM.SBUF */
                        }
                    }

                    Method (_STM, 3, NotSerialized)  // _STM: Set Timing Mode
                    {
                        If ((SCFG != 0x04))
                        {
                            CreateDWordField (Arg0, Zero, PIO0)
                            CreateDWordField (Arg0, 0x04, DMA0)
                            CreateDWordField (Arg0, 0x08, PIO1)
                            CreateDWordField (Arg0, 0x0C, DMA1)
                            CreateDWordField (Arg0, 0x10, FLAG)
                            If ((SizeOf (Arg1) == 0x0200))
                            {
                                SECT &= 0x40F0
                                SYNC &= 0x0B
                                SDT2 = Zero
                                ICR0 &= 0x0B
                                ICR1 &= 0x0B
                                ICR3 &= 0x0B
                                ICR5 &= 0x0B
                                CreateWordField (Arg1, 0x62, W490)
                                CreateWordField (Arg1, 0x6A, W530)
                                CreateWordField (Arg1, 0x7E, W630)
                                CreateWordField (Arg1, 0x80, W640)
                                CreateWordField (Arg1, 0xB0, W880)
                                CreateWordField (Arg1, 0xBA, W930)
                                SECT |= 0x8004
                                If (((FLAG & 0x02) && (W490 & 0x0800)))
                                {
                                    SECT |= 0x02
                                }

                                SECT |= SETP (PIO0, W530, W640)
                                If ((FLAG & One))
                                {
                                    SYNC |= 0x04
                                    SDT2 = SDMA (DMA0)
                                    If ((DMA0 < 0x1E))
                                    {
                                        ICR3 |= 0x04
                                    }

                                    If ((DMA0 < 0x3C))
                                    {
                                        ICR0 |= 0x04
                                    }

                                    If ((W930 & 0x2000))
                                    {
                                        ICR1 |= 0x04
                                    }
                                }
                            }

                            If ((SizeOf (Arg2) == 0x0200))
                            {
                                SECT &= 0x3F0F
                                SSIT = Zero
                                SYNC &= 0x07
                                SDT3 = Zero
                                ICR0 &= 0x07
                                ICR1 &= 0x07
                                ICR3 &= 0x07
                                ICR5 &= 0x07
                                CreateWordField (Arg2, 0x62, W491)
                                CreateWordField (Arg2, 0x6A, W531)
                                CreateWordField (Arg2, 0x7E, W631)
                                CreateWordField (Arg2, 0x80, W641)
                                CreateWordField (Arg2, 0xB0, W881)
                                CreateWordField (Arg2, 0xBA, W931)
                                SECT |= 0x8040
                                If (((FLAG & 0x08) && (W491 & 0x0800)))
                                {
                                    SECT |= 0x20
                                }

                                If ((FLAG & 0x10))
                                {
                                    SECT |= 0x4000
                                    If ((PIO1 > 0xF0))
                                    {
                                        SECT |= 0x80
                                    }
                                    Else
                                    {
                                        SECT |= 0x10
                                        SSIT = SETT (PIO1, W531, W641)
                                    }
                                }

                                If ((FLAG & 0x04))
                                {
                                    SYNC |= 0x08
                                    SDT3 = SDMA (DMA1)
                                    If ((DMA1 < 0x1E))
                                    {
                                        ICR3 |= 0x08
                                    }

                                    If ((DMA1 < 0x3C))
                                    {
                                        ICR0 |= 0x08
                                    }

                                    If ((W931 & 0x2000))
                                    {
                                        ICR1 |= 0x08
                                    }
                                }
                            }
                        }
                    }

                    Device (S_D0)
                    {
                        Name (_ADR, Zero)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            If ((SCFG != 0x04))
                            {
                                Name (SIB0, Buffer (0x0E)
                                {
                                    /* 0000 */  0x03, 0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF, 0x03,  /* ........ */
                                    /* 0008 */  0x00, 0x00, 0x00, 0x00, 0xA0, 0xEF               /* ...... */
                                })
                                CreateByteField (SIB0, One, PMD0)
                                CreateByteField (SIB0, 0x08, DMD0)
                                If ((SECT & 0x02))
                                {
                                    If (((SECT & 0x09) == 0x08))
                                    {
                                        PMD0 = 0x08
                                    }
                                    Else
                                    {
                                        PMD0 = 0x0A
                                        Local0 = ((SECT & 0x0300) >> 0x08)
                                        Local1 = ((SECT & 0x3000) >> 0x0C)
                                        Local2 = (Local0 + Local1)
                                        If ((0x03 == Local2))
                                        {
                                            PMD0 = 0x0B
                                        }

                                        If ((0x05 == Local2))
                                        {
                                            PMD0 = 0x0C
                                        }
                                    }
                                }
                                Else
                                {
                                    PMD0 = One
                                }

                                If ((SYNC & 0x04))
                                {
                                    DMD0 = (SDT2 | 0x40)
                                    If ((ICR1 & 0x04))
                                    {
                                        If ((ICR0 & 0x04))
                                        {
                                            DMD0 += 0x02
                                        }

                                        If ((ICR3 & 0x04))
                                        {
                                            DMD0 = 0x45
                                        }
                                    }
                                }
                                Else
                                {
                                    DMD0 = (((PMD0 & 0x07) - 0x02) | 0x20)
                                }

                                Return (SIB0) /* \_SB_.PCI0.SATA.SECD.S_D0._GTF.SIB0 */
                            }
                        }
                    }

                    Device (S_D1)
                    {
                        Name (_ADR, One)  // _ADR: Address
                        Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                        {
                            If ((SCFG != 0x04))
                            {
                                Name (SIB1, Buffer (0x0E)
                                {
                                    /* 0000 */  0x03, 0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF, 0x03,  /* ........ */
                                    /* 0008 */  0x00, 0x00, 0x00, 0x00, 0xB0, 0xEF               /* ...... */
                                })
                                CreateByteField (SIB1, One, PMD1)
                                CreateByteField (SIB1, 0x08, DMD1)
                                If ((SECT & 0x20))
                                {
                                    If (((SECT & 0x90) == 0x80))
                                    {
                                        PMD1 = 0x08
                                    }
                                    Else
                                    {
                                        Local0 = ((SSIT & 0x03) + ((SSIT & 0x0C) >> 0x02
                                            ))
                                        If ((0x05 == Local0))
                                        {
                                            PMD1 = 0x0C
                                        }
                                        Else
                                        {
                                            If ((0x03 == Local0))
                                            {
                                                PMD1 = 0x0B
                                            }
                                            Else
                                            {
                                                PMD1 = 0x0A
                                            }
                                        }
                                    }
                                }
                                Else
                                {
                                    PMD1 = One
                                }

                                If ((SYNC & 0x08))
                                {
                                    DMD1 = (SDT3 | 0x40)
                                    If ((ICR1 & 0x08))
                                    {
                                        If ((ICR0 & 0x08))
                                        {
                                            DMD1 += 0x02
                                        }

                                        If ((ICR3 & 0x08))
                                        {
                                            DMD1 = 0x45
                                        }
                                    }
                                }
                                Else
                                {
                                    DMD1 = (((PMD1 & 0x07) - 0x02) | 0x20)
                                }

                                Return (SIB1) /* \_SB_.PCI0.SATA.SECD.S_D1._GTF.SIB1 */
                            }
                        }
                    }
                }

                Device (PRT0)
                {
                    Name (_ADR, 0xFFFF)  // _ADR: Address
                    Method (_SDD, 1, NotSerialized)  // _SDD: Set Device Data
                    {
                        If ((SCFG == 0x04))
                        {
                            Name (GBU0, Buffer (0x07)
                            {
                                 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x00         /* ....... */
                            })
                            CreateByteField (GBU0, Zero, GB00)
                            CreateByteField (GBU0, One, GB01)
                            CreateByteField (GBU0, 0x02, GB02)
                            CreateByteField (GBU0, 0x03, GB03)
                            CreateByteField (GBU0, 0x04, GB04)
                            CreateByteField (GBU0, 0x05, GB05)
                            CreateByteField (GBU0, 0x06, GB06)
                            If ((SizeOf (Arg0) == 0x0200))
                            {
                                CreateWordField (Arg0, 0x9C, W780)
                                CreateWordField (Arg0, 0x9E, W790)
                                If ((W780 && 0x04))
                                {
                                    If (((W790 & 0x04) == Zero))
                                    {
                                        GB00 = 0x10
                                        GB01 = 0x03
                                        GB06 = 0xEF
                                    }
                                }
                            }

                            GTF0 = GBU0 /* \_SB_.PCI0.SATA.PRT0._SDD.GBU0 */
                        }
                    }

                    Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                    {
                        If (((SCFG == 0x04) && (AIBT == Zero)))
                        {
                            Return (GTF0) /* \GTF0 */
                        }
                    }
                }

                Device (PRT2)
                {
                    Name (_ADR, 0x0002FFFF)  // _ADR: Address
                    Method (_SDD, 1, NotSerialized)  // _SDD: Set Device Data
                    {
                        If ((SCFG == 0x04))
                        {
                            Name (GBU2, Buffer (0x07)
                            {
                                 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x00         /* ....... */
                            })
                            CreateByteField (GBU2, Zero, GB20)
                            CreateByteField (GBU2, One, GB21)
                            CreateByteField (GBU2, 0x02, GB22)
                            CreateByteField (GBU2, 0x03, GB23)
                            CreateByteField (GBU2, 0x04, GB24)
                            CreateByteField (GBU2, 0x05, GB25)
                            CreateByteField (GBU2, 0x06, GB26)
                            If ((SizeOf (Arg0) == 0x0200))
                            {
                                CreateWordField (Arg0, 0x9C, W782)
                                CreateWordField (Arg0, 0x9E, W792)
                                If ((W782 && 0x04))
                                {
                                    If (((W792 & 0x04) == Zero))
                                    {
                                        GB20 = 0x10
                                        GB21 = 0x03
                                        GB26 = 0xEF
                                    }
                                }
                            }

                            GTF2 = GBU2 /* \_SB_.PCI0.SATA.PRT2._SDD.GBU2 */
                        }
                    }

                    Method (_GTF, 0, NotSerialized)  // _GTF: Get Task File
                    {
                        If (((SCFG == 0x04) && (AIBT == Zero)))
                        {
                            Return (GTF2) /* \GTF2 */
                        }
                    }
                }
            }
        }
    }
}

