#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>

#include <stdio.h>

int main()
{
    int fd = open ("/dev/urandom", O_RDONLY);
    if (fd == -1) {
	fprintf (stderr, "Cannot open /dev/urandom\n");
	return -1;
    }
    int flags = fcntl (fd, F_GETFL);
    if (fcntl (fd, F_SETFL, flags | O_NONBLOCK) == -1)
        fprintf (stderr, "fcntl returns -1 on devices\n");
    close (fd);
    return 0;
}
