#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>

#include <stdio.h>

int main()
{
    int fd1 = fileno (stdin);
    int fd2 = fileno (stdout);
    int fds[2]; fds[0] = fd1; fds[1] = fd2;
    int fd = pipe (fds);
    if (fd == -1) {
        fprintf (stderr, "Cannot create a pipe\n");
	return -1;
    }
    int flags = fcntl (fd, F_GETFL);
    if (fcntl (fd, F_SETFL, flags | O_NONBLOCK) == -1)
        fprintf (stderr, "fcntl returns -1 on pipes\n");
    close (fd);
    return 0;
}
