#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>

#include <sys/soundcard.h>

#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <stdio.h>

#define N (44100*2*2)

int main()
{
    int16_t *silence = malloc (N);
    memset (silence, 0, N);

    int fd = open ("/dev/dsp", O_RDWR|O_NONBLOCK);
    if (fd == -1)
    {
	printf ("Cannot open the device\n");
	return -1;
    }

    int format = AFMT_S16_LE;
    if (ioctl (fd, SNDCTL_DSP_SETFMT, &format) == -1)
    {
        fprintf (stderr, "Cannot set format\n");
        return -1;
    }
    
    int channels = 1;
    if (ioctl (fd, SNDCTL_DSP_CHANNELS, &channels) == -1)
    {
        fprintf (stderr, "Cannot set channels\n");
        return -1;
    }

    int speed = 44100;
    if (ioctl (fd, SNDCTL_DSP_SPEED, &speed) == -1)
    {
        fprintf (stderr, "Cannot set speed\n");
        return -1;
    }

    int flags = fcntl (fd, F_GETFL);
    if (fcntl (fd, F_SETFL, flags & ~O_NONBLOCK) == -1)
    {
        fprintf (stderr, "Cannot set blocking mode\n");
        return -1;
    }

    int i;
    for (i=0; i<3; i++) {
	if (write (fd, silence, N) == -1) {
		fprintf (stderr, "Write failed\n");
		return -1;
	}
    }

    close (fd);
    free (silence);
    return 0;
}
