#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>

int main() {
	int rc;
	int sock;
	int fd;
	struct sockaddr_in addr;
	struct in_addr ip_addr;
	ssize_t sent;
	size_t cursor;
	off_t sbytes;
	
	const char *header = "POST /feed HTTP/1.1\r\nHost: feedee\r\nContent-Length: 16275\r\nConnection: close\r\n\r\n";

	rc = inet_aton("127.0.0.1", &ip_addr);
	if (rc == 0) {
		perror("inet_aton");
		return -1;
	}

	addr.sin_family = AF_INET;
	addr.sin_addr = ip_addr;
	addr.sin_port = (in_port_t) htons(8089);

	sock = socket(PF_INET, SOCK_STREAM, 0);
	if (sock == -1) {
		perror("socket");
		return -1;
	}

	rc = connect(sock, &addr, sizeof (addr));
	if (rc == -1) {
		perror("connect");
		return -1;
	}

	cursor = 0;
	while (cursor < strlen(header)) {
		sent = send(sock, header, strlen(header) - cursor, 0);
		if (sent == -1) {
			perror("send");
			return -1;
		}
		cursor += sent;
	}

	fd = open("sendfile_case.data", O_RDONLY);
	if (fd == -1) {
		perror("open");
		return -1;
	}

	sbytes = 0;
	rc = sendfile(fd, sock, 0, 16275, NULL, &sbytes, 0);
	if (rc == -1) {
		perror("sendfile");
		return -1;
	}

	fprintf(stderr, "sbytes = %i\n", (int) sbytes);
		

	return 0;
}
