#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <errno.h>

// On Linux
#if !defined(SIZE_MAX)
#define SIZE_MAX __SIZE_MAX__		// ((size_t)-1) = 9223372036854775807 = LONG_MAX
#endif
// On DragonFlyBSD
//#define SIZE_MAX UINT64_MAX  // from /usr/include/machine/int_limits.h

int main () {
  printf("SIZE_MAX=%lu\n", SIZE_MAX);
  
  unsigned long tests[] = {
    9223372036854775807UL,
    223372036854775808UL,
    23372036854775808UL,
    3372036854775808UL,
    372036854775808UL,
    0x7ff7bf77f001UL,
    0x7ff7bf77f000UL,
    72036854775808UL,
    2036854775808UL,
    36854775808UL,
    INTPTR_MAX,
    UINTPTR_MAX,
    SIZE_MAX - 2,
    SIZE_MAX,
    SIZE_MAX + 'a',
    SIZE_MAX + SIZE_MAX,
    SIZE_MAX * 20
  };
  
  for (int test = 0; test < 16; test++) {
//  for (int test = 0; test < 2; test++) {
    printf("test%d: malloc size:%lu, ", test, tests[test]);

    uint *ptr = (int *) malloc(tests[test]);
    if (ptr == NULL) {
        printf("malloc failed, ptr == NULL, errno:%d\n", errno);
    } else {
        printf(" ptr == %p\n", ptr);
        free(ptr);
        ptr = NULL;
    }
  }
  return 0;
}
